/* 
   Copyright 1994-2003 Free Software Foundation, Inc.

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Lesser General Public License for more details.

   You should have received a copy of the GNU Lesser General Public
   License along with this library; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 
   USA

   You may contact the author at:

   mailto::camille@bluegrass.net

   or by snail mail at:

   David Lindauer
   850 Washburn Ave Apt 99
   Louisville, KY 40222
*/
#include <string.h>
#include <io.h>
#include <fcntl.h>
#include <time.h>
#include <stdio.h>
#include <libp.h>
#include <dpmi.h>
#include <llp.h>
#include <sys\stat.h>

extern int _uihandles[HANDLE_MAX] ;

void _ll_uioinit(void)
{
   _uihandles[0] = 0 ;
   _uihandles[1] = 1 ;
   _uihandles[2] = 2 ;

}
int _ll_chmod(char *path, int amode)
{
	DPMI_REGS regs;
   regs.b.al = 1 ;
   regs.h.dx = __nametodta(path,0);
   regs.h.cx = (amode & S_IWRITE) ? 0 : 1 ;
   __doscall(0x43,&regs);
	if (regs.h.flags & 1)
		return -1;
	return 0;
}

int _ll_chsize(int handle, int size)
{
   DPMI_REGS regs ;
   int old = _ll_getpos(handle) ;
   char buf[256] ;
   int len ;
   int rv ;
   if (old == -1)
      return old ;
   len = _ll_seek(handle,0,SEEK_END) ;
   if (len == -1)
      return len ;
   len = _ll_getpos(handle) ;
   if (len == -1)
      return len ;
   if (len != size) {
      if (len < size) {
         memset(buf,0,256) ;
         len = size - len ;
         while (len >= 256) {
            rv = _ll_write(handle,buf,256) ;
            if (rv == -1 || rv != 256)
               return -1 ;
            len -= 256 ;
         }
         if (len) {
            rv = _ll_write(handle,buf,len) ;
            if (rv == -1 || rv != len)
               return -1 ;
         }
      } else {
         if (_ll_seek(handle,size,SEEK_SET) == -1)
            return -1 ;
         rv = _ll_write(handle,buf,0) ;
         if (rv == -1)
            return rv ;
      }
   }
   return _ll_seek(handle,old,SEEK_SET) ;
}

int _ll_dup(int handle)
{
	DPMI_REGS regs;
   regs.h.bx = handle;
   __doscall(0x45,&regs);
	if (regs.h.flags & 1)
      return 0;
   return regs.h.ax ;
}

int _ll_setftime(int handle,void *ftimep)
{
	DPMI_REGS regs;
   regs.b.al = 1 ;
   regs.h.bx = handle;
   regs.h.cx = *(short *)ftimep ;
   regs.h.dx = *(((short *)ftimep)+1) ;
   __doscall(0x57,&regs);
	if (regs.h.flags & 1)
      return -1;
   return 0 ;
}

int _ll_getftime(int handle,void *ftimep)
{
   DPMI_REGS regs ;
   regs.b.al = 0 ;
   regs.h.bx = handle;
   __doscall(0x57,&regs);
	if (regs.h.flags & 1)
      return -1;
   *(short *)ftimep  = regs.h.cx ;
   *(((short *)ftimep)+1)  = regs.h.dx ;
   return 0 ;
}

int _ll_isatty(int handle)
{
   DPMI_REGS regs ;
   regs.b.al = 0 ;
   regs.h.bx = handle;
   __doscall(0x44,&regs);
   return !!(regs.h.dx & 128) ;
}

int _ll_lock(int handle, int offset, int length)
{
	DPMI_REGS regs;
   regs.b.al = 0 ;
   regs.h.bx = handle;
   regs.h.cx = offset >> 16 ;
   regs.h.dx = offset & 0xffff ;
   regs.h.si = length >> 16 ;
   regs.h.di = length & 0xffff ;
   __doscall(0x57,&regs);
	if (regs.h.flags & 1)
      return -1;
   return 0 ;
}

int _ll_unlock(int handle, int offset, int length)
{
	DPMI_REGS regs;
   regs.b.al = 1 ;
   regs.h.bx = handle;
   regs.h.cx = offset >> 16 ;
   regs.h.dx = offset & 0xffff ;
   regs.h.si = length >> 16 ;
   regs.h.di = length & 0xffff ;
   __doscall(0x57,&regs);
	if (regs.h.flags & 1)
      return -1;
   return 0 ;

}
int _ll_uioflags(int flags)
{
   if (flags & O_RDONLY)
      return 0 ;
   if (flags & O_WRONLY)
      return 1 ;
   return 2 ;
}
int _ll_shflags(int flags)
{
   return flags & 0x70 ;
}