//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// File	       : ZLog.h
// Date      : 20 Feb 1998
//Version : 1.0 
// Desc    : Header file for Ziron Log String Library.
// Copyright (C) 1997-1998 By Ziron Multimedia.  Diing-Seng Toh
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// This software is provided 'as-is', without any express or implied
//  warranty.  In no event will the authors be held liable for any damages
//  arising from the use of this software.
//
// Email : diing@online-rpg.com
// http://www.ziron.com
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#ifndef __ZIRON_LOG_STRING_LIB__
#define __ZIRON_LOG_STRING_LIB__
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// Uncomment the following line _NO_ZLOG_  in your Detail version so that  ZLog.lib will not reduce your game speed.
//#define _NO_ZLOG_




//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// ZLog Library functions: (please only use functions or Macros list in the following
// INIT_ZIRON_LOG()  :- init the library
// END_ZIRON_LOG()  :- Deinit the library
// ZLOG(char *format, ...);  macro to output data to the Log manager main window, it function similarly to "TRACE".
//ZERROR_LOG(char *format, ...); :Output a string to the Error window in the Log Manager.
//ZNUM(int widowId, int number); : You have 8 number boxes on the right site of the Manager, You may output numbers to those
//				boxes to traces values.  Valid windoID range from 0 to 7.  For eg. I use 0 for my game FrameRate, 
//				1&2, for mouse cursor position.
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////












#ifdef __cplusplus
extern "C" {
#endif
////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//  Please don't call zlog functions directly, call our macro insteads.
////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//Macro for ZLog.lib
#ifndef _NO_ZLOG_

#define INIT_ZIRON_LOG() InitZironLog()
#define END_ZIRON_LOG() EndZironLog()
#define ZLOG ZironLogFile
#define ZERROR_LOG ZironErrorLog
#define ZNUM ZironLogNum

#else 

#define INIT_ZIRON_LOG() 
#define END_ZIRON_LOG() 
#define ZNUM(a,b) 


////////////////////
//since we use sizeof to further reduce the extra data paste into your execute program,
//it may cause some side effect if you call the ZLOG in the following way:
// ZLOG("This is Test number %d", testNum++);
// so, if testNum need to be increased in both debug and detail version of your program,
// you will either uncomment the ZLOG_SIDE_EFFECT, or
// rewirte your code as(2 lines):
// ZLOG("This is Test number %d", testNum);
// testNum++;
///////////////////////////////////
// note: I read using sizeof to get max performance from the DirectXDev mailling list,
//			 Whoever come out with the idea is a genius.  If you read this, please email me
//			your email address so that i can credit you :)
//#define ZLOG_SIDE_EFFECT

#ifdef ZLOG_SIDE_EFFECT
inline void __cdecl ZLOG(const char *fmt, ...) {}
//an empty function, I hope the compiler can optimize it. so that it won't get call!

inline void __cdecl ZERROR_LOG(const char *fmt, ...) { }
//an empty function, I hope the compiler can optimize it. so that it won't get call!

#else 
//using sizeof to
#define ZLOG sizeof

#define ZERROR_LOG sizeof

#endif

#endif 




////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// Please do not call the following functions directly!!
////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
extern void __cdecl InitZironLog();
// Don't calll this function, please call the Macro INIT_ZIRON_LOG
// Initialze the library
// Can be considered as the Constructor of the Library class
// you may only call this function per program

extern void __cdecl EndZironLog();
// Don't calll this function, please call the Macro END_ZIRON_LOG
// Destructor for the Library.
// Call it before the program quit to clear up memory

extern void __cdecl ZironLogFile(const char *fmt, ...);
// Don't calll this function directly, please use ZLOG
//print the messages into the output window in the ZLog Manager

extern void __cdecl ZironErrorLog(const char *fmt, ...);
// Don't calll this function directly, please use ZERROR_LOG
//print the messages into the output window in the ZLog Manager

extern void __cdecl ZironLogNum(int id, int num);
// Don't calll this function directly, please use ZNUM
//print the messages into the output window in the ZLog Manager

#ifdef __cplusplus
 }
#endif
#endif