/*
//	$Id: ygrep.h 1.24 2000/03/21 20:15:55 Y.Roumazeilles Exp $
//
//	Copyright (C) 1992-93-94-95-96-97-98-99-2000 Yves Roumazeilles
//	All rights reserved
//
//      Version 7.05
*/

#ifndef	__YGREP_H__
#define	__YGREP_H__	
#ifdef __cplusplus
extern "C" {
#endif

#ifdef	WINVER
# ifdef	WIN32
#  define	YGCALL	WINAPI
# else
#  define	YGCALL	FAR PASCAL
# endif
#else
# define	YGCALL	
#endif

WORD	YGCALL	YGrepVersion( void );
BOOL	YGCALL	YGrepIsDebug( void );	/* should always return FALSE in distributed package */
void	YGCALL	YGrepMessages( BOOL bMessagesAllowed );

#define	YO_EOLLF	0x0001L
#define	YO_EOLCR	0x0002L
#define	YO_EOLCRLF	YO_EOLCR|YO_EOLLF
#define	YO_ERRMSG	0x0008L
#define	YO_SHORTCLO	0x0010L
long	YGCALL	YGrepOptions( long lOptions );




/* YGrep Search Engine Error Codes */
#define AGERR_UNKNOWN_TYPE		-1
#define AGERR_NO_ERROR			0
#define AGERR_STATE			1
#define AGERR_ALLOC_MEM			2
#define AGERR_TOO_SHORT			3
#define AGERR_TOO_LONG			4
#define AGERR_NO_PREVIOUS		5
#define AGERR_NO_PATTERN		6
#define AGERR_NO_DEST			7

#define RGERR_MUNGED_AUTO		20
#define RGERR_MISS_BRACKET		25
#define RGERR_EMPTY_CL			26
#define RGERR_ILLEGAL_CL		27
#define RGERR_TOO_MANY_PAR		28
#define RGERR_NULL_IN_PAR		29
#define RGERR_UNMATCHED			30
#define RGERR_NULL_IN_CRO		31
#define RGERR_CYCLICAL_REF		32
#define RGERR_UNDETERM_REF		33
#define RGERR_UNMATCHED_PAR		34
#define RGERR_TOO_MANY_BRA		35
#define RGERR_MISS_CURLY		36

#define	MATCH		0
#define	MISMATCH	1
#define	EXACTMATCH	2
#define	FWMATCH		8
#define	FWMISMATCH	9
#define	FWEXACTMATCH	10
#define	MAXSYM		256	/* Size of the alphabet (in chars) */
#define	WORD_SIZE	512	/* (in bits) */
#define MAXTAG		10

#include	"bitlist.h"

typedef struct tagAGrepInfo {
	int	iErrorCode;
	char	cPat[WORD_SIZE];
	LPSTR	TagStart[MAXTAG];
	LPSTR	TagEnd[MAXTAG];
	BOOL	bMatchCase;
	BLIST	uMask;		/* internal structures */
	BLIST	uOvMask;
	BLIST	uLimit;
	BLIST	blState;	/* temporary AGrep() structures */
	BLIST	blOverflow;
	BLIST	blTemp;
	BLIST	uTable[MAXSYM];	/* characteristic vector table */
	int	iBitsPerState;
	int	iWordSize;	/* actual word size of BLIST's */
	int	iType;		/* MATCH, MISMATCH or EXACTMATCH (or their FW-equivalents) */
	char	cUPat[WORD_SIZE];
	char	chrtyp[MAXSYM];
} AGREPINFO;
#ifdef	WINVER
typedef	AGREPINFO*	PAGREPINFO;
typedef	AGREPINFO FAR*	LPAGREPINFO;
#else
typedef	AGREPINFO*	PAGREPINFO;
typedef	AGREPINFO*	LPAGREPINFO;
#endif

int	YGCALL	CompileAGrep( LPCSTR GrepString, int k, BOOL bMatchCase, BOOL bFullWordMatch, LPAGREPINFO pGI );
int	YGCALL	AGrep( LPCSTR StringToSearch, LPAGREPINFO pGI );
int	YGCALL	AGrepInit( LPAGREPINFO pGI );
int	YGCALL	AGrepEmpty( LPAGREPINFO pGI );
BOOL	YGCALL	AGrepMatch( LPSTR lpszDest, long lSize, LPAGREPINFO pGI );
int	YGCALL	AGrepSubsBuild( LPSTR lpszPattern, LPSTR lpszDest, long lSize, LPAGREPINFO pGI );
int	YGCALL	AGrepSubstitute( LPSTR SearchedString, LPSTR lpszPattern, LPSTR lpszDest, long lSize, LPAGREPINFO pGI );
void	YGCALL	InitAWordCharTable( LPAGREPINFO pGI );
void	YGCALL	ClearAWordCharTable( LPAGREPINFO pGI );
void	YGCALL	FillAWordCharTable( LPAGREPINFO pGI );
void	YGCALL	AddAWordChar( LPSTR s, LPAGREPINFO pGI );
void	YGCALL	RemoveAWordChar( LPSTR s, LPAGREPINFO pGI );
int	YGCALL	SCompileAGrep( LPCSTR GrepString, int k, BOOL bMatchCase, BOOL bFullWordMatch );
int	YGCALL	SAGrep( LPCSTR StringToSearch );
int	YGCALL	SAGrepNext( );
int	YGCALL	SAGrepInit( void );
int	YGCALL	SAGrepEmpty( void );
int	YGCALL	SAGrepSubsBuild( LPSTR lpszPattern, LPSTR lpszDest, long lSize );
int	YGCALL	SAGrepSubstitute( LPSTR SearchedString, LPSTR lpszPattern, LPSTR lpszDest, long lSize );






#define	MAXDFA	2*WORD_SIZE+32	// It must be double in order to avoid any need for internal error checking

typedef struct tagRGrepInfo {
	int	iErrorCode;
	char	cPat[WORD_SIZE];
	LPSTR	TagStart[MAXTAG];
	LPSTR	TagEnd[MAXTAG];
	BOOL	bMatchCase;
	char	cDFA[MAXDFA];		/* internal structures */
	int	iBranches;
	int	iMinLength;
	char*	ap[MAXTAG];
	LPCSTR	bol;
//	LPSTR	bopat[MAXTAG];
//	LPSTR	eopat[MAXTAG];
	char	chrtyp[MAXSYM];
} RGREPINFO;
#ifdef	WINVER
typedef	RGREPINFO*	PRGREPINFO;
typedef	RGREPINFO FAR*	LPRGREPINFO;
#else
typedef	RGREPINFO*	PRGREPINFO;
typedef	RGREPINFO*	LPRGREPINFO;
#endif

int	YGCALL	CompileRGrep( LPCSTR GrepString, BOOL bMatchCase, LPRGREPINFO pGI );
int	YGCALL	RGrep( LPCSTR StringToSearch, LPRGREPINFO pGI );
BOOL	YGCALL	RGrepMatch( LPSTR lpszDest, long lSize, LPRGREPINFO pGI );
int	YGCALL	RGrepSubsBuild( LPSTR lpszPattern, LPSTR lpszDest, long lSize, LPRGREPINFO pGI );
int	YGCALL	RGrepSubstitute( LPSTR SearchedString, LPSTR lpszPattern, LPSTR lpszDest, long lSize, LPRGREPINFO pGI );
void	YGCALL	InitRWordCharTable( LPRGREPINFO pGI );
void	YGCALL	ClearRWordCharTable( LPRGREPINFO pGI );
void	YGCALL	FillRWordCharTable( LPRGREPINFO pGI );
void	YGCALL	AddRWordChar( LPSTR s, LPRGREPINFO pGI );
void	YGCALL	RemoveRWordChar( LPSTR s, LPRGREPINFO pGI );
int	YGCALL	SCompileRGrep( LPCSTR GrepString, BOOL bMatchCase );
int	YGCALL	SRGrep( LPCSTR StringToSearch );
int	YGCALL	SRGrepNext( );
int	YGCALL	SRGrepSubsBuild( LPSTR lpszPattern, LPSTR lpszDest, long lSize );
int	YGCALL	SRGrepSubstitute( LPSTR SearchedString, LPSTR lpszPattern, LPSTR lpszDest, long lSize );
#define	AddWordBoundaryChar( s, pGI )		RemoveRWordChar( (s), (pGI) )
#define	RemoveWordBoundaryChar( s, pGI )	AddRWordChar( (s), (pGI) )
#define	SInitWordCharTable()			InitRWordCharTable( rgiLocal )
#define	SClearWordCharTable()			ClearRWordCharTable( rgiLocal )
#define	SFillWordCharTable()			FillRWordCharTable( rgiLocal )
#define	SAddWordChar( s )			AddRWordChar( (s), rgiLocal )
#define	SRemoveWordChar( s )			RemoveRWordChar( (s), rgiLocal )
#define	SAddWordBoundaryChar( s )		RemoveRWordChar( (s), rgiLocal )
#define	SRemoveWordBoundaryChar( s )		AddRWordChar( (s), rgiLocal )
#define	AddRWordBoundaryChar( s, pGI )		RemoveRWordChar( (s), (pGI) )
#define	RemoveRWordBoundaryChar( s, pGI )	AddRWordChar( (s), (pGI) )
#define	SInitWordCharTable()			InitRWordCharTable( rgiLocal )
#define	SClearRWordCharTable()			ClearRWordCharTable( rgiLocal )
#define	SFillRWordCharTable()			FillRWordCharTable( rgiLocal )
#define	SAddRWordChar( s )			AddRWordChar( (s), rgiLocal )
#define	SRemoveRWordChar( s )			RemoveRWordChar( (s), rgiLocal )
#define	SAddRWordBoundaryChar( s )		RemoveRWordChar( (s), rgiLocal )
#define	SRemoveRWordBoundaryChar( s )		AddRWordChar( (s), rgiLocal )
#define	InitWordCharTable( pGI )	InitRWordCharTable( pGI )
#define	ClearWordCharTable( pGI )	ClearRWordCharTable( pGI )
#define	FillWordCharTable( pGI )	FillRWordCharTable( pGI )
#define	AddWordChar( s, pGI )		AddRWordChar( s, pGI )
#define	RemoveWordChar( s, pGI )	RemoveRWordChar( s, pGI )



typedef struct tagSGrepInfo {
	int	iErrorCode;
	char	cPat[WORD_SIZE];
	LPSTR	TagStart[MAXTAG];
	LPSTR	TagEnd[MAXTAG];
	BOOL	bMatchCase;
	char	cDFA[MAXDFA];		/* internal structures */
	BOOL	bFullWordMatch;
	char	chrtyp[MAXSYM];
} SGREPINFO;
#ifdef	WINVER
typedef	SGREPINFO*	PSGREPINFO;
typedef	SGREPINFO FAR*	LPSGREPINFO;
#else
typedef	SGREPINFO*	PSGREPINFO;
typedef	SGREPINFO*	LPSGREPINFO;
#endif

int	YGCALL	CompileSGrep( LPCSTR GrepString, /*@unused@*/BOOL bMatchCase, BOOL bFullWordMatch, LPSGREPINFO pGI );
int	YGCALL	SGrep( LPCSTR StringToSearch, LPSGREPINFO pGI );
BOOL	YGCALL	SGrepMatch( LPSTR lpszDest, long lSize, LPSGREPINFO pGI );
int	YGCALL	SGrepSubsBuild( LPSTR lpszPattern, LPSTR lpszDest, long lSize, LPSGREPINFO pGI );
int	YGCALL	SGrepSubstitute( LPSTR SearchedString, LPSTR lpszPattern, LPSTR lpszDest, long lSize, LPSGREPINFO pGI );
int	YGCALL	SCompileSGrep( LPCSTR GrepString, /*@unused@*/BOOL bMatchCase, BOOL bFullWordMatch );
int	YGCALL	SSGrep( LPCSTR StringToSearch );
int	YGCALL	SSGrepNext( );
int	YGCALL	SSGrepSubsBuild( LPSTR lpszPattern, LPSTR lpszDest, long lSize );
int	YGCALL	SSGrepSubstitute( LPSTR SearchedString, LPSTR lpszPattern, LPSTR lpszDest, long lSize );
void	YGCALL	InitSWordCharTable( LPSGREPINFO pGI );
void	YGCALL	ClearSWordCharTable( LPSGREPINFO pGI );
void	YGCALL	FillSWordCharTable( LPSGREPINFO pGI );
void	YGCALL	AddSWordChar( LPSTR s, LPSGREPINFO pGI );
void	YGCALL	RemoveSWordChar( LPSTR s, LPSGREPINFO pGI );





#define	OP_NOP	0
#define	OP_NOT	1
#define	OP_AND	2
#define	OP_OR	3
#define	OP_NAND	4
#define	OP_NOR	5
#define	OP_ADD	6
#define	OP_SUB	7
#define	OP_UCMP	8
#define	OP_BAND	9
#define	OP_BOR	10
#define	OP_BXOR	11
#define	OP_BNAND	12
#define	OP_BNOR	13

typedef	struct tagYGrepInfo {
	union {
		int		opI;	/* One of OP_* values */
		AGREPINFO	aGI;
		RGREPINFO	rGI;
		SGREPINFO	sGI;
	} info;
#ifdef	WINVER
	struct tagYGrepInfo FAR*	pInfo;
#else
	struct tagYGrepInfo *   	pInfo;
#endif
	int	iTypeOfInfo;	/* One of IT_* values */
} YGREPINFO;
#ifdef	WINVER
typedef	YGREPINFO*	PYGREPINFO;
typedef	YGREPINFO FAR*	LPYGREPINFO;
#else
typedef	YGREPINFO*	PYGREPINFO;
typedef	YGREPINFO*	LPYGREPINFO;
#endif

#define	IT_NONE	-1
#define	IT_OP	0
#define	IT_AG	1
#define	IT_RG	2
#define	IT_SG	3

typedef struct tagYStackInfo {
	LPYGREPINFO	pFirst;
	LPYGREPINFO	pCurrent;
	LPCSTR		lpStringToSearch;
	int		iFirstError;
} YSTACKINFO;
#ifdef	WINVER
typedef	YSTACKINFO*	PYSTACKINFO;
typedef	YSTACKINFO FAR*	LPYSTACKINFO;
#else
typedef	YSTACKINFO*	PYSTACKINFO;
typedef	YSTACKINFO*	LPYSTACKINFO;
#endif


int	YGCALL	PushYInfo( LPYGREPINFO pGI, LPYSTACKINFO pSI );
int	YGCALL	YGrep( LPCSTR StringToSearch, LPYSTACKINFO pSI );
int	YGCALL	YGrepGetError( LPYSTACKINFO pSI);
int	YGCALL	YGrepSetError( int iError, LPYSTACKINFO pSI );
int	YGCALL	YGrepResetError( int iError, LPYSTACKINFO pSI );



#include	<stdio.h>
#define	SIZESTRING	1024

typedef	struct tagYGFileInfo {
	FILE*	pFileDesc;
	LPCSTR	strFileName;
	long	lLineNumber;
	long	lMatchCount;
	char	linebuf[SIZESTRING];
	char	outputbuf[SIZESTRING];
	char	tempbuf[SIZESTRING];
	BOOL	bPrintNameOfFile;	/* print file name to output */
	BOOL	bPrintBlockNumber;	/* print block number to output */
	BOOL	bPrintLineNumber;	/* print line number to output */
	BOOL	bPrintCountsOnly;	/* total count matches to output */
	BOOL	bNonMatchingLines;	/* Print all lines except those that contain the pattern. */
	BOOL	bFileModeText;		/* Open all files in text mode (rather than binary) */
	AGREPINFO	agiLocal;
	RGREPINFO	rgiLocal;
	SGREPINFO	sgiLocal;
} YGFILEINFO;
#ifdef	WINVER
typedef	YGFILEINFO*	PYGFILEINFO;
typedef	YGFILEINFO FAR*	LPYGFILEINFO;
#else
typedef	YGFILEINFO*	PYGFILEINFO;
typedef	YGFILEINFO*	LPYGFILEINFO;
#endif

void	YGCALL	SFileSetFlags( BOOL bPrintFileName, BOOL bPrintBlockNumber, BOOL bPrintLineNumber, BOOL bCountsOnly, BOOL bNonMatching );
BOOL	YGCALL	SFileOpen( LPCSTR strFileName, BOOL bFileTextMode );
LPSTR	YGCALL	SFileAGrep();
LPSTR	YGCALL	SFileRGrep();
LPSTR	YGCALL	SFileSGrep();
LPSTR	YGCALL	SFileTextAGrep();
LPSTR	YGCALL	SFileTextRGrep();
LPSTR	YGCALL	SFileTextSGrep();
LPSTR	YGCALL	SFileBinaryAGrep();
LPSTR	YGCALL	SFileBinaryRGrep();
LPSTR	YGCALL	SFileBinarySGrep();
long	YGCALL	SFileClose();

void	YGCALL	FileSetFlags( BOOL bPrintFileName, BOOL bPrintBlockNumber, BOOL bPrintLineNumber, BOOL bCountsOnly, BOOL bNonMatching, LPYGFILEINFO fpFile );
/*@null@*/
LPYGFILEINFO	YGCALL	FileOpen( LPCSTR strFileName, BOOL bFileTextMode );
LPSTR	YGCALL	FileAGrep(LPYGFILEINFO fpFile);
LPSTR	YGCALL	FileRGrep(LPYGFILEINFO fpFile);
LPSTR	YGCALL	FileSGrep(LPYGFILEINFO fpFile);
LPSTR	YGCALL	FileTextAGrep(LPYGFILEINFO fpFile);
LPSTR	YGCALL	FileTextRGrep(LPYGFILEINFO fpFile);
LPSTR	YGCALL	FileTextSGrep(LPYGFILEINFO fpFile);
LPSTR	YGCALL	FileBinaryAGrep(LPYGFILEINFO fpFile);
LPSTR	YGCALL	FileBinaryRGrep(LPYGFILEINFO fpFile);
LPSTR	YGCALL	FileBinarySGrep(LPYGFILEINFO fpFile);
long	YGCALL	FileClose(LPYGFILEINFO fpFile);


#ifdef __cplusplus
} /* extern "C" */
#endif
#endif	/* __YGREP_H__ */
