/*  uuencode.c
**
**  Creates uu-encoded attachment
**
**  DOS version. Must link with UUCODER.
**  Microsoft:  cl  uuencode.c uucoder.c
**    Borland:  bcc uuencode.c uucoder.c
**
*/

#include <stdio.h>
#include <stdlib.h>
#include <io.h>
#include <fcntl.h>

#include "uucoder.h"

#define BYTE unsigned char

static long InBytes = 0;
static long OutBytes = 0;
static BYTE BinaryText[3];
static BYTE CodedText[4];
static int f1;
static int f2;

static char Quote = '"';
static char Buffer[256];

static char *BlankLine = "\n";

void main(int argc, char *argv[])
{int i, j, n;
 int BreakFlag;
 unsigned char uc;
 if(argc!=3)
   {printf("Usage: uuencode <infile> <outfile>\n");
    exit(1);
   }
 f1 = open(argv[1],O_RDONLY|O_BINARY);
 if(f1==-1)
   {printf("Cannot open %s\n", argv[1] );
    exit(1);
   }
 f2 = open(argv[2],O_CREAT|O_TRUNC|O_TEXT|O_RDWR);
 if(f2==-1)
   {printf("Cannot create %s\n", argv[2] );
    exit(1);
   }
 /* output header */
 sprintf(Buffer,"begin 666 %s\n",argv[1]);
 write(f2,Buffer,strlen(Buffer));
 /* encode */
 BreakFlag = 0;
 for(i=0;;i++)
   {n = read(f1,Buffer,45);
    if(n<=0)
      {BreakFlag = 1;
       break;
      }
    Buffer[n+0] = 0;
    Buffer[n+1] = 0;
    InBytes += (long)n;
    /* write (coded) length of input line */
    uc = ENC(n);
    write(f2,&uc,1);
    for(j=0;3*j<n;j++)
      {OutBytes += 4L; 
       EncodeUU(&Buffer[3*j],&CodedText[0]);
       write(f2,&CodedText[0],4);
      }
    if(BreakFlag) break;
    write(f2,"\n",1);
    /* display dot each 1024 bytes read [1024/(3*15)=23] */
    if((i%23)==0)printf(".");
   }
 write(f2,"`\nend\n",5);
 printf("\n%ld bytes read, %ld bytes written\n", InBytes, OutBytes);
 close(f1);
 close(f2);
 exit(0);
}
