/*  uudecode.c
**
**  Decodes uu-encoded attachment
**
**  DOS version. Must link with UUCODER.
**  Microsoft:  cl  uudecode.c uucoder.c
**    Borland:  bcc uudecode.c uucoder.c
*/

#include <stdio.h>
#include <stdlib.h>
#include <io.h>
#include <fcntl.h>
#include <string.h>
#include <ctype.h>

#include "uucoder.h"

#define BYTE unsigned char
#define QUOTE 0x22

#ifndef FALSE
#define FALSE 0
#define TRUE 1
#endif

static int Debug = 0;

static long InBytes = 0;
static long OutBytes = 0;
static BYTE BinaryText[3];
static BYTE CodedText[4];
static int f1;
static int f2;

static char FileName[65];
static int  FileNameLen = 0;

static char Buffer[256];

int ReadLine(
       char CharBuf[], /* Character buffer */
       int  MaxBytes,  /* Max bytes to read */
       char Mode)      /* 'B' for binary mode, 'T' for text mode */
{int  i;
 int  n;
 int  Count = 0;
 char c;
 while(1)
   {/* skip CRs */
    while(1)
      {n = read(f1,&c,1);
       if(n<0) return n;
       if(n==0) return Count;
       if(c!='\r') break;
      }
    if(c=='\n')
      {CharBuf[Count] = '\0';
       if(Count==0)
         {/* blank line returned in Text mode only */
          if(Mode=='B') continue;
          else return Count;
         }
       else return Count;
      }
    CharBuf[Count++] = (char)c;
    if(Count>=MaxBytes) return Count;
   }
}


void main(int argc, char *argv[])
{int i, j, n;
 int BlankCnt = 0;
 int SlashPos = 0;
 int BufLen;
 int LineLen;
 int FoundBegin = FALSE;
 char c;
 if((argc!=2)&&(argc!=3))
   {printf("Usage: uudecode <infile> [<outfile>]\n");
    exit(1);
   }
 f1 = open(argv[1],O_RDONLY|O_TEXT);
 if(f1==-1)
   {printf("Cannot open %c%s%c\n", QUOTE,argv[1],QUOTE );
    perror("Dos error");
    exit(1);
   }
 if(argc==3)
   {f2 = open(argv[2],O_RDWR|O_CREAT|O_TRUNC|O_BINARY);
    if(f2==-1)
      {printf("Cannot create %c%s%c\n", QUOTE,argv[2],QUOTE );
       perror("Dos error");
       exit(1);
      }
   }

 while(1)
   {n = ReadLine(Buffer, 256,'T');
    //printf("[%s]\n",Buffer);
    if(n<0)
      {/* end of file */
       printf("EOF.\n");
       exit(1); //break;
      }
    if(n==0)
      {BlankCnt++;
       //printf("<Blank Line %d>\n",BlankCnt);
       /* found blank line */
       if(BlankCnt==7) break;
       else continue;
      }
   /* looking for "begin " in CC 1 */
   c = Buffer[5];
   Buffer[5] = '\0';
   if(strcmp(Buffer,"begin")==0)
      {/* found "begin" */
       FoundBegin = TRUE;
       /* extract filename */
       Buffer[5] = c;
       BufLen = strlen(Buffer);
       if(BufLen==0) break;
       for(i=BufLen-1;i>=5;i--)
         {if(Buffer[i]==' ')
            {/* found beginning of last word in buffer */
             strcpy(FileName,&Buffer[i+1]);
             FileNameLen = strlen(FileName);
             //printf("(%s)\n", FileName);             
             break;
            }
         }
       break;
      }
   } /* end while */

 if(!FoundBegin)
   {printf("'begin' not found, cannot decode.\n",QUOTE,QUOTE);
    exit(1);
   }

 /* prepare output file */

 if(argc==3)
   {/* output filename specified on command line */
    strcpy(FileName,argv[2]);
   }
 else
   {/* filename not on command line */
    if(FileNameLen==0)
      {printf("Filename not found, using %cNONAME.BIN%c.\n",QUOTE,QUOTE);
       strcpy(FileName,"NONAME.BIN");
      }
    printf("Opening %c%s%c for write\n", QUOTE,FileName,QUOTE);
    f2 = open(FileName,O_RDWR|O_CREAT|O_TRUNC|O_BINARY);
    if(f2==-1)
      {printf("Cannot create %c%s%c\n", QUOTE,FileName,QUOTE);
       perror("Dos error");
       exit(1);
      }
   }
 printf("Decoding to %c%s%c\n\n", QUOTE,FileName,QUOTE);

 /* decode */
 for(i=0;;i++)
   {/* read line length */
    n = ReadLine(CodedText,1,'B');
    if(n<=0) break;
    LineLen = DEC(CodedText[0]);
    //printf("<<%c:%d>>",c,LineLen);
    if(LineLen==0) break;
    for(j=0;j<LineLen;j = j + 3)
      {/* read 4 bytes */
       BinaryText[1] = 0;
       BinaryText[2] = 0;
       BinaryText[3] = 0;
       n = ReadLine(CodedText,4,'B');
       //printf("%d[%s]\n",n,CodedText);
       if(n<=0) break;
       InBytes += (long)n;
       OutBytes += 3L;
       //printf("[%c%c%c%c] --> ", CodedText[0], CodedText[1], CodedText[2], CodedText[3] );
       DecodeUU(&CodedText[0],&BinaryText[0]);
       //printf("[%x %x %x] \n", BinaryText[0], BinaryText[1], BinaryText[2] );
       n = write(f2,&BinaryText[0],3);
       if(n!=3)
         {printf("ERROR: write() returns %d\n",n);
          perror("Dos Error");
          exit(1);
         }
       /* display dot each 1024 bytes read (1024/4 = 256) */
       if((i%256)==0)printf(".");
      }
   }
 //printf("[%c%c%c%c]\n", CodedText[0], CodedText[1], CodedText[2], CodedText[3] );
 printf("\n%ld bytes read, %ld bytes written\n", InBytes, OutBytes);
 close(f1);
 close(f2);
 exit(0);
}

