/* uucoder.c */

#include "uucoder.h"

/* encode 3-byte binary to 4-byte ascii */

void EncodeUU(LPSTR ClearPtr,  /* pointer to 3 byte binary buffer */
              LPSTR CodedPtr)   /* pointer to 4 byte ASCII buffer */
{
 *CodedPtr++ = ENC(*ClearPtr >> 2);
 *CodedPtr++ = ENC((*ClearPtr << 4) & 0x30 | (ClearPtr[1] >> 4) & 0x0f);
 *CodedPtr++ = ENC((ClearPtr[1] << 2) & 0x3c | (ClearPtr[2] >> 6) & 0x03);
 *CodedPtr = ENC(ClearPtr[2] & 0x3f);
}

/* decode 4-byte ascii to 3-byte binary */

void DecodeUU(LPSTR CodedPtr,    /* pointer to 4 byte ASCII buffer */
              LPSTR ClearPtr)   /* pointer to 3 byte binary buffer */
{
 *ClearPtr++ = DEC(*CodedPtr) << 2 | DEC(CodedPtr[1]) >> 4;
 *ClearPtr++ = DEC(CodedPtr[1]) << 4 | DEC(CodedPtr[2]) >> 2;
 *ClearPtr = DEC(CodedPtr[2]) << 6 | DEC(CodedPtr[3]);
}

