/*
	This is part of the "revision librarian", which is a front end for RCS
	for Windows 95.

	copyright (C) 1997 Malcolm Dew-Jones

	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License
	as published by the Free Software Foundation; either version 2
	of the License, or (at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

	The author can be reached (as of Dec 1997) at 73312.2317@compuserve.com
	and yf110@freenet.victoria.bc.ca

*/
#include <windows.h>
#include <stdio.h>
#include <stdlib.h>

#ifdef REVLIB_UTILS
	int tempfile_main
#else
	void _ExceptInit(void) {}
	int main
#endif

(int argc, char *argv[])
{
	/* the specified dir is normally over ridden! by TEMP */
	 char *name,*dir,*prefix,*temp,*dot;
	 char buffer[2048];

	 if (argc<2) dir=".\\";
	 else dir=argv[1];
	 if (argc<3) prefix="";
	 else prefix=argv[2];
	 temp=getenv("TEMP");
	 if (temp)
	 {	sprintf(buffer,"TMP=%s",temp);
		putenv(buffer);
	 }
	 name = tempnam( dir, prefix);
	 if (!name) return 1;
	 dot = strrchr(name,'.');
	 if (dot) *dot=0;
	 printf("SET TEMPNAME=%s\n",name);
	 return 0;
}

