/*
	This is part of the "revision librarian", which is a front end for RCS
	for Windows 95.

	copyright (C) 1997 Malcolm Dew-Jones

	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License
	as published by the Free Software Foundation; either version 2
	of the License, or (at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

	The author can be reached (as of Dec 1997) at 73312.2317@compuserve.com
	and yf110@freenet.victoria.bc.ca

*/
#include <stdio.h>
#include <string.h>

#define StrEqual(a,b) (strcmp((a),(b))==0)
#define OptEq(a,b,c) (StrEqual(a,b)||StrEqual(a,c))

#define SHIFT {argc--; argv = &argv[1];}

revlib_util_usage()
{
	fputs(
"REVLIB&U 0.5 - copyright 1997 Malcom Dew-Jones.  Freely distributable under\n\
the terms of the GNU General Public License.  This provides various utilities\n\
for the \"revision librarian\" front end for running RCS under Windows 95.\n\
This program is distributed in the hope that it will be useful,\n\
but WITHOUT ANY WARRANTY.\n",stdout);

	fputs("Usage: revlib&u -option command_string\n",stdout);
	fputs("options: -a - ask for input\n",stdout);
	fputs("         -b - test if file is binary or not\n",stdout);
	fputs("         -c - get command line associated with file extension\n",stdout);
	fputs("         -f - extract file name parts from DIR output\n",stdout);
	fputs("         -m - make menu output from RLOG output\n",stdout);
	fputs("         -t - make a temporary file name\n",stdout);
	fputs("revlib&u -option\n    may get more help for an option\n",stdout);
	return 1;
}

main(int argc,char *argv[])
{
	char *opt;

	if (argc<2) return revlib_util_usage();
	opt=argv[1];
	SHIFT ;
	if (OptEq(opt,"-a","-A")) return ask_main(argc,argv);
	if (OptEq(opt,"-b","-B")) return isbinary_main(argc,argv);
	if (OptEq(opt,"-c","-C")) return getreg_main(argc,argv);
	if (OptEq(opt,"-f","-F")) return filepart_main(argc,argv);
	if (OptEq(opt,"-m","-M")) return revmenu_main(argc,argv);
	if (OptEq(opt,"-t","-T")) return tempfile_main(argc,argv);
	return revlib_util_usage();
}

