# WINPERL HIVES.PL
# 
# Written by Maxwell N. Andrews
#
# Date: 6th May 1995
#
# Version: v1.00
#

#
# Constants for use in accessing the NT/Windows 95 Registry database.
#

#
# Return error codes
#

$ERROR_SUCCESS       = 0;
$ERROR_NO_MORE_ITEMS = 259;

#
# Standard access types
#

$READ_CONTROL              =  0x00020000;
$SYNCHRONIZE               =  0x00100000;
$STANDARD_RIGHTS_REQUIRED  =  0x000F0000;
$STANDARD_RIGHTS_READ      =  $READ_CONTROL;
$STANDARD_RIGHTS_WRITE     =  $READ_CONTROL;
$STANDARD_RIGHTS_EXECUTE   =  $READ_CONTROL;
$STANDARD_RIGHTS_ALL       =  0x001F0000;
$SPECIFIC_RIGHTS_ALL       =  0x0000FFFF;

#
# Pre-Defined registry keys
#

$HKEY_CLASSES_ROOT     = 0x80000000;
$HKEY_CURRENT_USER     = 0x80000001;
$HKEY_LOCAL_MACHINE    = 0x80000002;
$HKEY_USERS            = 0x80000003;
$HKEY_PERFORMANCE_DATA = 0x80000004;
$HKEY_CURRENT_CONFIG   = 0x80000005;
$HKEY_DYN_DATA         = 0x80000006;


#
# Open/Create Options
#

$REG_OPTION_RESERVED     = 0x00000000;  # Parameter is reserved
$REG_OPTION_NON_VOLATILE = 0x00000000;  # Key is preserved
                                         # when system is rebooted
$REG_OPTION_VOLATILE     = 0x00000001;  # Key is not preserved
                                         # when system is rebooted
$REG_OPTION_CREATE_LINK  = 0x00000002;  # Created key is a
                                         # symbolic link

#
# Key creation/open disposition
#

$REG_CREATED_NEW_KEY      =  0x00000001;   # New Registry Key created
$REG_OPENED_EXISTING_KEY  =  0x00000002;   # Existing Key opened

#
# Key restore flags
#

$REG_WHOLE_HIVE_VOLATILE   =  0x00000001;   # Restore whole hive volatile
$REG_REFRESH_HIVE          =  0x00000002;   # Unwind changes to last flush


#
# Notify filter values
#

$REG_NOTIFY_CHANGE_NAME        =  0x00000001; # Create or delete (child)
$REG_NOTIFY_CHANGE_ATTRIBUTES  =  0x00000002;
$REG_NOTIFY_CHANGE_LAST_SET    =  0x00000004; # time stamp
$REG_NOTIFY_CHANGE_SECURITY    =  0x00000008;

$REG_LEGAL_CHANGE_FILTER = $REG_NOTIFY_CHANGE_NAME |
    $REG_NOTIFY_CHANGE_ATTRIBUTES |
    $REG_NOTIFY_CHANGE_LAST_SET |
    $REG_NOTIFY_CHANGE_SECURITY;

#
#
# Predefined Value Types.
#

$REG_NONE                    = 0; # No value type
$REG_SZ                      = 1; # Unicode nul terminated string
$REG_EXPAND_SZ               = 2; # Unicode nul terminated string
                                  # (with environment variable references)
$REG_BINARY                  = 3; # Free form binary
$REG_DWORD                   = 4; # 32-bit number
$REG_DWORD_LITTLE_ENDIAN     = 4; # 32-bit number (same as REG_DWORD)
$REG_DWORD_BIG_ENDIAN        = 5; # 32-bit number
$REG_LINK                    = 6; # Symbolic Link (unicode)
$REG_MULTI_SZ                = 7; # Multiple Unicode strings
$REG_RESOURCE_LIST           = 8; # Resource list in the resource map
$REG_FULL_RESOURCE_DESCRIPTOR = 9;# Resource list in the hardware description

    
#
# Registry Specific Access Rights.
#

$KEY_QUERY_VALUE         = 0x0001;
$KEY_SET_VALUE           = 0x0002;
$KEY_CREATE_SUB_KEY      = 0x0004;
$KEY_ENUMERATE_SUB_KEYS  = 0x0008;
$KEY_NOTIFY              = 0x0010;
$KEY_CREATE_LINK         = 0x0020;

$KEY_READ                = ($STANDARD_RIGHTS_READ   |
                            $KEY_QUERY_VALUE        |
                            $KEY_ENUMERATE_SUB_KEYS |
                            $KEY_NOTIFY)                 
                             &                           
                           ~$SYNCHRONIZE;


$KEY_WRITE               = ($STANDARD_RIGHTS_WRITE   |
                            $KEY_SET_VALUE           |
                            $KEY_CREATE_SUB_KEY)
                             &
                            ~$SYNCHRONIZE;

$KEY_EXECUTE             = $KEY_READ & (~$SYNCHRONIZE);

$KEY_ALL_ACCESS          = ($STANDARD_RIGHTS_ALL    |
                            $KEY_QUERY_VALUE        |
                            $KEY_SET_VALUE          |
                            $KEY_CREATE_SUB_KEY     |
                            $KEY_ENUMERATE_SUB_KEYS |
                            $KEY_NOTIFY             |
                            $KEY_CREATE_LINK)
                             &
                           (~$SYNCHRONIZE);

sub _RegEnumValueEx 
{
       local( $hKey, $Key )= @_;
       local( $errNo )= 0;
       local( $newKey)= 0;
       local( $iSubKey )= 0;
       local( $szValue,$dwType,$bData );

       ( $newKey= RegOpenKeyEx( $hKey, $Key, $KEY_READ ) ) || return 0;

       while ( 1 )
       { 
                ( $szValue, $dwType, $bData )= RegEnumValue( $newKey, $iSubKey++ );

                last if $! == $ERROR_NO_MORE_ITEMS;

                if ( $! )
                {
                   $errNo= $!;

                   RegCloseKey;

                   $!= $errNo;

                   return 0;
                }
 
                if ( $dwType == $REG_NONE ) 
                {
                   $rNone{$szValue}= unpack( "a*", $bData ) ;
                 }
                 elsif ( $dwType == $REG_SZ ) 
                 {
                         $rString{$szValue}= unpack( "a*", $bData ) ;
                 }
                 elsif ( $dwType == $REG_EXPAND_SZ ) 
                 {
                         $rXString{$szValue}= unpack( "a*", $bData ) ;
                 }
                 elsif ( $dwType == $REG_BINARY ) 
                 { 
                         $rBinary{$szValue}= $bData;
                  }
                 elsif ( $dwType == $REG_DWORD ) 
                 {
                         $rDWord{$szValue}= unpack( "L*", $bData ) ;
                 }
                 elsif ( $dwType == $REG_DWORD_BIG_ENDIAN ) 
                 {
                         $rBigDWord{$szValue}= unpack("N*",$bData ) ;
                 }
                 elsif ( $dwType == $REG_LINK ) 
                 {
                         $rLink{$szValue}= unpack( "a*", $bData ) ;
                 }
                 elsif ( $dwType == $REG_MULTI_SZ ) 
                 {
                         $rMultiString{$szValue}= unpack( "a*", $bData ) ;
                 }
                 elsif ( $dwType == $REG_RESOURCE_LIST ) 
                 {
                         $rResList{$szValue}= unpack( "a*", $bData ) ;
                 }
                 elsif ( $dwType == $REG_FULL_RESOURCE_DESCRIPTOR ) 
                 {
                     $rFullResDesc= unpack( "a*", $bData ) ;
                 }
      }

      RegCloseKey || return 0;

      1;
}

sub getLM 
{
       &_RegEnumValueEx( &LMhKey,@_  );
}

sub getU 
{
       &_RegEnumValueEx( &usersHKEY,@_  );
}

sub getCU
{
       &_RegEnumValueEx( $HKEY_CURRENT_USER,@_  );
}

sub getCR
{
       &_RegEnumValueEx( $HKEY_CLASSES_ROOT,@_  );
}

sub getPD
{
       &_RegEnumValueEx( $HKEY_PERFORMANCE_DATA,@_  );
}

# Windows 95 extras

sub getDD
{
       &_RegEnumValueEx( $HKEY_DYN_DATA,@_  );
}

sub getCC
{
       &_RegEnumValueEx( $HKEY_CURRENT_CONFIG,@_  );
}

sub _RegSetValueEx
{
       local( $hKey,$Key,$szValue,$dwType,$bData )= @_;
       local( $errNo )= 0;
       local( $newKey )= 0;

       ( $newKey= RegOpenKeyEx( $hKey,$Key,$KEY_WRITE ) ) || return 0;

       RegSetValueEx( $newKey,$szValue,$dwType,$bData );

       if ( $! )
       {
          $errNo= $!;

          RegCloseKey;

          $!= $errNo;

          return 0;
       }

       RegCloseKey || return 0;

       1;
}

sub setLM
{
       &_RegSetValueEx( &LMhKey,@_  );
}

sub setU
{
       &_RegSetValueEx( &usersHKEY,@_  );
}

sub setCU
{
       &_RegSetValueEx( $HKEY_CURRENT_USER,@_  );
}

sub setCR
{
       &_RegSetValueEx( $HKEY_CLASSES_ROOT,@_  );
}

sub setPD
{
       &_RegSetValueEx( $HKEY_PERFORMANCE_DATA,@_  );
}

# Windows 95 extras

sub setDD
{
       &_RegSetValueEx( $HKEY_DYN_DATA,@_  );
}

sub setCC
{
       &_RegSetValueEx( $HKEY_CURRENT_CONFIG,@_  );
}

sub _RegCreateKeyEx
{
       local( $hKey,$Key,$szValue )= @_;
       local( $secAttrib )= "";
       local( $Class )= "";

       RegCreateKeyEx( $hKey,$Key,$Class,$REG_OPTION_NON_VOLATILE,$KEY_ALL_ACCESS,$secAttrib );

       !$!;
}

sub cKeyLM
{
       &_RegCreateKeyEx( &LMhKey,@_  );
}

sub cKeyU
{
       &_RegCreateKeyEx( &usersHKEY,@_  );
}

sub cKeyCU
{
       &_RegCreateKeyEx( $HKEY_CURRENT_USER,@_  );
}

sub cKeyCR
{
       &_RegCreateKeyEx( $HKEY_CLASSES_ROOT,@_  );
}

sub cKeyPD
{
       &_RegCreateKeyEx( $HKEY_PERFORMANCE_DATA,@_  );
}

# Windows 95 extras

sub cKeyDD
{
       &_RegCreateKeyEx( $HKEY_DYN_DATA,@_  );
}

sub cKeyCC
{
       &_RegCreateKeyEx( $HKEY_CURRENT_CONFIG,@_  );
}

sub _RegDeleteKey
{
       local( $hKey,$Key )= @_;

       RegDeleteKey( $hKey,$Key );

       !$!;
}

sub dKeyLM
{
       &_RegDeleteKey( &LMhKey,@_  );
}

sub dKeyU
{
       &_RegDeleteKey( &usersHKEY,@_  );
}

sub dKeyCU
{
       &_RegDeleteKey( $HKEY_CURRENT_USER,@_  );
}

sub dKeyCR
{
       &_RegDeleteKey( $HKEY_CLASSES_ROOT,@_  );
}

sub dKeyPD
{
       &_RegDeleteKey( $HKEY_PERFORMANCE_DATA,@_  );
}

# Windows 95 extras

sub dKeyDD
{
       &_RegDeleteKey( $HKEY_DYN_DATA,@_  );
}

sub dKeyCC
{
       &_RegDeleteKey( $HKEY_CURRENT_CONFIG,@_  );
}

sub _RegDeleteValue
{
       local( $hKey,$Key )= @_;

       RegDeleteValue( $hKey,$Key,$szValue );

       !$!;
}

sub dValueLM
{
       &_RegDeleteValue( &LMhKey,@_  );
}

sub dValueU
{
       &_RegDeleteValue( &usersHKEY,@_  );
}

sub dValueCU
{
       &_RegDeleteValue( $HKEY_CURRENT_USER,@_  );
}

sub dValueCR
{
       &_RegDeleteValue( $HKEY_CLASSES_ROOT,@_  );
}

sub dValuePD
{
       &_RegDeleteValue( $HKEY_PERFORMANCE_DATA,@_  );
}

# Windows 95 extras

sub dValueDD
{
       &_RegDeleteValue( $HKEY_DYN_DATA,@_  );
}

sub dValueCC
{
       &_RegDeleteValue( $HKEY_CURRENT_CONFIG,@_  );
}

sub LMhKey
{
       if ( defined( $rHKEY_LOCAL_MACHINE ) )
       {
            $rHKEY_LOCAL_MACHINE;
       }
       else
       {
           $HKEY_LOCAL_MACHINE;
       }
}

sub usersHKEY 
{
       if ( defined( $rHKEY_USERS ) )
       {
            $rHKEY_USERS;
       }
       else
       {
           $HKEY_USERS;
       }
}

1;
