// gksLine.cpp : implementation of the CgksLine class
//

#include "stdafx.h"

#include "OzAPIDoc.h"
#include "OzAPIView.h"
#include "gksObject.h"
#include "OzGKS.h"
#include "gksLine.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif



CgksLine::CgksLine(float* x, float* y, int num, 
				   int lineType, int lineWidth, int lineColour)
{
	m_objType = gksLine;
	m_lineType = lineType;
	m_lineWidth = lineWidth;
	m_lineColour = lineColour;
	m_x.SetSize(num);
	m_y.SetSize(num);
	m_num = num;
	m_minNum = 2;
	for (int i=0; i<num; i++)
	{
		m_x[i] = x[i];
		m_y[i] = y[i];
	}
	this->Transform();

}

// draw on screen.

BOOL CgksLine::Draw(CDC* pDC)
{
	GKSpen(pDC, m_lineType, m_lineWidth, m_lineColour);
	pDC->Polyline(m_screenPoint.GetData(), m_screenPoint.GetSize());

	return TRUE;
}


// Transform world coords to screen coords

void CgksLine::Transform()
{
	int i;
	int	count;
	CPoint	point;

	m_screenPoint.RemoveAll();
	xw2dev(m_x[0], &point.x);
	yw2dev(m_y[0], &point.y);
	m_screenPoint.Add(point);
	count = 1;
	for (i=1; i<m_num; i++)
	{
		xw2dev(m_x[i], &point.x);
		yw2dev(m_y[i], &point.y);
		if (point.x != m_screenPoint[count-1].x || point.y != m_screenPoint[count-1].y)
		{
			count++;	// drop duplicate points
			m_screenPoint.Add(point);
		}
	}
	for (i=count; i<m_minNum; i++)	// ensure min num points
		m_screenPoint.Add(m_screenPoint[i-1]);

}

// update attributes

void CgksLine::Attributes(int lineType, int lineWidth, int lineColour)
{
	m_lineType = lineType;
	m_lineWidth = lineWidth;
	m_lineColour = lineColour;
}
