// gksFixedBoxCursor.cpp : implementation of the gksFixedBoxCursor class
//

#include "stdafx.h"

#include "OzAPIDoc.h"
#include "OzAPIView.h"
#include "gksObject.h"
#include "gksCursor.h"
#include "gksBoxCursor.h"
#include "gksFixedBoxCursor.h"
#include "OzGKS.h"
#include "OzFTN.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

CgksFixedBoxCursor::CgksFixedBoxCursor(long type, float* initialData, 
									   long handle, BOOL callback)
		: CgksBoxCursor(type, initialData, handle, callback)
{
	float xScale, yScale;
	m_xsize = initialData[0];
	m_ysize = initialData[1];
	World2Pixels(&xScale, &yScale);
	m_xacross = xScale * m_xsize + 0.5;
	m_yacross = yScale * m_ysize + 0.5;
} 

void CgksFixedBoxCursor::ButtonDown(CClientDC* pDC, CPoint point)
{
	m_screenPoint.RemoveAll();
	m_screenPoint.Add(point);
	m_screenPoint.Add(point);
	m_screenPoint[1].x = m_screenPoint[0].x + m_xacross;
	m_screenPoint[1].y = m_screenPoint[0].y - m_yacross;
	m_drawing = TRUE;
	this->DrawCursor(pDC);
}


void CgksFixedBoxCursor::MouseMove(CClientDC* pDC, CPoint point)
{
	if (!m_drawing)
		return;
	this->DrawCursor(pDC); // erase
	m_screenPoint[0] = point;
	m_screenPoint[1].x = m_screenPoint[0].x + m_xacross;
	m_screenPoint[1].y = m_screenPoint[0].y - m_yacross;
	this->DrawCursor(pDC); // new 
}


