// gksDigitiseCursor.cpp : implementation of the gksDigitiseCursor class
//

#include "stdafx.h"

#include "OzAPIDoc.h"
#include "OzAPIView.h"
#include "gksObject.h"
#include "gksCursor.h"
#include "gksDigitiseCursor.h"
#include "OzGKS.h"
#include "OzFTN.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

CgksDigitiseCursor::CgksDigitiseCursor(long type, float* initialData, 
									   long handle, BOOL callback)
		: CgksCursor(type, initialData, handle, callback)
{
} 

void CgksDigitiseCursor::ButtonDown(CClientDC* pDC, CPoint point)
{
	m_screenPoint.RemoveAll();
	m_screenPoint.Add(point);
	m_drawing = TRUE;
	this->DrawCursor(pDC);
}

void CgksDigitiseCursor::ButtonUp(CClientDC* pDC, CPoint point)
{
	if (!m_drawing)
		return;
	this->DrawCursor(pDC); // erase
	this->GKScallback();
	m_drawing = FALSE;
}

void CgksDigitiseCursor::MouseMove(CClientDC* pDC, CPoint point)
{
	if (!m_drawing)
		return;
	this->DrawCursor(pDC); // erase
	m_screenPoint.Add(point);
	this->DrawCursor(pDC); // new 
}

void CgksDigitiseCursor::DrawCursor(CClientDC* pDC)
{
	CPen* pOldPen = (CPen*)pDC->SelectStockObject(WHITE_PEN);
	int	oldROP = pDC->SetROP2(R2_NOT);          // Erases previous box 
	pDC->Polyline(&m_screenPoint[0], m_screenPoint.GetSize());
	pDC->SetROP2(oldROP);
	pDC->SelectObject(pOldPen);
}

