
/*
 * Computer Algebra Kit (c) 1993,99 by Comp.Alg.Objects.  All Rights Reserved.
 * $Id: mvectorc.h,v 1.2 1999/07/06 19:48:11 stes Exp $
 */

#ifndef __modp_vector_header__
#define __modp_vector_header__

#include "vectorc.h"

typedef struct modpvec
  {
    int n;
    int c;
    modpseq_t ptr;
  }
 *modpvec_t;

typedef struct modpvec modpvec_c;
typedef struct
  {
    modp_args sargs;
  }
modpvec_args;

#define modpvec_isvalue	0
#define modpvec_pervalue	0

typedef struct modpvec_ix
  {
    int i;
    int n;
  }
 *modpvec_ixt;

@interface modp_vector : vectorc
{
  id scalarZero;
  struct modpvec value;
}

- check;

- _setUpScalarZero:aScalarZero numScalars:(int)numScalars;
+ scalarZero:aScalarZero numScalars:(int)numScalars;
- copy;
- deepCopy;
- release;
- (modpvec_t)modpvec_value;
- modpvec_value:(modpvec_t)aValue;
- (modpvec_t)modpvec_reference;
- modpvec_reference:(modpvec_c *)aReference;

- capacity:(int)aCapacity;
- numScalars:(int)numScalars;

- scalarZero;
- (int) numScalars;

- insertScalar:aScalar;
- insertScalar:aScalar at:(int)i;

- removeScalar;
- removeScalarAt:(int)i;

- placeScalar:aScalar at:(int)i;
- replaceScalarAt:(int)i with:aScalar;

- eachScalar;
- elt_modpvec_ix:(modpvec_ixt)ix;

- dotMultiply:b;
- dotSquare;

- fileOutOn:aFiler;
- fileInFrom:aFiler;
- (unsigned) hash;
- (BOOL) isEqual:b;
- (BOOL) notEqual:b;
- (BOOL) isZero;
- (BOOL) notZero;
- (BOOL) isOpposite:b;
- (BOOL) notOpposite:b;
- negate;
- negateSelf;
- _double:(int)v;
- _doubleSelf:(int)v;
- double;
- doubleSelf;
- _add:(int)v:b:(int)w;
- _addSelf:(int)v:b:(int)w;
- add:b;
- addSelf:b;
- subtract:b;
- subtractSelf:b;
- multiplyScalar:s;
- multiplySelfScalar:s;
- divideScalar:s;
- divideSelfScalar:s;
- _add:(int)v:B multiplyScalar:b:(int)w;
- _addSelf:(int)v:B multiplyScalar:b:(int)w;
- _multiplyScalar:a:(int)v add:B:(int)w;
- _multiplySelfScalar:a:(int)v add:B:(int)w;
- _multiplyScalar:a:(int)v add:B multiplyScalar:b:(int)w;
- _multiplySelfScalar:a:(int)v add:B multiplyScalar:b:(int)w;
@end

#endif /* __modp_vector_header__ */
 
