
/*
 * Computer Algebra Kit (c) 1993,98 by Comp.Alg.Objects.  All Rights Reserved.
 * $Id: idrspolc.h,v 1.2 1999/07/06 19:48:09 stes Exp $
 */

#ifndef __bigintobj_vardnsrecdegsps_polynomial_header__
#define __bigintobj_vardnsrecdegsps_polynomial_header__

#include "drspolc.h"

typedef struct bigintobj_vardnsrecdegspsterm
  {
    struct bigintobj_vardnsrecdegspsterm *nlink;
    struct bigintobj_vardnsrecdegspsterm *plink;
    /* stes - mar31, 1997 - for DEC alpha alignment, put scalar in front */
    bigintobj_c scal;		/* can't be variable sized */
    unimonom_c data;		/* variable sized */
  }
 *bigintobj_vardnsrecdegspsterm_t;

typedef struct
  {
    bigintobj_args sargs;
    unimonom_args margs;
  }
bigintobj_vardnsrecdegspsterm_args;

typedef struct bigintobj_vardnsrecdegspsterm *bigintobj_vardnsrecdegspspol_t;
typedef struct bigintobj_vardnsrecdegspsterm bigintobj_vardnsrecdegspspol_c;
typedef bigintobj_vardnsrecdegspsterm_args bigintobj_vardnsrecdegspspol_args;

typedef struct bigintobj_vardnsrecdegspspol_ix
  {
    bigintobj_vardnsrecdegspsterm_t ix;
    bigintobj_vardnsrecdegspsterm_t head;
  }
 *bigintobj_vardnsrecdegspspol_ixt;

#define bigintobj_vardnsrecdegspspol_isvalue	0
#define bigintobj_vardnsrecdegspspol_pervalue	0

@interface bigintobj_vardnsrecdegsps_polynomial : vardnsrecdegsps_polynomial
{
  id scalarZero;
  id termZero;
  id monomialZero;
  id symbols;
  bigintobj_vardnsrecdegspspol_c value;
}

- _setUpScalarZero:aScalar coefficientZero:aCoef symbols:aCltn;
+ scalarZero:aScalar coefficientZero:aCoef symbols:aCltn;
- empty;
- (int) numTerms;
- (bigintobj_vardnsrecdegspspol_t)bigintobj_vardnsrecdegspspol_value;
- bigintobj_vardnsrecdegspspol_value:(bigintobj_vardnsrecdegspspol_t)aValue;
- (bigintobj_vardnsrecdegspspol_t)bigintobj_vardnsrecdegspspol_reference;
- bigintobj_vardnsrecdegspspol_reference:(bigintobj_vardnsrecdegspspol_c *)aReference;

- copy;
- deepCopy;
- (BOOL) isEmpty;
- (BOOL) isOne;
- (BOOL) isMinusOne;
- (unsigned) hash;
- (BOOL) isEqual:b;
- (BOOL) notEqual:b;
- (BOOL) isZero;
- (BOOL) notZero;
- (BOOL) isOpposite:b;
- (BOOL) notOpposite:b;
- negate;
- negateSelf;
- _double:(int)v;
- _doubleSelf:(int)v;
- double;
- doubleSelf;
- _add:(int)v:b:(int)w;
- _addSelf:(int)v:b:(int)w;
- add:b;
- addSelf:b;
- subtract:b;
- subtractSelf:b;
- (int) leadingDegree;
- (int) lastDegree;
- (int) maxDegree;
- (int) minDegree;
- asScalar;
- asSymbol;
- check;
- release;
- eachTerm;
- elt_bigintobj_vardnsrecdegspspol_ix:(bigintobj_vardnsrecdegspspol_ixt)ix;
- removeTerm;
- insertTerm:aTerm;
- multiplyCoefficient:s;
- multiplySelfCoefficient:s;
- divideCoefficient:s;
- divideSelfCoefficient:s;
- _add:(int)v:B multiplyCoefficient:b:(int)w;
- _addSelf:(int)v:B multiplyCoefficient:b:(int)w;
- _multiplyCoefficient:a:(int)v add:B:(int)w;
- _multiplySelfCoefficient:a:(int)v add:B:(int)w;
- _multiplyCoefficient:a:(int)v add:B multiplyCoefficient:b:(int)w;
- _multiplySelfCoefficient:a:(int)v add:B multiplyCoefficient:b:(int)w;
- multiplyTerm:aTerm;
- multiplySelfTerm:aTerm;
- _multiplyTerm:aTerm:(int)v;
- _multiplySelfTerm:aTerm:(int)v;
- divideTerm:aTerm;
- divideSelfTerm:aTerm;
- _add:(int)v:B multiplyTerm:b:(int)w;
- _addSelf:(int)v:B multiplyTerm:b:(int)w;
- _multiplyCoefficient:a:(int)v add:B multiplyTerm:b:(int)w;
- _multiplySelfCoefficient:a:(int)v add:B multiplyTerm:b:(int)w;

- fileOutOn:aFiler;
- fileInFrom:aFiler;
@end

#endif /* __bigintobj_vardnsrecdegsps_polynomial_header__ */
 
