
/*
 * Computer Algebra Kit (c) 1993,99 by Comp.Alg.Objects.  All Rights Reserved.
 * $Id: fraction.h,v 1.2 1999/07/06 19:48:09 stes Exp $
 */

#ifndef __CAFRACTION_HEADER__
#define __CAFRACTION_HEADER__

#include "cobject.h"

@interface Fraction : CAObject
{
  id numerator;
  id denominator;
}
- check;

- totalFraction:aNumerator;
+ totalFraction:aNumerator;
- _setUpNumerator:aNumerator denominator:aDenominator;
+ numerator:aNumerator denominator:aDenominator;
- copy;
- deepCopy;
- numerator:n denominator:d;
- numerator:aNumerator;
- denominator:aDenominator;
- denominator:aNumerator numerator:aDenominator;
- numerator:aNumerator numerator:aDenominator;

- numerator;
- denominator;
- (unsigned) hash;
- (BOOL) isEqual:b;
- (int) compare:b;

- asNumerical;
- asModp:(unsigned short)p;
- asIntegral;

- zero;
- (BOOL) isZero;
- (BOOL) isOpposite:b;
- negate;
- double;
- add:b;
- subtract:b;

- one;
- (BOOL) isOne;
- (BOOL) isMinusOne;
- square;
- inverse;
- multiply:b;
- divide:b;
- power:(int)n;

- intValue:(int)intValue;
- (int) intValue;
- multiplyIntValue:(int)intValue;
- divideIntValue:(int)intValue;

- (BOOL) printsLeadingSign;
- (BOOL) printsSum;
- (BOOL) printsProduct;
- printOn:(IOD)aFile;
@end

#endif /* __CAFRACTION_HEADER__ */
 
