
/*
 * Computer Algebra Kit (c) 1994,99 by Comp.Alg.Objects.  All Rights Reserved.
 * $Id: ccltn.h,v 1.2 1999/07/06 19:48:08 stes Exp $
 */

#ifndef __CACOLLECTION_HEADER__
#define __CACOLLECTION_HEADER__

#include "cobject.h"

typedef id *mmbs_t;

typedef struct cltn
  {
    int count;
    int capacity;
    mmbs_t members;
  }
 *cltn_t;

@interface CACollection : CAObject
{
  struct cltn value;
}
- check;

- _setUpCapacity:(int)aCapacity;
+ new;
- new:(unsigned)aCapacity;
+ new:(unsigned)aCapacity;
- capacity:(int)aCapacity;
- empty;
- copy;
- deepCopy;
- release;

- (cltn_t) cltn_value;
- (BOOL) isEqual:aCollection;
- (unsigned) hash;
- (BOOL) isEmpty;
- (BOOL) notEmpty;
- (unsigned) size;

- add:anObject;
- addIfAbsent:anObject;
- at:(unsigned)i insert:anObject;

- removeLast;
- removeAt:(int)i;
- remove:anObject;

- at:(unsigned)i put:anObject;
- swapElementsAt:(int)i:(int)j;

- eachElement;
- eachElementReversed;
- at:(unsigned)i;
- (float) floatValueAt:(int)i;
- (int) intValueAt:(int)i;
- lastElement;
- (int) offsetOf:anObject;

- (BOOL) isSorted;
- (BOOL) notSorted;
- sort;
- reverse;

- merge:aCltn;
- union:aCltn;

- printOn:(IOD)aFile;

- fileOutOn:aFiler;
- fileInFrom:aFiler;
@end

#endif /* __CACOLLECTION_HEADER__ */
 
