/** \file UTIL_Misc.h
    Generic (abstract) filter classes.

Copyright (c) 1998-1999 by Amir Geva.
This file is part of the Photon Game Development library,
beta release version 0.25.
Permission is granted to use and copy this file for non-commercial use only.
Please contact the author concerning commercial usage.
Amir Geva makes no representations about the suitability of this software for any purpose.
It is provided "as is" without express or implied warranty.

*/
#ifndef H_UTIL_MISC
#define H_UTIL_MISC

/** A generic write monitor, used to track writing for output filters. */
class WriteMonitor
{
public:
  virtual ~WriteMonitor() {}
  virtual void update(int Bytes)=0;
};

/** A Generic output data filter. */
class OutputFilter : public WriteMonitor
{
public:
  /** Processes data from the buffer up to Len bytes.
	    Returns the number of bytes processed. */
  virtual int Write(char* Buffer, int Len) = 0;
};

/** A Generic input data filter. */
class InputFilter
{
public:
  virtual ~InputFilter() {}
  /** Fills the buffer with data up to Len bytes.
	    Returns the number of bytes placed in the buffer. */
  virtual int Read(char* Buffer, int Len) = 0;
};

#endif // H_UTIL_MISC