/** \file CON_Bitmap.h
    Bitmap object.  Used for blitting to the screen.

Copyright (c) 1998-1999 by Amir Geva.
This file is part of the Photon Game Development library,
beta release version 0.25.  
Permission is granted to use and copy this file for non-commercial use only.  
Please contact the author concerning commercial usage. 
Amir Geva makes no representations about the suitability of this software for any purpose.
It is provided "as is" without express or implied warranty.

*/
#ifndef H_CON_BITMAP
#define H_CON_BITMAP

#include <CON_Screen.h>

/** A bitmap has the same interface as a Drawable.  Only internal implementation differs. */
typedef Drawable Bitmap;



////////////////////////////////////////////////////////////
// Bitmap creation.
////////////////////////////////////////////////////////////
#ifndef FUNC_BITMAP
#define FUNC_BITMAP


/** \relates Drawable
    Creates a new bitmap with the specified size. */
DLLExport Bitmap* newBitmap(int Width, int Height, int NoAccel=0);

/** \relates Drawable
    Creates a copy of the given bitmap. */
DLLExport Bitmap* newBitmap(Bitmap* BM);

/** \relates Drawable
    Creates a bitmap and loads it from the input stream */
DLLExport Bitmap* newBitmap(istream& is, int Width, int Height, int NoAccel=0);

/** \relates Drawable
    Creates a bitmap and loads it from the input stream */
DLLExport Bitmap* newBitmap(istream& is, int NoAccel=0);

/** \relates Drawable
    Creates a bitmap and loads it from a *.BMP file */
DLLExport Bitmap* loadBMP(const char* Filename);

/** Old version given for compatibility. */
inline Bitmap* loadBitmap(Screen* S, istream& is)
{
  return newBitmap(is,S->getNoAccel());
}


#endif // FUNC_BITMAP




#endif // H_CON_BITMAP