#ifndef H_GAMESPRITES
#define H_GAMESPRITES

#include "Particles.h"
#include "CON_Bitmap.h"

class Bullet : public AnimatedSprite
{
public:
  Bullet(SpriteCache* SC) : AnimatedSprite()
  {
    addAnimationFrame(SC->load("bullet.bin",1),10.04f);
  }

  ~Bullet()
  {
  }
 
  virtual long collision(Collidable_Object* O)
  {
    return rcDELETE;  // Destroy the bullet
  }

  virtual long advance(float Fraction)
  {
    fVector2D P=getPosition();
    if (P.getY()<0) return -1;
    fVector2D Move(0.0f,-300.0f*Fraction);
    setPosition(P+Move);
    return AnimatedSprite::advance(Fraction);
  }
};

class UFO : public AnimatedSprite
{
public:
  UFO(SpriteCache* SC) : AnimatedSprite(), dx(180), m_Blow(NULL)
  {
    addAnimationFrame(SC->load("ufo.bin",1),0.1f);
    addAnimationFrame(SC->load("ufo2.bin",1),0.1f);
    setPosition(fVector2D(100.0f,40.0f));
    if (getConsole()->getSound()!=NULL)
    {
      m_Blow=loadWaveFile("expl.wav");
    }
  }

  ~UFO()
  {
    if (m_Blow!=NULL)
    {
      if (m_Blow->isPlaying()) m_Blow->destroyOnStop();
      else m_Blow->release();
    }
  }

  virtual long collision(Collidable_Object* O)
  {
    if (m_Blow!=NULL) 
    {
      m_Blow->play(0);
    }
    ParticleSystem* PS=new ParticleSystem(256,256,1500);
    fVector2D P=getPosition();
    fVector2D Move(-112.0f,-112.0f);
    PS->setPosition(P+Move);
    m_World->add(PS);
    return rcDELETE;  // Destroy the UFO
  }

  virtual long advance(float Fraction)
  {
    fVector2D P=getPosition();
    fVector2D Move(dx*Fraction,0.0f);
    if (P.getX()+Move.x<10 || P.getX()+Move.x>280) dx=-dx;
    else
       setPosition(P+Move);
    return AnimatedSprite::advance(Fraction);
  }

protected:
  int dx;
  SoundClip* m_Blow;
};


class Player : public AnimatedSprite
{
public:
  Player(SpriteCache* SC, Console* C) : 
    AnimatedSprite(), 
    m_Keys(*C->getKeyboard()), 
    m_Joystick(C->getJoystick()),
    m_Fire(NULL),
    m_SC(SC)
  {
    addAnimationFrame(SC->load("player1.bin",0),0.04f);
    addAnimationFrame(SC->load("player2.bin",0),0.04f);
    setPosition(fVector2D(200.0f,200.0f));
    if (C->getSound()!=NULL)
    {
      m_Fire=loadWaveFile("fire.wav");
    }
  }

  ~Player()
  {
    if (m_Fire!=NULL) m_Fire->release();
  }

  virtual long advance(float Fraction)
  {
    int dx=250;
    int move=0;
    int fire=0;
    if (m_Joystick!=NULL) 
    {
      m_Joystick->update();
      int x=m_Joystick->getX();
      if (x<25000) move=-dx;
      if (x>39000) move=dx;
      if (m_Joystick->button(0)) fire=1;
    }
    if (m_Keys[DIK_LEFT]) move=-dx;
    if (m_Keys[DIK_RIGHT]) move=dx;
    fVector2D P=getPosition()+fVector2D(move*Fraction,0.0f);
    if (move && P.getX()>20 && P.getX()<280) setPosition(P);
    if (m_Keys[DIK_F12] && !m_Keys.constPress(DIK_F12)) m_World->add(new UFO(m_SC));
    if (m_Keys[DIK_SPACE] && !m_Keys.constPress(DIK_SPACE)) fire=1;
    if (fire)
    {
      if (m_Fire!=NULL) 
      {
        if (m_Fire->isPlaying()) fire=0;
        else m_Fire->play(0);
      }
      if (fire)
      {
        Bullet* b=new Bullet(m_SC);
        fVector2D P(getMiddle().getX()-4.0f,getPosition().getY());
        b->setPosition(P);
        m_World->add(b);
      }
    }
    return AnimatedSprite::advance(Fraction);
  }
protected:
  Keyboard&       m_Keys;
  Joystick*       m_Joystick;
  SpriteCache*    m_SC;
  SoundClip*      m_Fire;

};

#endif // H_GAMESPRITES