// ISDemoDlg.cpp : implementation file
//

#include "stdafx.h"
#include "ISDemo.h"
#include "ISDemoDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CAboutDlg dialog used for App About

class CAboutDlg : public CDialog
{
public:
	CAboutDlg();

// Dialog Data
	//{{AFX_DATA(CAboutDlg)
	enum { IDD = IDD_ABOUTBOX };
	CStatic	m_vers;
	//}}AFX_DATA

	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CAboutDlg)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	//{{AFX_MSG(CAboutDlg)
	virtual BOOL OnInitDialog();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};


BOOL CAboutDlg::OnInitDialog() 
{
	CDialog::OnInitDialog();
	
	char v[20];
	_ISGetDLLVersion(v);
	CString t = "_ISource version : ";
	t+= v;
	m_vers.SetWindowText(t);
	
	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
	//{{AFX_DATA_INIT(CAboutDlg)
	//}}AFX_DATA_INIT
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAboutDlg)
	DDX_Control(pDX, IDC_ISOURCEVERS, m_vers);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
	//{{AFX_MSG_MAP(CAboutDlg)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

BOOL CALLBACK callBackFn(const UINT32 uCurRow, 
								const UINT32 uTotalRows,
								const UINT32 uUserData)
{
	if ((uCurRow % 10) == 0)
	{
		TRACE("Callback : (data = %d) %4.2f complete\n", uUserData, ((double)uCurRow / (double)uTotalRows) * 100.0);
	}

	return TRUE;
}

/////////////////////////////////////////////////////////////////////////////
// CISDemoDlg dialog

CISDemoDlg::CISDemoDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CISDemoDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CISDemoDlg)
	m_bBlur = FALSE;
	m_uBlurLevel = 50;
	m_bFlipV = FALSE;
	m_bGrayscale = FALSE;
	m_bHistBlue = TRUE;
	m_bHistGreen = TRUE;
	m_uHistHigh = 240;
	m_uHistLow = 16;
	m_bHistRed = TRUE;
	m_bHist = FALSE;
	m_bFlipH = FALSE;
	m_iLUTSel = 0;
	m_bLUTBlue = TRUE;
	m_bLUTGreen = TRUE;
	m_bLUTRed = TRUE;
	m_bLUT = FALSE;
	m_bMedianCut = FALSE;
	m_uQuantColors = 16;
	m_bQuantize = FALSE;
	m_bRGBBGR = FALSE;
	m_iRotateSel = 0;
	m_bSharpen = FALSE;
	m_uSharpenLevel = 50;
	m_iHistoSel = 0;
	m_bDespeckle = FALSE;
	m_bAutoBright = FALSE;
	//}}AFX_DATA_INIT
	// Note that LoadIcon does not require a subsequent DestroyIcon in Win32
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);

	// LUT
	for (int lb=0;lb<256;lb++)
	{
		m_InvLUT[lb]=255 - (BYTE)lb;
		m_StepLUT[lb]=((BYTE)lb / 32) * 32;
	}

	// global image
	m_rgbBuf=NULL;
	m_width=0;
	m_height=0;

	m_LUTChannelMask=CHRED | CHBLUE | CHGREEN;

	m_EQGraphMask = 0;	// lum
	for (int i=0; i<256; i++) m_EQHisto[i]=0;

	MakePalette();

}

CISDemoDlg::~CISDemoDlg()
{
	CleanUp();
	m_pal.DeleteObject();
}

void CISDemoDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CISDemoDlg)
	DDX_Control(pDX, IDC_COLOR_TEXT, m_colorTextWnd);
	DDX_Control(pDX, IDC_IMGRECT_BEFORE, m_imgRectBefore);
	DDX_Control(pDX, IDC_IMGRECT, m_imgRectAfter);
	DDX_Control(pDX, IDC_HISTO_FRAME, m_histoFrame);
	DDX_Check(pDX, IDC_BLUR_CHECK, m_bBlur);
	DDX_Text(pDX, IDC_BLUR_LEVEL, m_uBlurLevel);
	DDX_Check(pDX, IDC_FLIP, m_bFlipV);
	DDX_Check(pDX, IDC_GRAYSCALE, m_bGrayscale);
	DDX_Check(pDX, IDC_HIST_BLUE, m_bHistBlue);
	DDX_Check(pDX, IDC_HIST_GREEN, m_bHistGreen);
	DDX_Text(pDX, IDC_HIST_HIGH, m_uHistHigh);
	DDX_Text(pDX, IDC_HIST_LOW, m_uHistLow);
	DDX_Check(pDX, IDC_HIST_RED, m_bHistRed);
	DDX_Check(pDX, IDC_HISTCHECK, m_bHist);
	DDX_Check(pDX, IDC_HORIZFLIP, m_bFlipH);
	DDX_Radio(pDX, IDC_LINLUT, m_iLUTSel);
	DDX_Check(pDX, IDC_LUT_BLUE, m_bLUTBlue);
	DDX_Check(pDX, IDC_LUT_GREEN, m_bLUTGreen);
	DDX_Check(pDX, IDC_LUT_RED, m_bLUTRed);
	DDX_Check(pDX, IDC_LUTCHECK, m_bLUT);
	DDX_Check(pDX, IDC_MEDIAN_CUT, m_bMedianCut);
	DDX_Text(pDX, IDC_QUANT_COLORS, m_uQuantColors);
	DDX_Check(pDX, IDC_QUANTIZE_CHECK, m_bQuantize);
	DDX_Check(pDX, IDC_RGBBGR, m_bRGBBGR);
	DDX_Radio(pDX, IDC_ROTATE_NONE, m_iRotateSel);
	DDX_Check(pDX, IDC_SHARPEN_CHECK, m_bSharpen);
	DDX_Text(pDX, IDC_SHARPEN_LEVEL, m_uSharpenLevel);
	DDX_Radio(pDX, IDC_EQ_LUM, m_iHistoSel);
	DDX_Check(pDX, IDC_DESPECKLE, m_bDespeckle);
	DDX_Check(pDX, IDC_AUTOBRIGHT, m_bAutoBright);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CISDemoDlg, CDialog)
	//{{AFX_MSG_MAP(CISDemoDlg)
	ON_WM_SYSCOMMAND()
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_BN_CLICKED(IDC_ABOUT, OnAbout)
	ON_BN_CLICKED(IDC_SAVE, OnSave)
	ON_BN_CLICKED(IDC_OPEN, OnOpen)
	ON_BN_CLICKED(IDC_BLUR_CHECK, UpdateInvalidate)
	ON_EN_CHANGE(IDC_BLUR_LEVEL, UpdateInvalidate)
	ON_BN_CLICKED(IDC_EQ_BLUE, UpdateInvalidate)
	ON_BN_CLICKED(IDC_EQ_GREEN, UpdateInvalidate)
	ON_BN_CLICKED(IDC_EQ_LUM, UpdateInvalidate)
	ON_BN_CLICKED(IDC_EQ_RED, UpdateInvalidate)
	ON_BN_CLICKED(IDC_FLIP, UpdateInvalidate)
	ON_BN_CLICKED(IDC_GRAYSCALE, UpdateInvalidate)
	ON_BN_CLICKED(IDC_HIST_BLUE, UpdateInvalidate)
	ON_BN_CLICKED(IDC_HIST_GREEN, UpdateInvalidate)
	ON_EN_CHANGE(IDC_HIST_HIGH, UpdateInvalidate)
	ON_EN_CHANGE(IDC_HIST_LOW, UpdateInvalidate)
	ON_BN_CLICKED(IDC_HIST_RED, UpdateInvalidate)
	ON_BN_CLICKED(IDC_HISTCHECK, UpdateInvalidate)
	ON_BN_CLICKED(IDC_HORIZFLIP, UpdateInvalidate)
	ON_BN_CLICKED(IDC_INVLUT, UpdateInvalidate)
	ON_BN_CLICKED(IDC_LINLUT, UpdateInvalidate)
	ON_BN_CLICKED(IDC_LUT_BLUE, UpdateInvalidate)
	ON_BN_CLICKED(IDC_LUT_GREEN, UpdateInvalidate)
	ON_BN_CLICKED(IDC_LUT_RED, UpdateInvalidate)
	ON_BN_CLICKED(IDC_LUTCHECK, UpdateInvalidate)
	ON_BN_CLICKED(IDC_MEDIAN_CUT, UpdateInvalidate)
	ON_EN_CHANGE(IDC_QUANT_COLORS, UpdateInvalidate)
	ON_BN_CLICKED(IDC_QUANTIZE_CHECK, UpdateInvalidate)
	ON_BN_CLICKED(IDC_RGBBGR, UpdateInvalidate)
	ON_BN_CLICKED(IDC_ROTATE_180, UpdateInvalidate)
	ON_BN_CLICKED(IDC_ROTATE_270, UpdateInvalidate)
	ON_BN_CLICKED(IDC_ROTATE_90, UpdateInvalidate)
	ON_BN_CLICKED(IDC_ROTATE_NONE, UpdateInvalidate)
	ON_BN_CLICKED(IDC_SHARPEN_CHECK, UpdateInvalidate)
	ON_EN_CHANGE(IDC_SHARPEN_LEVEL, UpdateInvalidate)
	ON_BN_CLICKED(IDC_DESPECKLE, UpdateInvalidate)
	ON_BN_CLICKED(IDC_AUTOBRIGHT, UpdateInvalidate)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CISDemoDlg message handlers

BOOL CISDemoDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// Add "About..." menu item to system menu.

	// IDM_ABOUTBOX must be in the system command range.
	ASSERT((IDM_ABOUTBOX & 0xFFF0) == IDM_ABOUTBOX);
	ASSERT(IDM_ABOUTBOX < 0xF000);

	CMenu* pSysMenu = GetSystemMenu(FALSE);
	if (pSysMenu != NULL)
	{
		CString strAboutMenu;
		strAboutMenu.LoadString(IDS_ABOUTBOX);
		if (!strAboutMenu.IsEmpty())
		{
			pSysMenu->AppendMenu(MF_SEPARATOR);
			pSysMenu->AppendMenu(MF_STRING, IDM_ABOUTBOX, strAboutMenu);
		}
	}

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	//SetIcon(m_hIcon, FALSE);		// Set small icon
	
	// load the sample image
	LoadDefaultImage();

	return TRUE;  // return TRUE  unless you set the focus to a control
}

void CISDemoDlg::OnSysCommand(UINT nID, LPARAM lParam)
{
	if ((nID & 0xFFF0) == IDM_ABOUTBOX)
	{
		CAboutDlg dlgAbout;
		dlgAbout.DoModal();
	}
	else
	{
		CDialog::OnSysCommand(nID, lParam);
	}
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CISDemoDlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CPaintDC dc(this); // device context for painting

		CPalette * op = dc.SelectPalette(&m_pal,FALSE);
		dc.RealizePalette();

		// where to draw to
		CRect afterRect;
		m_imgRectAfter.GetWindowRect(afterRect);
		ScreenToClient(afterRect);
		afterRect.InflateRect(-2,-2);
		dc.FillRect(afterRect, &CBrush(::GetSysColor(COLOR_3DFACE)));

		// where to draw to
		CRect beforeRect;
		m_imgRectBefore.GetWindowRect(beforeRect);
		ScreenToClient(beforeRect);
		beforeRect.InflateRect(-2,-2);
		dc.FillRect(beforeRect, &CBrush(::GetSysColor(COLOR_3DFACE)));

		// draw the before image

		// this call wraps a call to _ISRGBToHBITMAP as well as all the
		// usual CreateCompatibleDC, SelectObject, BitBlt stuff
		if (m_rgbBuf!=NULL) 
		{
			_ISDrawRGB(dc.m_hDC,
							m_rgbBuf, 
							m_width, m_height, 
							beforeRect.left,
							beforeRect.top,
							min(beforeRect.Width(), (int)m_width),		// clip
							min(beforeRect.Height(),(int)m_height),
							(HPALETTE)m_pal.GetSafeHandle());	//optional
		}


		// apply the changes to generate the "after" image
		BYTE *outputImage = RenderImage();

		// draw the After image
		if (outputImage!=NULL) 
		{
			_ISDrawRGB(dc.m_hDC,
							outputImage, 
							m_width, m_height, 
							afterRect.left,
							afterRect.top,
							min(afterRect.Width(), (int)m_width),		// clip
							min(afterRect.Height(), (int)m_height),
							(HPALETTE)m_pal.GetSafeHandle()); //optional

			delete [] outputImage;
		}

		// draw histo graph

		// where to draw to
		CRect graphRect;
		m_histoFrame.GetWindowRect(graphRect);
		ScreenToClient(graphRect);
		graphRect.InflateRect(-2,-2);
		dc.FillRect(graphRect, CBrush::FromHandle((HBRUSH)::GetStockObject(WHITE_BRUSH)));

		// fit this in our space
		UINT32 maxval = 0;
		for (int z = 0; z<256; z++)
			maxval = max(maxval, m_EQHisto[z]);

		if (maxval > 0) 
		{
			double xscale = (double)(graphRect.Width() - 5) / 256;
			double yscale = (double)(graphRect.Height() - 5) / maxval;

			// draw it
			for (int i=0; i<255; i++) 
			{
				double xpos = xscale * i + 2 + graphRect.left;
				double ypos = graphRect.bottom - (yscale * m_EQHisto[i] + 2);

				dc.MoveTo((int)xpos, (int)ypos);
				dc.LineTo((int)xpos, (graphRect.bottom - 2));

			}
		}

		dc.SelectPalette(op, FALSE);

		CDialog::OnPaint();
	}

}

// The system calls this to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CISDemoDlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}

void CISDemoDlg::UpdateInvalidate()
{
	UpdateData(TRUE);
	InvalidateAfter();
}

void CISDemoDlg::OnAbout() 
{
	CAboutDlg t;
	t.DoModal();
	
}

void CISDemoDlg::OnSave() 
{
	CString fileName;
	CString filt="JPG File (*.JPG)|*.JPG|24-Bit PNG File (*.PNG)|*.PNG|8-bit PNG File (*.PNG)|*.PNG|24-bit BMP (*.BMP)|*.BMP|8-bit BMP (*.BMP)|*.BMP|4-bit BMP (*.BMP)|*.BMP||";
    
    // OPENFILENAME - so i can get to its Help page easily
	CFileDialog fileDlg(FALSE,"*.JPG","*.JPG",NULL,filt,this);

	fileDlg.m_ofn.Flags|=OFN_FILEMUSTEXIST;
	fileDlg.m_ofn.lpstrTitle="File to save as";

	CWaitCursor bob;

	if (fileDlg.DoModal()==IDOK) 
	{
		fileName=fileDlg.GetPathName();

		HISDEST hDest = _ISOpenFileDest(fileName);
		if (hDest==NULL)
		{
			AfxMessageBox("Cannot open file for writing");
			return;
		}

		
		CString ext=fileName.Right(4);

		// draw the output image
		BYTE *tmp = RenderImage();

		DWORD imgByteSize = (m_width * m_height * 3);

		switch (fileDlg.m_ofn.nFilterIndex) 
		{
		default:
		case 1: //JPG
			{
				if (!_ISWriteJPG(hDest, tmp, m_width, m_height, 75, FALSE, 24, NULL)) 
				{
					AfxMessageBox(StringFromErrorNum(_ISGetLastError()));
				}
			}
			break;
		case 2:	// PNG-24
			{
				if (!_ISWritePNG(hDest, tmp, m_width, m_height, m_width * 3, 8, 1<<24, NULL, 2, 0.0, 1, NULL)) 
				{
					AfxMessageBox(StringFromErrorNum(_ISGetLastError()));
				}
			}
			break;
		case 3:	//	PNG-8
			{
				int colors = (fileDlg.m_ofn.nFilterIndex == 5 ? 16 : 256);

				// make a buffer for the quantized version
				BYTE *qImg;
				try 
				{
					qImg = (BYTE *) new BYTE[imgByteSize];
				} 
				catch (CMemoryException *e) 
				{
					e->ReportError();
					e->Delete();
					AfxMessageBox(StringFromErrorNum(IS_ERR_MEM));
					_ISCloseDest(hDest);
					return ;
				}

				// quantize it
				RGBQUAD pal[256];
				if (!_ISQuantizeRGBTo8Bit(tmp,
											m_width,
											m_height,
											qImg,
											colors,
											pal,
											0)) 
				{
					AfxMessageBox(StringFromErrorNum(_ISGetLastError()));
					_ISCloseDest(hDest);
					return;
				}

				// save it
				if (!_ISWritePNG(hDest, qImg, m_width, m_height, m_width, 8, 256, pal, 3, 0.0, 1, NULL)) 
				{
					AfxMessageBox(StringFromErrorNum(_ISGetLastError()));
				}
				delete [] qImg;
			}
			break;

		case 4: //24 bit BMP
			if (!_ISWriteBMP(hDest, tmp, m_width, m_height, 24, 1 << 24, NULL, FALSE)) 
			{
				AfxMessageBox(StringFromErrorNum(_ISGetLastError()));
			}

			break;

		case 5: // 8-bit BMP, 4-bit BMP
		case 6:
			{
				int colors = (fileDlg.m_ofn.nFilterIndex == 6 ? 16 : 256);
				int bits = (fileDlg.m_ofn.nFilterIndex == 6 ? 4 : 8);

				// make a buffer for the quantized version
				BYTE *qImg;
				try 
				{
					qImg = (BYTE *) new BYTE[imgByteSize];
				} 
				catch (CMemoryException *e) 
				{
					e->ReportError();
					e->Delete();
					AfxMessageBox(StringFromErrorNum(IS_ERR_MEM));
					_ISCloseDest(hDest);
					return ;
				}

				// quantize it
				RGBQUAD pal[256];
				if (!_ISQuantizeRGBTo8Bit(tmp,
											m_width,
											m_height,
											qImg,
											colors,
											pal,
											0)) 
				{
					AfxMessageBox(StringFromErrorNum(_ISGetLastError()));
					_ISCloseDest(hDest);
					return;
				}

				if (fileDlg.m_ofn.nFilterIndex==6)
				{
					// need to pack this into 4bpp rows
					BYTE *pPacked = new BYTE [((m_width + 1) /2) * m_height];

					// this says "pack the high 4 bits of each 8 bit pixel 
					// into rows ((m_width + 1) /2) bytes wide". that's what the BMP
					// writer wants.
					_ISPack8BitBuffer(qImg, m_width, m_width, pPacked, 4, TRUE, ((m_width + 1) /2));

					// save it
					if (!_ISWriteBMP(hDest, pPacked, m_width, m_height, bits, colors, pal, FALSE)) 
					{
						AfxMessageBox(StringFromErrorNum(_ISGetLastError()));
					}

					delete [] pPacked;
				}
				else
				{
					// save it
					if (!_ISWriteBMP(hDest, qImg, m_width, m_height, bits, colors, pal, FALSE)) 
					{
						AfxMessageBox(StringFromErrorNum(_ISGetLastError()));
					}
				}
				delete [] qImg;
			}
			break;
		}
		
		delete [] tmp;

		_ISCloseDest(hDest);

	}

}

void CISDemoDlg::OnOpen() 
{
	CString fileName;
	CString filt="JPG Files (*.JPG)|*.JPG| \
PNG Files (*.PNG)|*.PNG| \
TIFF Files (*.TIF)|*.TIF| \
BMP Files (*.BMP)|*.BMP| \
Photoshop Files (*.PSD)|*.PSD| \
ZSoft PCX Files (*.PCX)|*.PCX| \
Targa Files (*.TGA)|*.TGA| \
Windows Metafiles (*.WMF)|*.WMF| \
All files (*.*)|*.*||";

    // OPENFILENAME - so i can get to its Help page easily

	CString defFilt = "*.PSD;*.BMP;*.JPG;*.PCX;*.PNG;*.WMF;*.TGA;*.TIF;";
	CFileDialog fileDlg(TRUE,defFilt, defFilt, NULL,filt,this);

	fileDlg.m_ofn.Flags|=OFN_FILEMUSTEXIST;
	fileDlg.m_ofn.lpstrTitle="File to load";

	if (fileDlg.DoModal()==IDOK) 
	{

		CWaitCursor bob;

		fileName=fileDlg.GetPathName();
		CString ext=fileName.Right(4);

		HGLOBAL hImg=NULL;

		UINT32 w,h;

		// tell the DLL to call the function "callBackFn" on every scan line processed.
		// the second parameter is a 32-bit user data value. we'll just set it to 15 here.
		// ImgSource will pass this value to the callback function.
		_ISSetCallback(callBackFn, 15);

		HISSRC hSource = _ISOpenFileSource(fileName);
		if (hSource==NULL)
		{
			AfxMessageBox(StringFromErrorNum(_ISGetLastError()));
			return;
		}

		// read new image
		if (!ext.CompareNoCase(".JPG"))
			hImg = _ISReadJPG(hSource, &w, &h, 24);

		if (!ext.CompareNoCase(".PNG"))
			hImg = _ISReadPNG(hSource, &w, &h, 24, NULL);

		if (!ext.CompareNoCase(".TGA"))
			hImg = _ISReadTGA(hSource, &w, &h, 24, NULL);

		if (!ext.CompareNoCase(".TIF"))
			hImg = _ISReadTIFF(hSource, &w, &h, 24, NULL, 0);

		if (!ext.CompareNoCase(".BMP"))
			hImg = _ISReadBMP(hSource, &w, &h, 24, NULL);

		if (!ext.CompareNoCase(".PCX"))
			hImg = _ISReadPCX(hSource, &w, &h, 24, NULL);

		if (!ext.CompareNoCase(".PSD"))
			hImg = _ISReadPSD(hSource, &w, &h, 24, NULL);

		// turn off the callback. most image processing functions will call the
		// callback function. if we leave this on, we'll be flooded with TRACEs
		_ISSetCallback(NULL, 0);

		_ISCloseSource(hSource);

		if (hImg!=NULL) 
		{
			BYTE *tmp = (BYTE *)hImg;
			if (tmp!=NULL) 
			{
									   
				// copy to our global RGB buffer, if we can
				DWORD imgSize = w * h * 3;

				CleanUp();

				try 
				{
					m_rgbBuf = (BYTE *) new BYTE[imgSize];
				} 
				catch (CMemoryException *e) 
				{
					e->ReportError();
					e->Delete();
					CleanUp();
					return;
				}

				// copy
				memcpy(m_rgbBuf, tmp, imgSize);
				m_width=w;
				m_height=h;

				// clean up
				GlobalFree(hImg);

				// redraw
				InvalidateBefore();
				InvalidateAfter();
			}
		} 
		else 
		{
			AfxMessageBox(StringFromErrorNum(_ISGetLastError()));
		}

	}            

}


void CISDemoDlg::InvalidateAfter()
{
	// where to draw to
	CRect outRect;
	m_imgRectAfter.GetWindowRect(outRect);
	ScreenToClient(outRect);

	// if our after image changed, so did our histogram
	InvalidateHistogram();

	InvalidateRect(outRect, FALSE);
}

void CISDemoDlg::InvalidateBefore()
{
	// where to draw to
	CRect outRect;
	m_imgRectBefore.GetWindowRect(outRect);
	ScreenToClient(outRect);

	// if our after image changed, so did our histogram
	InvalidateHistogram();

	InvalidateRect(outRect, FALSE);
}

// call this when we want to redraw the histogram image
void CISDemoDlg::InvalidateHistogram()
{
	// where to draw to
	CRect graphRect;
	m_histoFrame.GetWindowRect(graphRect);
	ScreenToClient(graphRect);

	InvalidateRect(graphRect, FALSE);

}


// creates a spread of colors - no real method, just a semi-even spread
// this is all you really need to get better than Windows standard...
void CISDemoDlg::MakePalette()
{ 
	LPLOGPALETTE     lpPal;
	BYTE *           pLogPal;
	HPALETTE         hPal = NULL;
	int              i;

	try 
	{
		pLogPal = new BYTE [sizeof (LOGPALETTE) + (sizeof (PALETTEENTRY) * (256))];
	} 
	catch (CMemoryException *e) 
	{
		e->ReportError();
		e->Delete();
		pLogPal=NULL;
		return;
	}

	lpPal = (LPLOGPALETTE) pLogPal;
	lpPal->palVersion = 0x300;
	lpPal->palNumEntries = 256;

	int r,g,b;
	r=b=g=0;
	for (i=0;i<256;i++) 
	{
		lpPal->palPalEntry[i].peRed   = (BYTE)r % 256;
		lpPal->palPalEntry[i].peGreen = (BYTE)g % 256;
		lpPal->palPalEntry[i].peBlue  = (BYTE)b % 256;
		lpPal->palPalEntry[i].peFlags = 0;

	   r+=16;
	   g+=4;
	   b++;
	}

	BOOL ok = m_pal.CreatePalette (lpPal);

	delete [] pLogPal;
}


void CISDemoDlg::LoadDefaultImage()
{
	CleanUp();

	// we'll need our palette to render the bitmap on < 16 bit displays
	HPALETTE hPal = (HPALETTE)m_pal.GetSafeHandle();


	//	use _ISLoadResourceBitmap, instead of CBitmap::LoadBitmap!
	//
	//	on 8-bit displays, LoadBitmap maps the bitmap to the 16-colors
	//	of the standard Windows palette - this is no good. you don't even
	//	get a chance to use a palette on the image because LoadBitmap mangles
	//	the color info!! yuck!!
	//
	//	if you use this function, with a palette that represents a
	//  spread of colors from the image, or even just a nice spread of
	//	colors all across the spectrum, you'll get much better results.
	//	trust me. 
	//	
	//	if you use a NULL palette, this function will use a 
	//	set of colors from the system palette, which will give slightly
	//	better results than LoadBitmap.
	//
	//	if you don't believe me, get into 256-color mode, replace the 
	//	_ISLoadResourceBitmap call with these two lines and see what happens.
	//
	//	CBitmap tmpBmp; tmpBmp.LoadBitmap(IDB_SAMPLE_IMAGE);
	//	HBITMAP hTmpBmp = tmpBmp.GetSafeHandle();
	//

	HBITMAP hTmpBmp = _ISLoadResourceBitmap(AfxGetInstanceHandle(),
														(LPSTR)IDB_SAMPLE_IMAGE,
														hPal);

	if (hTmpBmp==NULL) 
	{
		AfxMessageBox(StringFromErrorNum(_ISGetLastError()));
		return;
	}

	// get an RGB buffer from our HBITMAP, use the palette to render the bitmap
	CDC *pDC = GetDC();
	HGLOBAL hImg = _ISHBITMAPToRGB(hTmpBmp, 
											  &m_width, 
											  &m_height,
											  pDC->m_hDC,
											  (HPALETTE)m_pal.GetSafeHandle());

	ReleaseDC(pDC);
	// clean up - me have the RGB buffer, we don't need the HBITMAP anymore
	::DeleteObject(hTmpBmp);

	if (hImg!=NULL) 
	{

		BYTE *pImg = (BYTE *)hImg;

		// copy it to our buffer
		DWORD imgByteSize = (m_width * m_height * 3);
		
		// alloc our buffer
		try 
		{
			m_rgbBuf = (BYTE *) new BYTE[imgByteSize];
		} 
		catch (CMemoryException *e) 
		{
			e->ReportError();
			e->Delete();
			CleanUp();
		}

		// copy
		memcpy(m_rgbBuf, pImg, imgByteSize);

		InvalidateBefore();
		InvalidateAfter();

		GlobalFree(hImg);
	} 
	else 
	{
		AfxMessageBox(StringFromErrorNum(_ISGetLastError()));
		return;
	}
}

void CISDemoDlg::CleanUp()
{
	if (m_rgbBuf!=NULL) 
	{
		delete [] m_rgbBuf;
		m_rgbBuf=NULL;
		m_width=m_height=0;
	}
}

CString CISDemoDlg::StringFromErrorNum(int err)
{
	CString out = "";
	switch (err) 
	{
		default 			:			out.Format("Error #%d", err);
			break;
		case IS_ERR_OK				:		out="No error"; 
			break;
		case IS_ERR_CALLBACKCANCEL :		out="Operation cancelled by callback";
			break;
		case IS_ERR_PNGCREATE	:		out="Internal PNG creation error - possibly bad params";
			break;	
		case IS_ERR_INTERNAL		:		out="Internal _ISource error";
			break;
		case IS_ERR_FONT			:		out="Font creation error";
			break;
		case IS_ERR_MEM			:		out="Error : out of memory";
			break;
		case IS_ERR_FILEOPEN		:		out="Error on file open";
			break;
		case IS_ERR_FILEREAD		:		out="Error on file read";
			break;
		case IS_ERR_FILEWRITE	:		out="Error on file write";
			break;
		case IS_ERR_BADPARAM		:		out="Bad user param";
			break;
		case IS_ERR_INVALIDBMP	:		out="Bad BMP file";
			break;
		case IS_ERR_BMPRLE		:		out="We don't do RLE BMP files";
			break;
		case IS_ERR_INVALIDTIFF	:		out="Bad TIF file";
			break;
		case IS_ERR_INVALIDJPG	:		out="Bad jpg file";
			break;
		case IS_ERR_TRIALVERSION	:		out = "DLL unlocked to Trial level functionality only";
			break;
		case IS_ERR_DC				:		out = "Device error";
			break;
		case IS_ERR_DIB			:		out = "GetDIBits error";
			break;
		case IS_ERR_NORESOURCE	:		out = "Resource Not Found";
			break;
	}

	return out;
}

////////////////////////////////////////////////////////////////////////
//	this is where we apply the mod's

BYTE * CISDemoDlg::RenderImage()
{
	CWaitCursor bob;

	// copy it to our buffer
	DWORD imgByteSize = (m_width * m_height * 3);

	// turn this off. we don't need to see all of the updates
	_ISSetCallback(NULL, 0);


	BYTE * outBuf;
	// alloc our buffer
	try 
	{
		outBuf = (BYTE *) new BYTE[imgByteSize];
	} 
	catch (CMemoryException *e) 
	{
		e->ReportError();
		e->Delete();
		CleanUp();
		return NULL;
	}
  
	// copy
	memcpy(outBuf, m_rgbBuf, imgByteSize);

	// grayscale
	if (m_bGrayscale) 
	{
		if (!_ISRGBToGrayScale24(outBuf, m_width, m_height)) 
		{
			return outBuf;
		}
	}

	// flip
	if (m_bFlipV) 
	{
		if (!_ISVertFlipBuf(outBuf, m_width * 3, m_height)) 
		{
			return outBuf;
		}
	}

	// RGB / BGR
	if (m_bRGBBGR) 
	{
		if (!_ISRGBToBGR(outBuf, m_width, m_height)) 
		{
			return outBuf;
		}
	}

	// horiz flip
	if (m_bFlipH) 
	{
		if (!_ISFlipHorizontalImage(outBuf, m_width, m_height, 3)) 
		{
			return outBuf;
		}
	}

	// LUT
	if (m_bLUT) 
	{
		m_LUTChannelMask = (m_bLUTBlue ? CHBLUE : 0) | (m_bLUTGreen ? CHGREEN : 0) | (m_bLUTRed ? CHRED : 0);
		if (!_ISApplyLUTToRGB(outBuf, m_width, m_height, m_LUTChannelMask, 
			(m_iLUTSel==0 ? m_StepLUT: m_InvLUT))) 
		{
			return outBuf;
		}
	}

	// histogram EQ
	if (m_bHist) 
	{
		
		m_EQChannelMask = (m_bHistRed ? CHRED : 0) | (m_bHistGreen ? CHGREEN : 0) | (m_bHistBlue ? CHBLUE : 0);
		if (!_ISHistogramEqualizeRGB(outBuf, m_width, m_height, m_uHistLow, m_uHistHigh, m_EQChannelMask)) 
		{
			return outBuf;
		}
	}

	// quantize
	if (m_bQuantize) 
	{
		// do this into a temp 8-bit buffer,
		// then convert that to RGB
		BYTE *tmp;
		try 
		{
			tmp = (BYTE *) new BYTE[imgByteSize];
		} 
		catch (CMemoryException *e) 
		{
			e->ReportError();
			e->Delete();
			return outBuf;
		}

		// quantize it

		RGBQUAD pal[256];
		if (!_ISQuantizeRGBTo8Bit(outBuf,
											m_width,
											m_height,
											tmp,
											m_uQuantColors,
											pal,
											0)) 
		{
			return outBuf;
		} 

		// we really want a 24-bit image for display, so create a 24-bit image,
		// using the palette and the 8-bit image

		if (!_IS8BitToRGB(tmp,
								outBuf,
								m_width,
								m_height,
								m_uQuantColors,
								pal)) 
		{
			return outBuf;
		}

		delete [] tmp;
	}

	// despeckle
	if (m_bDespeckle) 
	{
		if (!_ISDespeckleRGB(outBuf, m_width, m_height))
		{
			return outBuf;
		}
	}


	// quick rotate
	if (m_iRotateSel!=0) 
	{

		_ISQuickRotateImage(outBuf, m_width, m_height, m_iRotateSel - 1, 3);
		// rotate 90 or 270, swap width and height
		if ((m_iRotateSel==1) || (m_iRotateSel==3)) 
		{
			UINT32 t = m_width;
			m_width = m_height;
			m_height = t;
		}
	}

	// median cut
	if (m_bMedianCut) 
	{
		// have to do this to a temp buffer
		BYTE *tmp;
		try 
		{
			tmp = (BYTE *) new BYTE[imgByteSize];
		} 
		catch (CMemoryException *e) 
		{
			e->ReportError();
			e->Delete();
			return outBuf;
		}

		if (!_ISMedianCutRGB(outBuf, m_width, m_height, tmp)) 
		{
			return outBuf;
		}
		memcpy(outBuf, tmp, imgByteSize);
		delete [] tmp;
	}

	if (m_bAutoBright)
	{
		_ISAutoBrightnessRGB(outBuf, m_width, m_height, 5, 250, 0);
	}

	// sharpen
	if (m_bSharpen) 
	{
		// have to do this to a temp buffer
		BYTE *tmp;
		try 
		{
			tmp = (BYTE *) new BYTE[imgByteSize];
		} 
		catch (CMemoryException *e) 
		{
			e->ReportError();
			e->Delete();
			return outBuf;
		}

		if (!_ISSharpenRGB(outBuf, m_width, m_height, tmp, m_uSharpenLevel)) 
		{
			return outBuf;
		}
		memcpy(outBuf, tmp, imgByteSize);
		delete [] tmp;
	}


	// blur
	if (m_bBlur) 
	{
		// have to do this to a temp buffer
		BYTE *tmp;
		try 
		{
			tmp = (BYTE *) new BYTE[imgByteSize];
		} 
		catch (CMemoryException *e) 
		{
			e->ReportError();
			e->Delete();
			return outBuf;
		}

		if (!_ISBlurRGB(outBuf, m_width, m_height, tmp, m_uBlurLevel)) 
		{
			return outBuf;
		}
		memcpy(outBuf, tmp, imgByteSize);
		delete [] tmp;
	}

	// count the colors
	UINT32 cols = _ISCountRGBColors(outBuf, m_width, m_height, FALSE);
	CString t;
	t.Format("%u colors", cols);
	m_colorTextWnd.SetWindowText(t);

	if (m_iHistoSel==0) 
	{

		if (!_ISGetRGBBrightnessHistogram(outBuf,
												m_width,
												m_height,
												m_EQHisto)) 
		{
		}
	} 
	else 
	{

		switch (m_iHistoSel)
		{
		case 1:
			m_EQGraphMask = CHRED;
			break;
		case 2:
			m_EQGraphMask = CHGREEN;
			break;
		case 3:
			m_EQGraphMask = CHBLUE;
			break;
		}

		if (!_ISGetRGBChannelHistogram(outBuf,
											m_width,
											m_height,
											m_EQGraphMask,
											m_EQHisto)) 
		{
		}
	}

	return outBuf;
}
