
// Load a SYM file

// This file is donated by David Cattley.

#include <idc.idc>

#define	VERBOSE	1

static main(void)
{
	auto	symFileName, symFile;

	symFileName = GetInputFile();
	symFileName = substr(symFileName,0,strstr(symFileName,".")) + ".sym";

	if(VERBOSE)	Message("Opening symbol file %s\n", symFileName);

	symFile = fopen(symFileName, "rb");

	if (0 != symFile)
	{
		auto nextMapDef;

		//
		// Process all of the MAPDEF's in this file.
		//
		if(VERBOSE)	Message("%04x: ", ftell(symFile));
		if(VERBOSE)	Message("Processing %s\n", symFileName);

		nextMapDef = 0;

		do
		{
			nextMapDef = DoMapDef(symFile, nextMapDef);
		}
		while (0 != nextMapDef);
	}
}


static DoMapDef(File, Position)
{
	auto	ppNextMap;

	//
	// Process the specified MAPDEF structure.
	//
	fseek(File, Position, 0);

	if(VERBOSE)	Message("%04x: ", ftell(File));

	ppNextMap = readshort(File, 0);
	
	if (0 == ppNextMap)
	{
		//
		// This is the last one!  It is special.
		//
		auto release, version;
		
		release = fgetc(File);
		version = fgetc(File);

		if(VERBOSE)	Message("VERSION Next:%x Rel:%x Ver:%x\n",
				ppNextMap,
				release,
				version
				);
	}
	else
	{
		auto	bFlags, bReserved1, pSegEntry,
				cConsts, pConstDef, cSegs, ppSegDef,
				cbMaxSym, achModName;

		auto i, nextSegDef;

		bFlags = fgetc(File);
		bReserved1 = fgetc(File);
		pSegEntry = readshort(File, 0);
		cConsts = readshort(File, 0);
		pConstDef = readshort(File, 0);
		cSegs = readshort(File, 0);
		ppSegDef = readshort(File, 0);
		cbMaxSym = fgetc(File);
		achModName = ReadSymName(File);

		if(VERBOSE)	Message("MAPDEF Next:%x Flags:%x Entry: %x Con: %d@%x Seg: %d@%x Max: %d Mod: %s\n", 
				ppNextMap, 
				bFlags, 
				pSegEntry, 
				cConsts, pConstDef, 
				cSegs, ppSegDef, 
				cbMaxSym, 
				achModName
				);

		//
		// Process the SEGDEFs in this MAPDEF
		//

		nextSegDef = ppSegDef << 4;

		for (i=0; i<cSegs; i=i+1)
		{
			nextSegDef = DoSegDef(File, nextSegDef);
		}
	}

	//
	// Return the file position of the next MAPDEF
	//
	return (ppNextMap << 4);
}


static DoSegDef(File, Position)
{
	auto	ppNextSeg, cSymbols, pSymDef, 
			wSegNum, wReserved2, wReserved3, wReserved4,
			bFlags, bReserved1, ppLineDef, bReserved2,
			bReserved3, achSegName;

	auto i, symPtr, segBase;


	//
	// Process the specified SEGDEF structure.
	//
	fseek(File, Position, 0);

	if(VERBOSE)	Message("%04x: ", ftell(File));

	ppNextSeg = readshort(File, 0);
	cSymbols = readshort(File, 0);
	pSymDef = readshort(File, 0);
	wSegNum = readshort(File, 0);
	wReserved2 = readshort(File, 0);
	wReserved3 = readshort(File, 0);
	wReserved4 = readshort(File, 0);
	bFlags = fgetc(File);
	bReserved1 = fgetc(File);
	ppLineDef = readshort(File, 0);
	bReserved2 = fgetc(File);
	bReserved3 = fgetc(File);
	achSegName = ReadSymName(File);

	segBase = SegByBase(wSegNum);

	if(VERBOSE)	Message("SEGDEF Next:%x Sym: %d@%x Flags:%x Lines:%x Seg: %s [%04x %08x]\n", 
			ppNextSeg, 
			cSymbols, pSymDef, 
			bFlags, 
			ppLineDef, 
			achSegName, wSegNum, segBase
			);

	//
	// Process the symbols in this SEGDEF
	//

	for (i=0; i<cSymbols; i=i+1)
	{
		fseek(File, Position+pSymDef+(i*2), 0);
		symPtr = Position+readshort(File, 0);

		DoSymDef(File, symPtr, (bFlags & 1), wSegNum);
	}
	

	//
	//  Return the position of the next SEGDEF
	//
	return (ppNextSeg << 4);
}


static DoSymDef(File, Position, Size, Segment)
{
	auto dwSymVal, achSymName, ea;

	fseek(File, Position, 0);

	if(VERBOSE)	Message("%04x: ", ftell(File));

	if (0 == Size)
		dwSymVal = readshort(File, 0);
	else
		dwSymVal = readlong(File, 0);

	achSymName = ReadSymName(File);

	//
	// Calculate the EA of this symbols.
	//
	ea = SegByBase(Segment) + dwSymVal;

	if(VERBOSE)	Message("SYM%d: %04x:%08x [%08x] %s\n", 
			(16+Size*16), 
			Segment, dwSymVal, ea,
			achSymName);

	//
	// Now go name the location!
	//
	MakeName(ea, ""); MakeName(ea, achSymName);
}


static ReadSymName(symFile)
{
	auto i, nameLen, name;

	name = "";
	nameLen = fgetc(symFile);

	for (i=0; i<nameLen; i=i+1)
	{
		name = name + fgetc(symFile);
	}

	return(name);
}
