
/*
 * Copyright (C) 1994,95 David Stes.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published 
 * by the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Library General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "fab.h"

id substitutions;

STR   doSubs(STR p,int *lenref)
{
    STR q = NULL;
    int i,len = 0;
    assert(substitutions);
    
    for(i=0;i<[substitutions size];i++) {
	int keylen;
	STR key = [[[substitutions at:i] key] str];
	keylen = strlen(key);
	if (keylen > len && strncmp(p,key,keylen) == 0) {
	    len = keylen;q = [[[substitutions at:i] value] str];
	}
    }
    
    *lenref = len;return q;
}

@implementation Definition

- setUp:k as:v
{
    key = k;value = v;return self;
}

+ new:k as:v
{
    return [[super new] setUp:k as:v];
}

- value
{
    return value;
}

- key
{
    return key;
}

- substitute
{
    return [isa new:key as:[value substitute]];
}

@end
