/*
 * 68K/386 32-bit C compiler.
 *
 * copyright (c) 1997, David Lindauer
 * 
 * This compiler is intended for educational use.  It may not be used
 * for profit without the express written consent of the author.
 *
 * It may be freely redistributed, as long as this notice remains intact
 * and either the original sources or derived sources 
 * are distributed along with any executables derived from the originals.
 *
 * The author is not responsible for any damages that may arise from use
 * of this software, either idirect or consequential.
 *
 * V2.05 June 2002
 * David Lindauer, camille@bluegrass.net
 *
 * Credits to Mathew Brandt for original K&R C compiler
 *
 */
/*
 * 22-Aug-1999 (SJS) Modified for ColdFire movem instruction restrictions.
 * 07-May-2001 (SJS) Modified alloc/free of data/address registers.
 */
#include        <stdio.h>
#include				<string.h>
#include        "lists.h"
#include        "expr.h"
#include        "c.h"
#include        "gen68.h"
#include 				"diag.h"

/* pc-relative expressions not optimized */
extern int linkreg,basereg;
extern AMODE    push[], pop[],mvma7[],mvma7i[];
extern OCODE    *peep_tail;
extern SYM *currentfunc;
extern int prm_stackcheck,prm_phiform,prm_linkreg,prm_rel, prm_smalldata;
extern int prm_coldfire ;
extern int floatregs,dataregs,addrregs;
extern long framedepth,stackdepth;
extern int cf_maxfloat, cf_maxaddress,cf_maxdata;
extern int cf_freedata,cf_freeaddress;
extern CSE       *olist;         /* list of optimizable expressions */
extern int prm_smartframes ;
long lc_maxauto;
int save_mask, fsave_mask;
int rmaskcnt ;
void reserveregs(int *datareg, int *addreg, int *floatreg)
/*
 * Reserve regs goes through and reserves a register for variables with
 * the REGISTER keyword.  Note that it currently does register allocation
 * backwards...
 */
{
	CSE *csp = olist;

	while (csp) {
		switch (csp->exp->nodetype) {
								case en_floatref:
								case en_doubleref:
								case en_longdoubleref:
                case en_b_ref:
                case en_bool_ref:
                case en_w_ref:
                case en_l_ref:
                case en_ub_ref:
                case en_uw_ref:
								case en_ul_ref:
										if (csp->exp->v.p[0]->nodetype != en_autoreg)		
											break;
											if (csp->size > 4) {
												if (*floatreg <cf_maxfloat && floatregs)
													csp->reg = (*floatreg)++;
											}
			                else if( (*datareg < cf_maxdata) && (csp->duses <= csp->uses/4) && dataregs)
                        csp->reg = (*datareg)++ ;
            			    else if(!(csp->size == 1 || csp->size == -1) && (*addreg < cf_maxaddress) &&addrregs)
                        csp->reg = (*addreg)++ ;
											if (csp->reg != -1) {
												((SYM *)csp->exp->v.p[0]->v.p[0])->inreg = TRUE;
                                    ((SYM *)csp->exp->v.p[0]->v.p[0])->value.i = -csp->reg-csp->size * 256;
											}
											break;
		}
		csp = csp->next;
	}
}	

void allocate(int datareg, int addreg, int floatreg, SNODE *block )
/*
 *      allocate will allocate registers for the expressions that have
 *      a high enough desirability.
 */
{       CSE      *csp;
        ENODE    *exptr, *mvn1, *mvn2;
        unsigned      mask, i,fmask,size;
        AMODE    *ap, *ap2, *ap3;
				framedepth = 4+lc_maxauto;
				rmaskcnt = 0 ;
        mask = 0;
				fmask = 0;
				for (i=cf_freedata; i < datareg; i++) {
						framedepth+=4;
						mask = mask | (1 << i);
				}
				for (i=cf_freeaddress+16; i < addreg; i++) {
						framedepth+=4;
            mask = mask | (1 << (i-8));
				}
        while( bsort(&olist) );         /* sort the expression list */
        csp = olist;
        while( csp != 0 ) {
						if (csp->reg == -1 && !(csp->exp->cflags & DF_VOL) && !csp->voidf) {
                if( desire(csp) < 3 )
                        csp->reg = -1;
								else {
									if (csp->size > 4) {
										if (floatreg <cf_maxfloat && floatregs)
											csp->reg = floatreg++;
									}
			            else if( (datareg < cf_maxdata) && (csp->duses <= csp->uses/4) && dataregs)
                    csp->reg = datareg++ ;
      	      		else if( !(csp->size == 1 || csp->size == -1) && (addreg < cf_maxaddress) &&addrregs)
                   csp->reg = addreg++;
								}
						}
            if( csp->reg != -1 )
				{
						if (lvalue(csp->exp) && !((SYM *)csp->exp->v.p[0]->v.p[0])->funcparm) {
							((SYM *)csp->exp->v.p[0]->v.p[0])->inreg = TRUE;
                     ((SYM *)csp->exp->v.p[0]->v.p[0])->value.i = -csp->reg-csp->size*256;
						}
						if (csp->reg < 16) {
							framedepth+=4;
              mask = mask | (1 << csp->reg);
							rmaskcnt ++ ;
						}
						else if (csp->reg < 32) {
							framedepth+=4;
              mask = mask | (1 << (csp->reg-8));
							rmaskcnt++ ;
						}
						else {
							framedepth+=12;
              fmask = fmask | (1 << (csp->reg-32));
						}
				}
                csp = csp->next;
                }
				allocstack();								/* Allocate stack space for the local vars */
				if (currentfunc->tp->lst.head !=0 && currentfunc->tp->lst.head != (SYM *)-1) {
					if (prm_phiform || currentfunc->intflag) {
						mask |= (1 << (linkreg +8));
						framedepth+=4;
					}
					if (currentfunc->intflag) {
						mask |= 0xffff;
						framedepth = lc_maxauto;
					}
				}
            if (prm_linkreg && !currentfunc->intflag && (currentfunc->tp->lst.head && currentfunc->tp->lst.head != (SYM *)-1 || lc_maxauto) || !prm_smartframes) {
					gen_codes(op_link,0,makeareg(linkreg),make_immed(-lc_maxauto));
				}				
			  if( mask != 0 )  {
					if (prm_coldfire) {
						if (rmaskcnt > 1)
						{
							mvn2 = xalloc(sizeof(struct enode));
							mvn2->nodetype = en_icon;
							mvn2->v.i = (rmaskcnt<<2);
							mvn1 = xalloc(sizeof(struct enode));
							mvn1->nodetype = en_uminus;
							mvn1->v.p[0] = mvn2;
							ap3 = xalloc(sizeof(struct amode));
							ap3->mode = am_indx;
                     ap3->preg = ap3->preg = 7;
							ap3->offset = mvn1;
                     gen_codes(op_lea,0,ap3,mvma7i);
                     gen_codes(op_movem,4,make_mask(mask,0),mvma7);
							freeop(ap3);
						}
						else
                     gen_codes(op_move,4,make_mask(mask,0),push);  
					} else
                  gen_codes(op_movem,4,make_mask(mask,0),push);
          }
        save_mask = mask;
				if (fmask!=0)
              gen_codes(op_fmovem,10,make_mask(fmask,1),push);
				fsave_mask = fmask;
				if ((prm_phiform || currentfunc->intflag) && currentfunc->tp->lst.head && currentfunc->tp->lst.head != (SYM *) -1) {
					gen_codes(op_move,4,makeareg(0), makeareg(linkreg));
				}
				if ((!prm_linkreg || currentfunc->intflag) && lc_maxauto) {
					AMODE *ap = xalloc(sizeof(AMODE)); 
					ap->mode = am_indx;
					ap->offset = makenode(en_icon,(char *)-lc_maxauto,0);
					ap->preg = 7;
          gen_codes(op_lea,0,ap,makeareg(7));
				}
				
				if (prm_stackcheck) {
					AMODE *ap1;
					ap = set_symbol("_stackerror",1);
					ap1 = set_symbol("_stackbottom",0);
					if (prm_rel) {
						ap1->mode = am_indx;
						ap1->preg = basereg;
					}
					else {
						ap1->mode = am_adirect;
						if (prm_smalldata)
							ap1->preg = 2;
						else
							ap1->preg = 4;
					}
					gen_codes(op_cmp,4,ap1,makeareg(7));
					gen_codes(op_bhi,0,ap,0);
				}
				AddProfilerData();
}
void loadregs(void)
/*
 * Initailze allocated regs
 *
 */
{       CSE      *csp;
        ENODE    *exptr;
        unsigned      mask, i,fmask,size;
        AMODE    *ap, *ap2;
        csp = olist;
        while( csp != 0 ) {
								int sz;
                if( csp->reg != -1 )
                        {               /* see if preload needed */
                        exptr = csp->exp;
                        if( !lvalue(exptr) || ((SYM *)exptr->v.p[0]->v.p[0])->funcparm )
                                {
																exptr = csp->exp;
                                initstack();
																sz = csp->size;
                                ap = gen_expr(exptr,FALSE,TRUE,sz);
							                  if (sz == 0 && ap->mode == am_immed)
																	sz = 4;
                                if( csp->reg < 16 ) {
							                  	if (sz == 0 && ap->mode == am_immed)
																		sz = 4;
																	/* might get both a move and an and */
																	if (ap->mode == am_dreg) {
																		peep_tail->oper2->preg = csp->reg;
																		if (peep_tail->opcode != op_move)  {
																			OCODE *peep_pos = peep_tail->back;
																			peep_pos->oper2->preg = csp->reg;
																		}
																	}
																	else {
                                        ap2 = makedreg(csp->reg);
                                				gen_codes(op_move,sz,ap,ap2);
																				do_extend(ap2,4,F_DREG);
																	}
																}
                                else
																	if (csp->reg < 32) {
							                  		if (sz == 0 && ap->mode == am_immed)
																			sz = 4;
																		if (ap->mode == am_areg)
																			peep_tail->oper2->preg = csp->reg - 16;
																		else {
  	                                      ap2 = makeareg(csp->reg - 16);
    	                            				gen_codes(op_move,4,ap,ap2);
																		}
																	}
																	else {
									                  if (sz == 0 && ap->mode == am_immed)
																			sz = 8;
																		if (ap->mode == am_freg)
																			peep_tail->oper2->preg = csp->reg - 32;
																		else {
  	                                      ap2 = makefreg(csp->reg - 32);
																					size = 8;
																					if (exptr->nodetype == en_floatref)
																						size = 6;
    	                            				gen_codes(op_fmove,size,ap,ap2);
																		}
																	}
                                freeop(ap);
																if (lvalue(exptr) && ((SYM *)exptr->v.p[0]->v.p[0])->funcparm) {
																	((SYM *)exptr->v.p[0]->v.p[0])->inreg = TRUE;
                                                   ((SYM *)exptr->v.p[0]->v.p[0])->value.i = -csp->reg-csp->size * 256;
																}
                                }
                        }
                csp = csp->next;
                }
}
int voidexpr(ENODE *node)
{       CSE      *csp;
        if( node == 0 )
                return 0;
        switch( node->nodetype ) {
                case en_rcon: case en_lrcon: case en_fcon:
											return 1;
                case en_icon:
								case en_lcon:
								case en_iucon:
								case en_lucon:
                        case en_llcon:
                        case en_llucon:
								case en_ccon:
                case en_nacon:
                case en_napccon:
								case en_absacon:
                case en_autocon:
								case en_autoreg:
												return 0;
								case en_floatref:
								case en_doubleref:
								case en_longdoubleref:
												return 1;
                case en_bool_ref:
                case en_ub_ref:
                case en_uw_ref:
                case en_b_ref:
                case en_w_ref:
                case en_l_ref:
                case en_ul_ref:
                case en_ll_ref:
                case en_ull_ref:
												return 0;
                case en_uminus: case en_bits: case en_asuminus: case en_ascompl:
                case en_not:    case en_compl:
                case en_ainc:   case en_adec:
                        return voidexpr(node->v.p[0]);
                case en_fcall:
								case en_pfcall: case en_pfcallb:
								case en_sfcall: case en_sfcallb: case en_scallblock:
                case en_fcallb:
								case en_callblock:
								case en_pcallblock: 
#ifdef CPLUSPLUS
                    {
                      SYM *sp;
                      ENODE *node2 = node->v.p[1]->v.p[0];
                      if (node2->nodetype == en_nacon || node2->nodetype == en_napccon) {
                        sp=node2->v.sp;
   
                        if (sp && (sp->value.classdata.cppflags & PF_INLINE))
                          voidfloat(sp->value.classdata.inlinefunc->stmt);
                      }
                    }
#endif
                case en_cb: case en_cub: case en_cbool:
								case en_cw: case en_cuw:
                        case en_cl: case en_cul: case en_cll: case en_cull:
								case en_cf: case en_cd: case en_cp: case en_cld:
								case en_thiscall:
                case en_add:    case en_sub:  case en_addstruc:
                case en_umul:    case en_udiv: case en_umod:
                case en_mul:    case en_div:
                case en_mod:    case en_lsh:
								case en_asalsh: case en_asarsh: case en_alsh: case en_arsh: case en_arshd: case en_asarshd:
                case en_rsh:    case en_and:
                case en_or:     case en_xor:
                case en_land:   case en_lor:
                case en_eq:     case en_ne:
                case en_lt:     case en_le:
								case en_ugt:	case en_uge: case en_ult: case en_ule:
                case en_gt:     case en_ge:
                case en_cond:   case en_void:
                        case en_pmul: case en_cl_reg:
                case en_moveblock: case en_stackblock: 
								case en_intcall: case en_pdiv:
                        return voidexpr(node->v.p[0]) || voidexpr(node->v.p[1]);
								case en_trapcall:
												return voidexpr(node->v.p[0]);
								case en_repcons:
												return voidexpr(node->v.p[1]);
                case en_asadd:  case en_assub:
                case en_asmul:  case en_asdiv:
                case en_asor:   case en_asand:   case en_asxor:
                case en_asmod:  case en_aslsh:
								case en_asumod: case en_asudiv: case en_asumul:
                case en_asrsh: case en_assign: case en_refassign:
												if (voidexpr(node->v.p[1])) {
													csp = searchnode(node->v.p[0]);
													if (csp)
														csp->voidf = 1;
												}
												return voidexpr(node->v.p[0]);
								default:
											return 0;
                }
	
}
void voidfloat(SNODE *block)
/*
 * Scan through a block and void all CSEs which do asadd, asmul, asmodiv
 * of float to int
 */
{       while( block != 0 ) {
                switch( block->stype ) {
                        case st_return:
                        case st_expr:
                                voidexpr(block->exp);
                                break;
                        case st_while:
                        case st_do:
                                voidexpr(block->exp);
                                voidfloat(block->s1);
                                break;
                        case st_for:
                                voidexpr(block->label);
                                voidexpr(block->exp);
                                voidfloat(block->s1);
                                voidexpr(block->s2);
                                break;
                        case st_if:
                                voidexpr(block->exp);
                                voidfloat(block->s1);
                                voidfloat(block->s2);
                                break;
                        case st_switch:
                                voidexpr(block->exp);
                                voidfloat(block->s1);
                                break;
                        case st_case:
                                voidfloat(block->s1);
                                break;
												case st_block:
																voidfloat(block->exp);
																break;
                        }
                block = block->next;
                }
}
void asm_scan(OCODE *cd)
{
}
void asm_repcse(OCODE *cd)
{
}