//
// MODTOOL
//
// Copyright (c) !998 David Lindauer (LADSOFT)
//
// see license.txt for licensing info
//
// ==============================================================
//
// PROPERTY.CPP
//
// property sheet handling
//
// each page in a property sheet is a rather boring dialog box
// which hooks WM_NOTIFY messages for the activity.
//
// I'm not commenting the dialog box internals as they are all straightforward
//
#define STRICT
#include <windows.h>
#include <commdlg.h>
#include <commctrl.h>
#include <prsht.h>
#include <stdio.h>
#include "winconst.h"
#include "header.h"

extern char szHelpPath[] ;
extern int HelpMode ;
extern HINSTANCE hInstance ;
extern COLORREF keywordColor ;
extern COLORREF numberColor  ;
extern COLORREF commentColor ;
extern COLORREF stringColor ;
extern COLORREF escapeColor ;
extern COLORREF backgroundColor ;
extern COLORREF textColor ;
extern int tabs, editFlags ;
extern char szInstallPath[] ;

int custColors[16] ;

LRESULT  CALLBACK _export colorProc( HWND hwnd, UINT iMessage, WPARAM wParam,
																		LPARAM lParam)
{
	HDC dc ;
	PAINTSTRUCT paint ;
	RECT r ;
	LOGBRUSH l ;
	HBRUSH b ;
	CHOOSECOLOR c ;
	switch (iMessage) {
		case WM_SETCOLOR:
			SetWindowLong(hwnd,0,lParam) ;
			InvalidateRect(hwnd,0,0) ;
			break ;
		case WM_PAINT:	
			dc = BeginPaint(hwnd,&paint) ;
			GetClientRect(hwnd,&r) ;
			l.lbStyle = BS_SOLID ;
			l.lbColor = GetWindowLong(hwnd,0) ;
			b = CreateBrushIndirect(&l) ;
			FillRect(dc,&r,b) ;
			DeleteObject(b) ;
			EndPaint(hwnd,&paint) ;
			break ;
		case WM_LBUTTONDOWN:
			memset(&c,0,sizeof(c)) ;
			c.lStructSize = sizeof(CHOOSECOLOR) ;
			c.hwndOwner = hwnd ;
			c.rgbResult = GetWindowLong(hwnd,0) ;
			c.lpCustColors = custColors ;
			c.Flags = CC_RGBINIT ;
			if (ChooseColor(&c)) {
				SetWindowLong(hwnd,0,c.rgbResult) ;
				InvalidateRect(hwnd,0,0) ;
			} else
				CommDlgExtendedError() ;
		  return 0 ;
		case WM_RETRIEVECOLOR:
			return GetWindowLong(hwnd,0) ;
		case WM_CREATE:
			SetWindowLong(hwnd,0,0) ;
			InvalidateRect(hwnd,0,0) ;
			break ;
		case WM_DESTROY:
			break ;
	}
	DefWindowProc(hwnd,iMessage,wParam,lParam) ;
}
void RegisterColorWindow(void)
{
		WNDCLASS wc ;
      wc.style = 0;
		wc.lpfnWndProc = &colorProc ;
		wc.cbClsExtra = 0;
		wc.cbWndExtra = sizeof(void *) ;
		wc.hInstance = hInstance ;
		wc.hIcon = LoadIcon(0,IDI_APPLICATION) ;
		wc.hCursor = LoadCursor(0,IDC_ARROW) ;
		wc.hbrBackground = 0 ;
		wc.lpszMenuName = 0 ;
		wc.lpszClassName = "xccColorClass" ;
		RegisterClass(&wc) ;
}

// ==============================================================
//
// property sheet constant names
//
#define PROPERTY_SHEET_COUNT 2
#define EDITPROP 0
#define INSTALLPROP 1

static PROPSHEETPAGE pages[PROPERTY_SHEET_COUNT]; // the page structures
static PROPSHEETHEADER header;	// the header structure

// ==============================================================
//
// routine to set the result from the killactive notify message

static void SetResult(HWND hwnd,int value)
{
	SetWindowLong(hwnd,DWL_MSGRESULT,value);
}
void SetColor(HWND hwnd, int control, int color)
{
	SendMessage(GetDlgItem(hwnd,control),WM_SETCOLOR,0,color) ;
}
int GetColor(HWND hwnd, int control)
{
	SendMessage(GetDlgItem(hwnd,control),WM_RETRIEVECOLOR,0,0) ;
}
// ==============================================================
//
static int FAR PASCAL EditProc (HWND hwnd,UINT wmsg,WPARAM wparam,LPARAM lparam)

{
	NMHDR * nmhead;
	switch (wmsg) {
		case WM_INITDIALOG:
			return TRUE;
		case WM_NOTIFY:
			nmhead = (NMHDR *)lparam;
			switch (nmhead->code) {
				case PSN_SETACTIVE:
					/* page startup */
					NewFocus(hwnd,IDC_TABSTOPS);
					SetEditFieldValue(hwnd,IDC_TABSTOPS,tabs) ;
					SetColor(hwnd,IDC_KEYWORDCOLOR,keywordColor) ;
					SetColor(hwnd,IDC_COMMENTCOLOR,commentColor) ;
					SetColor(hwnd,IDC_NUMBERCOLOR,numberColor) ;
					SetColor(hwnd,IDC_STRINGCOLOR,stringColor) ;
					SetColor(hwnd,IDC_ESCAPECOLOR,escapeColor) ;
					SetColor(hwnd,IDC_BACKGROUNDCOLOR,backgroundColor) ;
					SetColor(hwnd,IDC_TEXTCOLOR,textColor) ;
					SetCBField(hwnd,IDC_BACKUPFILE,!!(editFlags & BACKUP_FILES)) ;
					SetCBField(hwnd,IDC_BACKUPPROJ,!!(editFlags & BACKUP_PROJECTS)) ;
					break;
				case PSN_KILLACTIVE:
					/* verify ok always */
					SetResult(hwnd,FALSE);
					break;
				case PSN_APPLY:
					/* Page application */
					tabs = GetEditFieldValue(hwnd,IDC_TABSTOPS) ;
					keywordColor = GetColor(hwnd,IDC_KEYWORDCOLOR) ;
					commentColor = GetColor(hwnd,IDC_COMMENTCOLOR) ;
					numberColor = GetColor(hwnd,IDC_NUMBERCOLOR) ;
					stringColor = GetColor(hwnd,IDC_STRINGCOLOR) ;
					escapeColor = GetColor(hwnd,IDC_ESCAPECOLOR) ;
					backgroundColor = GetColor(hwnd, IDC_BACKGROUNDCOLOR) ;
					textColor = GetColor(hwnd, IDC_TEXTCOLOR) ;
					editFlags &= !(BACKUP_FILES|BACKUP_PROJECTS);
					editFlags |= GetCBField(hwnd,IDC_BACKUPFILE) ? BACKUP_FILES : 0 ;
					editFlags |= GetCBField(hwnd,IDC_BACKUPPROJ) ? BACKUP_PROJECTS : 0 ;
					ApplyEditSettings() ;
					break;
				case PSN_HELP:
					break;
			}
			break;
	}
	return FALSE;
}
static int FAR PASCAL InstallProc (HWND hwnd,UINT wmsg,WPARAM wparam,LPARAM lparam)

{
	NMHDR * nmhead;
	int len ;
	switch (wmsg) {
		case WM_INITDIALOG:
			return TRUE;
		case WM_NOTIFY:
			nmhead = (NMHDR *)lparam;
			switch (nmhead->code) {
				case PSN_SETACTIVE:
					/* page startup */
					NewFocus(hwnd,IDC_INSTALLPATH);
					SetEditField(hwnd,IDC_INSTALLPATH,szInstallPath) ;
               SetEditField(hwnd,IDC_HELPPATH,szHelpPath) ;
               CheckRadioButton(hwnd,IDC_HELPMSDN,IDC_HELPSPEC,
                     HelpMode == HELP_MSDN ? IDC_HELPMSDN : HelpMode == HELP_SDK ? IDC_HELPSDK : IDC_HELPSPEC) ;
					break;
				case PSN_KILLACTIVE:
					/* verify ok always */
					SetResult(hwnd,FALSE);
					break;
				case PSN_APPLY:
					/* Page application */
					GetEditField(hwnd,IDC_INSTALLPATH,szInstallPath) ;
					len = strlen(szInstallPath) ;
					if (len && szInstallPath[len-1] == '\\')
						szInstallPath[len-1] = 0 ;
               StringToProfile("InstallPath",szInstallPath) ;
               if (GetCBField(hwnd, IDC_HELPMSDN))
                  HelpMode = HELP_MSDN ;
               else if (GetCBField(hwnd, IDC_HELPSDK))
                  HelpMode = HELP_SDK ;
               else
                  HelpMode = HELP_SPECIFIED ;
               GetEditField(hwnd,IDC_HELPPATH,szHelpPath) ;
               RundownHelp() ;
               InitHelp() ;
					break;
				case PSN_HELP:
					break;
			}
			break;
	}
	return FALSE;
}
// ==============================================================
//
// display the property sheet and return to caller
//
void DisplayProperties(HINSTANCE hInst, HWND hwnd)
{
	// struct for server page
	pages[EDITPROP].dwSize = sizeof(PROPSHEETPAGE);
	pages[EDITPROP].dwFlags = 0 /*PSP_HASHELP*/;
	pages[EDITPROP].hInstance = hInst;
	pages[EDITPROP].u.pszTemplate = "EDITPROPDLG";
	pages[EDITPROP].pfnDlgProc = EditProc;
	pages[EDITPROP].pszTitle = "Edit" ;

	pages[INSTALLPROP].dwSize = sizeof(PROPSHEETPAGE);
	pages[INSTALLPROP].dwFlags = 0 /*PSP_HASHELP*/;
	pages[INSTALLPROP].hInstance = hInst;
	pages[INSTALLPROP].u.pszTemplate = "INSTALLPROPDLG";
	pages[INSTALLPROP].pfnDlgProc = InstallProc;
	pages[INSTALLPROP].pszTitle = "Install" ;

	// struct for property sheet header
	header.dwSize = sizeof(PROPSHEETHEADER);
	header.dwFlags = PSH_PROPSHEETPAGE | PSH_PROPTITLE | PSH_NOAPPLYNOW /* | PSH_HASHELP*/;
	header.hwndParent = hwnd;
	header.pszCaption = "General";
	header.nPages = PROPERTY_SHEET_COUNT;
	header.u2.nStartPage = 0;
	header.u3.ppsp = &pages[0];

	// make the property sheet and exit
	PropertySheet(&header);
}