"""
     Pattern  - Python tools (c) 2000 by D.G. Sureau

     This function compares two filenames
     - the first one holding some wildcard characters -
     and return TRUE if the two files match.

"""


import os
import string

FALSE = 0
TRUE  = 1

#--------------------- Comparing a pattern and a filename

# Comparing two strings, first with wildcards

def matchingstr(str1, str2, casesensitive):

  if str1 == '*': return TRUE
  if len(str1) <> len(str2): return FALSE

  # now comparing each char, but the ? wildcard
  i = 0
  for c in str1:
   if c == '?': continue
   if casesensitive == TRUE:
      if c <> str2[i]: return FALSE
   else:
      if(string.upper(c) <> string.upper(str2[i])): return FALSE
   i = i + 1

  return TRUE


# Comparing two filenames with wildcards

def matching(pattern, filename, casesensitive):

 #Extracting node and last extension

 namep, extp = os.path.splitext(pattern)
 namef, extf = os.path.splitext(filename)

 if not matchingstr(namep, namef, casesensitive): return FALSE
 if not matchingstr(extp, extf, casesensitive):   return FALSE
 return TRUE


