use perlchartdir;


sub main
{
	#The data for the area chart
	my $data0 = [25, 18, 9, 4, 5, 8, 14, 20, 40, 92, 75, 88, 75, 
		58, 90, 95, 83, 75, 70, 66, 46, 38, 28, 15, 22];
	my $data1 = [36, 28, 25, 33, 38, 42, 44, 36, 50, 68, 60, 50, 55, 
		67, 58, 52, 57, 46, 33, 38, 25, 33, 42, 37, 30];
	my $data2 = [88, 70, 43, 55, 35, 28, 17, 25, 30, 33, 36, 45, 28, 
		45, 60, 47, 25, 30, 41, 49, 67, 82, 88, 95, 98];

	#The labels for the area chart
	my $labels = ["0", "", "", "3", "", "", "6", "", "", "9", "", "", 
		"12", "", "", "15", "", "", "18", "", "", "21", "", "", "24"];

	#First, create a XYChart of size 500 pixels x 320 pixels
	my $c = new XYChart(500, 320);

	#Set the plotarea rectangle to start at (100, 40) and of 
	#280 pixels in width and 240 in height
	$c->setPlotArea(100, 40, 280, 240);

	#Add a legend box at (400, 100)
	$c->addLegend(400, 100);

	#Add a title to the chart
	$c->addTitle("Daily Network Load");

	#Add a multiline title to the y axis. draw the title upright by setting the 
	#font angle 0 (the default is to draw the title sideways for y axis)
	$c->yAxis()->setTitle("Average\nThroughput\n(MBytes\nPer Hour)")
		->setFontAngle(0);
	
	#Set the labels on the x axis
	$c->xAxis()->setLabels($labels);

	#Add three area layers, each represent one data set
	$c->addAreaLayer($data0, 0x808080ff, "Server #1", 5);
	$c->addAreaLayer($data1, 0x80ff0000, "Server #2", 5);
	$c->addAreaLayer($data2, 0x8000ff00, "Server #3", 5);

	#output the chart as a PNG file
	$c->makeChart("deptharea.png");
}


main();
