package perlchartdir;
require 5.004;

sub autoImport
{
	my $ver = shift;
	eval sprintf('
		package %s;
		require DynaLoader;
		@ISA = qw(DynaLoader);
		bootstrap %s;
		sub perlchartdir::major_ver { return &major_ver; };
		sub perlchartdir::minor_ver { return &minor_ver; }
		sub perlchartdir::copyright { return &copyright; }
		sub perlchartdir::id { return &id; }
		sub perlchartdir::callMethod { return &callMethod; }
		', $ver, $ver);
}

if ($] >= 5.006) {
	autoImport("perlchartdir56");
}
elsif ($] >= 5.005) {
	autoImport("perlchartdir5005");
}
else {
	autoImport("perlchartdir5004");
}

sub checkarg
{
	my $params = shift;
	my $requiredNoOfParams = shift;
	if (!$requiredNoOfParams) { $requiredNoOfParams = 0; }
	my $actualNoOfParams = scalar(@$params);
	if ($actualNoOfParams > $requiredNoOfParams)
	{	die "Too many arguments; expecting $requiredNoOfParams but received $actualNoOfParams\n"; }
	my $noOfDefaultParams = scalar(@_);
	my $noOfMandatoryParams = $requiredNoOfParams - $noOfDefaultParams;
	if ($actualNoOfParams < $noOfMandatoryParams)
	{	die "Too few arguments; need at least $noOfMandatoryParams but received $actualNoOfParams\n"; }
	while ($actualNoOfParams < $requiredNoOfParams)
	{
		push(@$params, @_[$noOfDefaultParams + $actualNoOfParams - $requiredNoOfParams]);
		++$actualNoOfParams;
	}	
	return $params;
}

sub printerr
{
	my ($msg, $back) = @_;
	chop $msg;
	my @context = caller($back);
	die "$msg when calling $context[3] at $context[1] line $context[2]\n"; 
}

sub func
{
	my $methodName = shift;
	my $ret = eval { 
		my $params = checkarg(@_);
		callMethod($methodName, @$params); 
		};
	if ((!$ret) && ($@)) { printerr($@, 2); }
	return $ret;	
}

sub method
{
	my $methodName = shift;
	my $params = shift;
	my $self = shift(@$params);
	my $ret = eval { 
		my $params = checkarg($params, @_);
		callMethod($methodName, $self->{this}, @$params); 
		};
	if ((!$ret) && ($@)) { printerr($@, 2); }
	return $ret;	
}


#///////////////////////////////////////////////////////////////////////////////////
#//	bindings to libgraphics.h
#///////////////////////////////////////////////////////////////////////////////////
package perlchartdir;

$BottomLeft = 1;
$BottomCenter = 2;
$BottomRight = 3;
$Left = 4;
$Center = 5;
$Right = 6;
$TopLeft = 7;
$TopCenter = 8;
$TopRight = 9;
$Top = TopCenter;
$Bottom = BottomCenter;

package TTFText;

$NoAntiAlias = 0;
$AntiAlias = 1;
$AutoAntiAlias = 2;

sub new
{
	my ($class, $this, $parent) = @_;
	my $self = {};
	$self->{"this"} = $this;
	$self->{"parent"} = $parent;
	return bless($self, $class);
}
sub DESTROY
{
	my $self = shift;
	perlchartdir::callMethod("DrawArea.close", $self->{"this"}, $self->{"parent"}->{"this"})
}
sub getWidth
{
	return perlchartdir::method("TTFText.getWidth", \@_);
}
sub getHeight
{
	return perlchartdir::method("TTFText.getHeight", \@_);
}
sub getLineHeight
{
	return perlchartdir::method("TTFText.getLineHeight", \@_);
}
sub getLineDistance
{
	return perlchartdir::method("TTFText.getLineDistance", \@_);
}
sub draw
{
	return perlchartdir::method("TTFText.draw", \@_, 4);
}
	
package DrawArea;

$TryPalette = 0;
$ForcePalette = 1;
$NoPalette = 2;
$Quantize = 0;
$OrderedDither = 1;
$ErrorDiffusion = 2;

sub new
{
	my ($class, $this) = @_;
	my $self = {};
	if (not $this)
	{
		$self->{"this"} = perlchartdir::callMethod("DrawArea.create");
		$self->{"own_this"} = 1;
	}
	else
	{
		$self->{"this"} = $this;
		$self->{"own_this"} = 0;
	}
	return bless($self, $class);
}
sub DESTROY
{
	my $self = shift;
	if ($self->{"own_this"})
		{ perlchartdir::callMethod("DrawArea.destroy", $self->{"this"}); }
}
sub setSize
{
	perlchartdir::method("DrawArea.setSize", \@_, 3, 0xffffff);
}
sub getWidth
{
	return perlchartdir::method("DrawArea.getWidth", \@_);
}
sub getHeight
{
	return perlchartdir::method("DrawArea.getHeight", \@_);
}
sub setBgColor
{
	perlchartdir::method("DrawArea.setBgColor", \@_, 1);
}
sub pixel
{
	perlchartdir::method("DrawArea.pixel", \@_, 3);
}
sub getPixel
{
	return perlchartdir::method("DrawArea.getPixel", \@_, 2);
}
sub hline
{
	perlchartdir::method("DrawArea.hline", \@_, 4);
}
sub vline
{
	perlchartdir::method("DrawArea.vline", \@_, 4);
}
sub line
{
	perlchartdir::method("DrawArea.line", \@_, 6, 1);
}
sub arc
{
	perlchartdir::method("DrawArea.arc", \@_, 7);
}
sub rect
{
	perlchartdir::method("DrawArea.rect", \@_, 6);
}
sub polygon
{
	my $ret = eval {
		my ($self, $points, $edgeColor, $fillColor) = @{perlchartdir::checkarg(\@_, 4)};
		my @x = ();
		my @y = ();
		foreach $p (@$points)
		{
			push(@x, $$p[0]);
			push(@y, $$p[1]);
		}
		perlchartdir::callMethod("DrawArea.polygon", $self->{"this"}, \@x, \@y, scalar(@x),
			$edgeColor, $fillColor);
		};
	if ((!$ret) && ($@)) { perlchartdir::printerr($@, 1); }
}
sub surface
{
	perlchartdir::method("DrawArea.surface", \@_, 8);
}
sub sector
{
	perlchartdir::method("DrawArea.sector", \@_, 8);
}
sub cylinder
{
	perlchartdir::method("DrawArea.cylinder", \@_, 10);
}
sub circle
{
	perlchartdir::method("DrawArea.circle", \@_, 6);
}
sub fill
{
	if (scalar(@_) > 4) { fill2(@_); }
	else { perlchartdir::method("DrawArea.fill", \@_, 3); }
}
sub fill2
{
	perlchartdir::method("DrawArea.fill2", \@_, 4);
}
sub text
{
	perlchartdir::method("DrawArea.text", \@_, 6);
}
sub text2
{
	perlchartdir::method("DrawArea.text2", \@_, 11, $perlchartdir::TopLeft);
}
sub text3
{
	return new TTFText(perlchartdir::method("DrawArea.text3", \@_, 3));
}
sub text4
{
	return new TTFText(perlchartdir::method("DrawArea.text4", \@_, 7));
}
sub merge
{
	my $ret = eval {
		my ($self, $d, $x, $y, $align, $transparency) = @{perlchartdir::checkarg(\@_, 6)};
		perlchartdir::callMethod("DrawArea.merge", $self->{"this"}, $d->{"this"}, $x, $y, 
			$align, $transparency);
		};
	if ((!$ret) && ($@)) { perlchartdir::printerr($@, 1); }
}
sub tile
{
	my $ret = eval {
		my ($self, $d, $transparency) = @{perlchartdir::checkarg(\@_, 3)};
		perlchartdir::callMethod("DrawArea.tile", $self->{"this"}, $d->{"this"}, $transparency);
		};
	if ((!$ret) && ($@)) { perlchartdir::printerr($@, 1); }
}
sub loadGIF
{
	return perlchartdir::method("DrawArea.loadGIF", \@_, 1);
}
sub loadPNG
{
	return perlchartdir::method("DrawArea.loadPNG", \@_, 1);
}
sub loadJPG
{
	return perlchartdir::method("DrawArea.loadJPG", \@_, 1);
}
sub loadWMP
{
	return perlchartdir::method("DrawArea.loadWMP", \@_, 1);
}
sub load
{
	return perlchartdir::method("DrawArea.load", \@_, 1);
}
sub out
{
	return perlchartdir::method("DrawArea.out", \@_, 1);
}
sub outGIF
{
	return perlchartdir::method("DrawArea.outGIF", \@_, 1);
}
sub outPNG
{
	return perlchartdir::method("DrawArea.outPNG", \@_, 1);
}
sub outJPG
{
	return perlchartdir::method("DrawArea.outJPG", \@_, 2, 80);
}
sub outWMP
{
	return perlchartdir::method("DrawArea.outWMP", \@_, 1);
}
sub outGIF2
{
	return perlchartdir::method("DrawArea.outGIF2", \@_);
}
sub outPNG2
{
	return perlchartdir::method("DrawArea.outPNG2", \@_);
}
sub outJPG2
{
	return perlchartdir::method("DrawArea.outJPG2", \@_, 1, 80);
}
sub outWMP2
{
	return perlchartdir::method("DrawArea.outWMP2", \@_);
}
sub setPaletteMode
{
	perlchartdir::method("DrawArea.setPaletteMode", \@_, 1);
}
sub setDitherMethod
{
	perlchartdir::method("DrawArea.setDitherMethod", \@_, 1);
}
sub setTransparentColor
{
	perlchartdir::method("DrawArea.setTransparentColor", \@_, 1);
}
sub setAntiAliasText
{
	perlchartdir::method("DrawArea.setAntiAliasText", \@_, 1);
}
sub setInterlace
{
	perlchartdir::method("DrawArea.setInterlace", \@_, 1);
}
sub setColorTable
{
	my $ret = eval {
		my ($self, $colors, $offset) = @{perlchartdir::checkarg(\@_, 3)};
		perlchartdir::callMethod("DrawArea.setColorTable", $self->{"this"}, 
			$colors, scalar(@$colors), $offset);
		};
	if ((!$ret) && ($@)) { perlchartdir::printerr($@, 1); }
}
sub getARGBColor
{
	return perlchartdir::method("DrawArea.getARGBColor", \@_, 1);
}


#///////////////////////////////////////////////////////////////////////////////////
#//	bindings to drawobj.h
#///////////////////////////////////////////////////////////////////////////////////
package perlchartdir;

$Transparent = 0xff000000;
$Palette = 0xffff0000;
$BackgroundColor = 0xffff0000; 
$LineColor = 0xffff0001;
$TextColor = 0xffff0002;
$DataColor = 0xffff0008;

package TextStyle;

sub new
{
	my ($class, $this) = @_;
	my $self = {};
	$self->{"this"} = $this;
	return bless($self, $class);
}
sub setFontStyle
{
	perlchartdir::method("TextStyle.setFontStyle", \@_, 2, 0);
}
sub setFontSize
{
	perlchartdir::method("TextStyle.setFontSize", \@_, 2, 0);
}
sub setFontAngle
{
	perlchartdir::method("TextStyle.setFontAngle", \@_, 2, 0);
}
sub setFontColor
{
	perlchartdir::method("TextStyle.setFontColor", \@_, 1);
}
sub setBackground
{
	perlchartdir::method("TextStyle.setBackground", \@_, 2, $perlchartdir::Transparent);
}	
sub setMargin2
{
	perlchartdir::method("TextStyle.setMargin2", \@_, 4);
}
sub setMargin
{
	perlchartdir::method("TextStyle.setMargin", \@_, 1);
}


package Box;

sub new
{
	my ($class, $this) = @_;
	my $self = {};
	$self->{"this"} = $this;
	return bless($self, $class);
}
sub setPos
{
	perlchartdir::method("Box.setPos", \@_, 2);
}
sub setSize
{
	perlchartdir::method("Box.setSize", \@_, 2);
}
sub setBackground
{
	perlchartdir::method("Box.setBackground", \@_, 2, $perlchartdir::Transparent);
}	


package TextBox;
@ISA = ("Box", "TextStyle");

sub new
{
	my ($class, $this) = @_;
	my $self = {};
	$self->{"this"} = $this;
	return bless($self, $class);
}
sub setText
{
	perlchartdir::method("TextBox.setText", \@_, 1);
}
sub setAlignment
{
	perlchartdir::method("TextBox.setAlignment", \@_, 1);
}
sub setBackground
{
	perlchartdir::method("TextBox.setBackground", \@_, 2, $perlchartdir::Transparent);
}	


package Line;

sub new
{
	my ($class, $this) = @_;
	my $self = {};
	$self->{"this"} = $this;
	return bless($self, $class);
} 
sub setPos
{
	perlchartdir::method("Line.setPos", \@_, 4);
}
sub setColor
{
	perlchartdir::method("Line.setColor", \@_, 1);
}
sub setWidth
{
	perlchartdir::method("Line.setWidth", \@_, 1);
}

#///////////////////////////////////////////////////////////////////////////////////
#//	bindings to basechart.h
#///////////////////////////////////////////////////////////////////////////////////
package LegendBox;
@ISA = ("TextBox");

sub new
{
	my ($class, $this) = @_;
	my $self = {};
	$self->{"this"} = $this;
	return bless($self, $class);
} 
sub addKey
{
	perlchartdir::method("LegendBox.addKey", \@_, 2);
}


package BaseChart;
@ISA = ("perlchartdir");

$PNG = 0;
$GIF = 1;
$JPG = 2;
$WMP = 3;

sub DESTROY
{
	my $self = shift;
	perlchartdir::callMethod("BaseChart.destroy", $self->{"this"})
}
	
#//////////////////////////////////////////////////////////////////////////////////////
#//	set overall chart
#//////////////////////////////////////////////////////////////////////////////////////
sub setSize
{
	perlchartdir::method("BaseChart.setSize", \@_, 2);
}
sub setBorder
{
	perlchartdir::method("BaseChart.setBorder", \@_, 1);
}
sub setWallpaper
{
	perlchartdir::method("BaseChart.setWallpaper", \@_, 1);
}
sub setBgImage
{
	perlchartdir::method("BaseChart.setBgImage", \@_, 2, $perlchartdir::Center);
}
sub addTitle2
{
	return new TextBox(perlchartdir::method("BaseChart.addTitle2", \@_, 7, "", 12, 
		$perlchartdir::TextColor, $perlchartdir::Transparent, $perlchartdir::Transparent));
}
sub addTitle
{
	return new TextBox(perlchartdir::method("BaseChart.addTitle", \@_, 6, "", 12, 
		$perlchartdir::TextColor, $perlchartdir::Transparent, $perlchartdir::Transparent));
}
sub addLegend
{
	return new LegendBox(perlchartdir::method("BaseChart.addLegend", \@_, 5, 1, "", 10));
}
sub getLegend
{
	return new LegendBox(perlchartdir::method("BaseChart.getLegend", \@_));
}
#//////////////////////////////////////////////////////////////////////////////////////
#//	drawing primitives
#//////////////////////////////////////////////////////////////////////////////////////
sub getDrawArea
{
	return new DrawArea(perlchartdir::method("BaseChart.getDrawArea", \@_));
}
sub addDrawObj
{
	my $ret = eval {
		my ($self, $obj) = @{perlchartdir::checkarg(\@_, 2)};
		perlchartdir::callMethod("BaseChart.addDrawObj", $obj->{this});
		};
	if ((!$ret) && ($@)) { perlchartdir::printerr($@, 1); }
	return $obj;
}
sub addText
{
	return new TextBox(perlchartdir::method("BaseChart.addText", \@_, 9, "", 8, 
		$perlchartdir::TextColor, $perlchartdir::TopLeft, 0, 0));
}
sub addLine
{
	return new Line(perlchartdir::method("BaseChart.addLine", \@_, 6, $perlchartdir::LineColor, 1));
}
#//////////////////////////////////////////////////////////////////////////////////////
#//	color management methods
#//////////////////////////////////////////////////////////////////////////////////////
sub setColor
{
	perlchartdir::method("BaseChart.setColor", \@_, 2);
}
sub setColors
{
	my $ret = eval {
		my ($self, $colors) = @{perlchartdir::checkarg(\@_, 2)};
		if ((!scalar(@$colors)) || ($$colors[scalar(@$colors) - 1] != -1)) { push @$colors, -1; }
		perlchartdir::callMethod("BaseChart.setColors", $self->{"this"}, $colors);
		};
	if ((!$ret) && ($@)) { perlchartdir::printerr($@, 1); }
}	
sub setColors2
{
	my $ret = eval {
		my ($self, $paletteEntry, $colors) = @{perlchartdir::checkarg(\@_, 3)};
		if ((!scalar(@$colors)) || ($$colors[scalar(@$colors) - 1] != -1)) { push @$colors, -1; }
		perlchartdir::callMethod("BaseChart.setColors2", $self->{"this"}, $paletteEntry, $colors);
		};
	if ((!$ret) && ($@)) { perlchartdir::printerr($@, 1); }
}
sub getColor
{
	return perlchartdir::method("BaseChart.getColor", \@_, 1);
}
#//////////////////////////////////////////////////////////////////////////////////////
#//	chart creation methods
#//////////////////////////////////////////////////////////////////////////////////////
sub layout
{
	perlchartdir::method("BaseChart.layout", \@_);
}
sub makeChart
{
	return perlchartdir::method("BaseChart.makeChart", \@_, 1);
}
sub makeChart2
{
	return perlchartdir::method("BaseChart.makeChart2", \@_, 1);
}


package perlchartdir;

$defaultPalette = [
	0xffffff, 0x000000, 0x000000, 0x808080, 
	0x808080, 0x808080, 0x808080, 0x808080,
	0xff0000, 0x00ff00, 0x0000ff, 0xffff00, 
	0xff00ff, 0x66ffff,	0xffcc33, 0xcccccc, 
	0x9966ff, 0x339966, 0x999900, 0xcc3300,	
	0x99cccc, 0x006600, 0x660066, 0xcc9999,
	-1
];
$whiteOnBlackPalette = [
	0x000000, 0xffffff, 0xffffff, 0x808080, 
	0x808080, 0x808080, 0x808080, 0x808080,
	0xff0000, 0x00ff00, 0x0000ff, 0xffff00, 
	0xff00ff, 0x66ffff,	0xffcc33, 0xcccccc, 
	0x9966ff, 0x339966, 0x999900, 0xcc3300,	
	0x99cccc, 0x006600, 0x660066, 0xcc9999,
	-1
];
$transparentPalette = [ 
	0xffffff, 0x000000, 0x000000, 0x808080, 
	0x808080, 0x808080, 0x808080, 0x808080,
	0x80ff0000, 0x8000ff00, 0x800000ff, 0x80ffff00, 
	0x80ff00ff, 0x8066ffff,	0x80ffcc33, 0x80cccccc, 
	0x809966ff, 0x80339966, 0x80999900, 0x80cc3300,
	0x8099cccc, 0x80006600, 0x80660066, 0x80cc9999,
	-1
];

#///////////////////////////////////////////////////////////////////////////////////
#//	bindings to piechart.h
#///////////////////////////////////////////////////////////////////////////////////
package Sector;

sub new
{
	my ($class, $this) = @_;
	my $self = {};
	$self->{"this"} = $this;
	return bless($self, $class);
} 
sub setExplode
{
	perlchartdir::method("Sector.setExplode", \@_, 1, -1);
}
sub setLabelFormat
{
	perlchartdir::method("Sector.setLabelFormat", \@_, 1);
}
sub setLabelStyle
{
	return new TextBox(perlchartdir::method("Sector.setLabelStyle", \@_, 3, "", 8, $perlchartdir::TextColor));
}
sub setLabelPos
{
	perlchartdir::method("Sector.setLabelPos", \@_, 2, $perlchartdir::Transparent);
}


package PieChart;
@ISA = ("BaseChart");

sub new 
{
	my $class = shift;
	my $self = {};
	$self->{"this"} = perlchartdir::func("PieChart.create", \@_, 4, 
		$perlchartdir::BackgroundColor, $perlchartdir::Transparent);
	return bless($self, $class);
}
sub setPieSize
{
	perlchartdir::method("PieChart.setPieSize", \@_, 3);
}
sub set3D
{
	perlchartdir::method("PieChart.set3D", \@_, 3, -1, -1, 0);
}
sub setStartAngle
{
	perlchartdir::method("PieChart.setStartAngle", \@_, 2, 1);
}
sub setLabelFormat
{
	perlchartdir::method("PieChart.setLabelFormat", \@_, 1);
}
sub setLabelStyle
{
	return new TextBox(perlchartdir::method("PieChart.setLabelStyle", \@_, 3, 8, $perlchartdir::TextColor));
}
sub setLabelPos
{
	perlchartdir::method("PieChart.setLabelPos", \@_, 2, $perlchartdir::Transparent);
}
sub setData
{
	my $ret = eval {
		my ($self, $data, $labels) = @{perlchartdir::checkarg(\@_, 3, [])};
		perlchartdir::callMethod("PieChart.setData", $self->{"this"}, scalar(@$data), $data, $labels);
		};
	if ((!$ret) && ($@)) { perlchartdir::printerr($@, 1); }
}
sub sector
{
	return new Sector(perlchartdir::method("PieChart.sector", \@_, 1));
}

#///////////////////////////////////////////////////////////////////////////////////
#//	bindings to axis.h
#///////////////////////////////////////////////////////////////////////////////////
package BaseAxis;

sub new
{
	my ($class, $this) = @_;
	my $self = {};
	$self->{"this"} = $this;
	return bless($self, $class);
} 
sub setLabelStyle
{
	return new TextBox(perlchartdir::method("BaseAxis.setLabelStyle", \@_, 4, 
		8, $perlchartdir::TextColor, 0));
}
sub setLabelGap
{
	perlchartdir::method("BaseAxis.setLabelGap", \@_, 1);
}
sub setTitle
{
	return new TextBox(perlchartdir::method("BaseAxis.setTitle", \@_, 4, 
		"arialbd.ttf", 8, $perlchartdir::TextColor));
}
sub setTitlePos
{
	perlchartdir::method("BaseAxis.setTitlePos", \@_, 2, 6);
}
sub setColors
{
	perlchartdir::method("BaseAxis.setColors", \@_, 4, $perlchartdir::TextColor, -1, -1);
}
sub setTickLength
{
	if (scalar(@_) == 3) { setTickLength2(@_); }
	else { perlchartdir::method("BaseAxis.setTickLength", \@_, 1); }
}
sub setTickLength2
{
	perlchartdir::method("BaseAxis.setTickLength2", \@_, 2);
}
sub getCoor
{
	return perlchartdir::method("BaseAxis.getCoor", \@_, 1);
}
sub getLength
{
	return perlchartdir::method("BaseAxis.getLength", \@_);
}


package XAxis;
@ISA = ("BaseAxis");

sub new
{
	my ($class, $this) = @_;
	my $self = {};
	$self->{"this"} = $this;
	return bless($self, $class);
} 
sub setLabels
{
	my $ret = eval {
		my ($self, $labels) = @{perlchartdir::checkarg(\@_, 2)};
		return new TextBox(perlchartdir::callMethod("XAxis.setLabels", $self->{"this"}, 
			scalar(@$labels), $labels));
		};
	if ((!$ret) && ($@)) { perlchartdir::printerr($@, 1); }
	return $ret;
}
sub setIndent
{
	perlchartdir::method("XAxis.setIndent", \@_, 1);
}


package Mark;
@ISA = ("TextStyle");

sub new
{
	my ($class, $this) = @_;
	my $self = {};
	$self->{"this"} = $this;
	return bless($self, $class);
} 
sub setValue
{
	perlchartdir::method("Mark.setValue", \@_, 1);
}
sub setMarkColor
{
	perlchartdir::method("Mark.setMarkColor", \@_, 3, -1, -1);
}
sub setLineWidth
{
	perlchartdir::method("Mark.setLineWidth", \@_, 1);
}


package YAxis;
@ISA = ("BaseAxis");

sub new
{
	my ($class, $this) = @_;
	my $self = {};
	$self->{"this"} = $this;
	return bless($self, $class);
} 
sub addMark
{
	return new Mark(perlchartdir::method("YAxis.addMark", \@_, 5, "", "", 8));
}
sub addZone
{
	perlchartdir::method("YAxis.addZone", \@_, 3);
}
sub setLinearScale
{
	perlchartdir::method("YAxis.setLinearScale", \@_, 3, 0);
}
sub setLogScale
{
	perlchartdir::method("YAxis.setLogScale", \@_, 1, 1);
}
sub setLogScale2
{
	perlchartdir::method("YAxis.setLogScale2", \@_, 3, 0);
}
sub setAutoScale
{
	perlchartdir::method("YAxis.setAutoScale", \@_, 2, 0, 0);
}
sub setTickDensity
{
	perlchartdir::method("YAxis.setTickDensity", \@_, 1);
}
sub setTopMargin
{
	perlchartdir::method("YAxis.setTopMargin", \@_, 1);
}
sub setLabelFormat
{
	perlchartdir::method("YAxis.setLabelFormat", \@_, 1);
}


#///////////////////////////////////////////////////////////////////////////////////
#//	bindings to layer.h
#///////////////////////////////////////////////////////////////////////////////////
package perlchartdir;

$NoValue = +1.7e308;


package DataSet;

sub new
{
	my ($class, $this) = @_;
	my $self = {};
	$self->{"this"} = $this;
	return bless($self, $class);
} 
sub setData
{
	my $ret = eval {
		my ($self, $data) = @{perlchartdir::checkarg(\@_, 2)};
		perlchartdir::callMethod("DataSet.setData", $self->{"this"}, scalar(@$data), $data);
		};
	if ((!$ret) && ($@)) { perlchartdir::printerr($@, 1); }
}
sub setDataName
{
	perlchartdir::method("DataSet.setDataName", \@_, 1);
}
sub setDataColor
{
	perlchartdir::method("DataSet.setDataColor", \@_, 4, $perlchartdir::LineColor, -1, -1);
}
sub setUseYAxis2
{
	perlchartdir::method("DataSet.setUseYAxis2", \@_, 1, 1);
}
sub setLineWidth
{
	perlchartdir::method("DataSet.setLineWidth", \@_, 1);
}
sub setDataLabelFormat
{
	perlchartdir::method("DataSet.setDataLabelFormat", \@_, 1);
}
sub setDataLabelStyle
{
	return new TextStyle(perlchartdir::method("DataSet.setDataLabelStyle", \@_, 4, "", 8, $perlchartdir::TextColor, 0));
}


package Layer;

$Overlay = 0;
$Stack = 1;
$Depth = 2;
$Side = 3;

sub new
{
	my ($class, $this) = @_;
	my $self = {};
	$self->{"this"} = $this;
	return bless($self, $class);
}
sub setSize
{
	perlchartdir::method("Layer.setSize", \@_, 4);
}
sub set3D
{
	perlchartdir::method("Layer.set3D", \@_, 2, -1, 0);
}
sub set3D2
{
	perlchartdir::method("Layer.set3D2", \@_, 4);
}
sub setLineWidth
{
	perlchartdir::method("Layer.setLineWidth", \@_, 1);
}
sub setDataCombineMethod
{
	perlchartdir::method("Layer.setDataCombineMethod", \@_, 1);
}
sub addDataSet
{
	my $ret = eval {
		my ($self, $data, $color, $name) = @{perlchartdir::checkarg(\@_, 4, -1, "")};
		return new DataSet(perlchartdir::callMethod("Layer.addDataSet", $self->{"this"}, 
			scalar(@$data), $data, $color, $name));
		};
	if ((!$ret) && ($@)) { perlchartdir::printerr($@, 1); }
	return $ret;
}
sub getMinX
{
	return perlchartdir::method("Layer.getMinX", \@_);
}
sub getMaxX
{
	return perlchartdir::method("Layer.getMaxX", \@_);
}
sub getMaxY
{
	return perlchartdir::method("Layer.getMaxY", \@_, 1, 1);
}
sub getMinY
{
	return perlchartdir::method("Layer.getMinY", \@_, 1, 1);
}
sub getDepthX
{
	return perlchartdir::method("Layer.getDepthX", \@_);
}
sub getDepthY
{
	return perlchartdir::method("Layer.getDepthY", \@_);
}
sub getXCoor
{
	return perlchartdir::method("Layer.getXCoor", \@_, 1);
}
sub getYCoor
{
	return perlchartdir::method("Layer.getYCoor", \@_, 2, 1);
}
sub setDataLabelFormat
{
	perlchartdir::method("Layer.setDataLabelFormat", \@_, 1);
}
sub setDataLabelStyle
{
	return new TextStyle(perlchartdir::method("Layer.setDataLabelStyle", \@_, 4, "", 8, $perlchartdir::TextColor, 0));
}
sub setAggregateLabelFormat
{
	perlchartdir::method("Layer.setAggregateLabelFormat", \@_, 1);
}
sub setAggregateLabelStyle
{
	return new TextStyle(perlchartdir::method("Layer.setAggregateLabelStyle", \@_, 4, "", 8, $perlchartdir::TextColor, 0));
}


#///////////////////////////////////////////////////////////////////////////////////
#//	bindings to barlayer.h
#///////////////////////////////////////////////////////////////////////////////////
package BarLayer;
@ISA = ("Layer");

sub new
{
	my ($class, $this) = @_;
	my $self = {};
	$self->{"this"} = $this;
	return bless($self, $class);
}
sub setBarGap
{
	perlchartdir::method("BarLayer.setBarGap", \@_, 2, 0.2);
}


#///////////////////////////////////////////////////////////////////////////////////
#//	bindings to linelayer.h
#///////////////////////////////////////////////////////////////////////////////////
package LineLayer;
@ISA = ("Layer");

sub new
{
	my ($class, $this) = @_;
	my $self = {};
	$self->{"this"} = $this;
	return bless($self, $class);
}


#///////////////////////////////////////////////////////////////////////////////////
#//	bindings to arealayer.h
#///////////////////////////////////////////////////////////////////////////////////
package AreaLayer;
@ISA = ("Layer");

sub new
{
	my ($class, $this) = @_;
	my $self = {};
	$self->{"this"} = $this;
	return bless($self, $class);
}


#///////////////////////////////////////////////////////////////////////////////////
#//	bindings to hloclayer.h
#///////////////////////////////////////////////////////////////////////////////////
package HLOCLayer;
@ISA = ("Layer");

sub new
{
	my ($class, $this) = @_;
	my $self = {};
	$self->{"this"} = $this;
	return bless($self, $class);
}


#///////////////////////////////////////////////////////////////////////////////////
#//	bindings to xychart.h
#///////////////////////////////////////////////////////////////////////////////////
package PlotArea;
sub new
{
	my ($class, $this) = @_;
	my $self = {};
	$self->{"this"} = $this;
	return bless($self, $class);
}
sub setBackground
{
	perlchartdir::method("PlotArea.setBackground", \@_, 3, -1, $perlchartdir::LineColor);
}
sub setBackground2
{
	perlchartdir::method("PlotArea.setBackground2", \@_, 2, $perlchartdir::Center);
}
sub setGridColor
{
	perlchartdir::method("PlotArea.setGridColor", \@_, 2, $perlchartdir::Transparent);
}


package XYChart;
@ISA = ("BaseChart");

sub new 
{
	my $class = shift;
	my $self = {};
	$self->{"this"} = perlchartdir::func("XYChart.create", \@_, 4, 
		$perlchartdir::BackgroundColor, $perlchartdir::Transparent);
	return bless($self, $class);
}
sub yAxis
{
	return new YAxis(perlchartdir::method("XYChart.yAxis", \@_));	
}
sub yAxis2
{
	return new YAxis(perlchartdir::method("XYChart.yAxis2", \@_));
}
sub syncYAxis
{
	perlchartdir::method("XYChart.syncYAxis", \@_, 2, 1, 0);
}
sub setYAxisOnRight
{
	perlchartdir::method("XYChart.setYAxisOnRight", \@_, 1);
}
sub xAxis
{
	return new XAxis(perlchartdir::method("XYChart.xAxis", \@_));	
}
sub xAxis2
{
	return new XAxis(perlchartdir::method("XYChart.xAxis2", \@_));
}
sub setPlotArea
{
	return new PlotArea(perlchartdir::method("XYChart.setPlotArea", \@_, 9,	$perlchartdir::Transparent, 
		-1, $perlchartdir::LineColor, 0xc0c0c0, $perlchartdir::Transparent));
}
sub addBarLayer
{
	if (scalar(@_) == 1) { return addBarLayer2(@_); }
	my $ret = eval {
		my ($self, $data, $color, $name, $depth) = @{perlchartdir::checkarg(\@_, 5, -1, "", 0)};
		return new BarLayer(perlchartdir::callMethod("XYChart.addBarLayer", $self->{"this"}, 
			scalar(@$data), $data, $color, $name, $depth));
		};
	if ((!$ret) && ($@)) { perlchartdir::printerr($@, 1); }
	return $ret;
}
sub addBarLayer2
{
	return new BarLayer(perlchartdir::method("XYChart.addBarLayer2", \@_, 2, $Layer::Side, 0));
}
sub addLineLayer
{
	if (scalar(@_) == 1) { return addLineLayer2(@_); }
	my $ret = eval {
		my ($self, $data, $color, $name, $depth) = @{perlchartdir::checkarg(\@_, 5, -1, "", 0)};
		return new LineLayer(perlchartdir::callMethod("XYChart.addLineLayer", $self->{"this"}, 
			scalar(@$data), $data, $color, $name, $depth));
		};
	if ((!$ret) && ($@)) { perlchartdir::printerr($@, 1); }
	return $ret;
}
sub addLineLayer2
{
	return new LineLayer(perlchartdir::method("XYChart.addLineLayer2", \@_, 2, $Layer::Overlay, 0));
}
sub addAreaLayer
{
	if (scalar(@_) == 1) { return addAreaLayer2(@_); }
	my $ret = eval {
		my ($self, $data, $color, $name, $depth) = @{perlchartdir::checkarg(\@_, 5, -1, "", 0)};
		return new AreaLayer(perlchartdir::callMethod("XYChart.addAreaLayer", $self->{"this"}, 
			scalar(@$data), $data, $color, $name, $depth));
		};
	if ((!$ret) && ($@)) { perlchartdir::printerr($@, 1); }
	return $ret;
}
sub addAreaLayer2
{
	return new AreaLayer(perlchartdir::method("XYChart.addAreaLayer2", \@_, 2, $Layer::Stack, 0));
}
sub addHLOCLayer
{
	if (scalar(@_) == 1) { return addHLOCLayer2(@_); }
	my $ret = eval {
		my ($self, $highData, $lowData, $openData, $closeData, $color) = 
			@{perlchartdir::checkarg(\@_, 6, [], [], [], -1)};
		my $len = scalar(@$highData) > scalar(@$lowData) ? scalar(@$highData) : scalar(@$lowData);
		$len = $len > scalar(@$openData) ? $len : scalar(@$openData);
		$len = $len > scalar(@$closeData) ? $len : scalar(@$closeData);
		return new HLOCLayer(perlchartdir::callMethod("XYChart.addHLOCLayer", $self->{"this"}, 
			$len, $highData, $lowData, $openData, $closeData, $color));
		};
	if ((!$ret) && ($@)) { perlchartdir::printerr($@, 1); }
	return $ret;
}
sub addHLOCLayer2
{
	return new HLOCLayer(perlchartdir::method("XYChart.addHLOCLayer2", \@_));
}


#///////////////////////////////////////////////////////////////////////////////////
#//	bindings to chartdir.h
#///////////////////////////////////////////////////////////////////////////////////
package perlchartdir;

sub getCopyright
{
	return func("getCopyright", \@_);
}
sub getVersion
{
	return func("getVersion", \@_);
}
sub getDescription
{
	return func("getDescription", \@_)
}


1;