from pychartdir import *


def main() :

	#The data for the pie chart
	data = [ 25, 18, 15, 12, 8, 30, 35 ]

	#The labels for the pie chart
	labels = [ "Labor", "Licenses", "Taxes", "Legal",
		"Insurance", "Facilities", "Production" ] 

	#First, create a PieChart of size 450 pixels x 300 pixels
	c = PieChart(450, 300)

	#Set the center of the pie at (150, 150) and the radius to 100 pixels
	c.setPieSize(150, 150, 100)

	#Add a title to the pie chart
	c.addTitle("Project Cost Breakdown")
	
	#Draw the pie in 3D
	c.set3D()

	#add a legend box where the top left corner is at (330, 80)
	c.addLegend(330, 80)
	
	#modify the label format for the sectors to $nnnK (pp.pp%) 
	c.setLabelFormat("$&value&K\n(&percent&%)")
		
	#Set the pie data and the pie labels
	c.setData(data, labels)

	#Explode the 1st sector
	c.sector(0).setExplode()

	#output the chart as a PNG file
	c.makeChart("legendpie.png")


if __name__ == '__main__':
    main()
    
