/*
 * Copyright (C) 2001 Advanced Software Engineering Limited.
 *
 * This file is part of the ChartDirector software. Usage of this file is
 * subjected to the ChartDirector license agreement. See the LICENSE.TXT
 * file that comes with the ChartDirector software release, or visit
 * Advanced Software Engineering's web site at www.advsofteng.com or 
 * email to support@advsofteng.com for information.
 *
 */
 
#ifndef SCRIPTPLUGIN_HDR
#define SCRIPTPLUGIN_HDR

#ifdef __cplusplus
extern "C" {
#endif


struct VarConverter
{
	int (*varToDouble)(void *val, double *ret);
	int (*varToInt)(void *val, int *ret);
	int (*varToBool)(void *val, int *ret);
	int (*varToString)(void *val, char **str);
	void (*varToStringFree)(char *str);
	int (*varToStringArray)(void *val, char ***array, int *arraySize);
	void (*varToStringArrayFree)(char **array);
	int (*varToDoubleArray)(void *val, double **array, int *arraySize);
	void (*varToDoubleArrayFree)(double *array);
	int (*varToIntArray)(void *val, int **array, int *arraySize);
	void (*varToIntArrayFree)(int *array);
	int (*varFromDouble)(double f, void *val);
	int (*varFromInt)(int i, void *val);
	int (*varFromBool)(int b, void *val);
	int (*varFromString)(const char *str, void *val);
	int (*varFromMemBlock)(const char *str, int len, void *val);
};


#define MAX_ERRMSG 1024
__declspec(dllexport) int runMethod(struct VarConverter *c, int argCount, void **args, void *ret, char *errmsg);


#ifdef __cplusplus
}
#endif

#endif