#ifndef CALENDAR_INCLUDED
#define CALENDAR_INCLUDED

#ifdef __cplusplus
extern "C" {
#endif

#include <windows.h>

#if defined (WIN32)
#define DLLENTRY
#else
#include <windows.h>
#define DLLENTRY      CALLBACK _loadds
#endif

// structures
typedef struct
{
    int         xPos;                  // initial x position of window
    int         yPos;                  // initial y position of window
    int         xSize;                 // initial x size of window
    int         ySize;                 // initial y size of window
    COLORREF    DayColor;              // color of unselected days
    COLORREF    SelectedDayColor;      // color of selected days
    COLORREF    SelectedBkgColor;      // backgnd color of selected days (no 3D)
    BOOL        Days3D;                // 3D appearance of days
    BOOL        ClickToSelect;         // mouse click necessary to select day
    short       FirstDayOfWeek;        // first day of week
    char        FontName[LF_FACESIZE]; // name of font for numbers of days
} CALENDAR;
typedef CALENDAR *     PCALENDAR;
typedef CALENDAR NEAR* NPCALENDAR;
typedef CALENDAR FAR*  LPCALENDAR;

#define     MONDAY      1
#define     TUESDAY     2
#define     WEDNESDAY   3
#define     THURSDAY    4
#define     FRIDAY      5
#define     SATURDAY    6
#define     SUNDAY      7

// function prototypes
void            DLLENTRY calInit(char *);
void            DLLENTRY calSetDefaults(void);
LPCALENDAR      DLLENTRY calGetParams(LPCALENDAR);
BOOL            DLLENTRY calSetParams(LPCALENDAR);
char           *DLLENTRY Calendar(HWND, char *, char *);

#ifdef __cplusplus
}
#endif

#endif      //CALENDAR_INCLUDED
