// UserARBB.h: interface for the UserARBB class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_USERARBB_H__8D3A0360_1B75_11D4_B60F_E2C12B924D13__INCLUDED_)
#define AFX_USERARBB_H__8D3A0360_1B75_11D4_B60F_E2C12B924D13__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "ArbbDll.h"

class NodARBB;
class ARBB;

/* Clasa UserARBB este folosita pentru obiecte ce folosesc obiecte ARBB.
	Obiectele ARBB se pot folosi de oricine, dar functiile ARBB: 
	OnEachNode, OnEachPage, GrepSubTree si WalkOnSnake fac apeluri la functii
	aplicatie de tip "non-this call"; deci daca un obiect aplicatie vrea sa
	foloseasca obiecte ARBB, trebuie sa-si defineasca functii statice - poate
	si membrii statici -, din interiorul carora nu poate sa-si acceseze membrii
	si metodele lui nonstatice, ceea ce va fi destul de nasol la un moment dat.
	Daca se folosesc obiecte ARBB globale, atunci nu e nici o problema, nu e
	nevoie de aceasta clasa.
	Pentru acest lucru exista functiile nominalizate mai sus extinse ( cu
	sufixul 'Usr' ) ale clasei ARBB; acestea stiu sa faca apeluri de tip "this
	call" la functiile unui obiect UserARBB, care-si va putea folosi din plin
	membrii proprii. Pentru ca ARBB sa stie pe cine va apela, puteti anterior
	stabili acest lucru prin metoda 'BOOL SetUser ( const UserARBB* )'.
	Clasa UserARBB e virtuala.
*/

class ARBBDLL_API UserARBB {

public:

	UserARBB();
	virtual ~UserARBB();

protected:
	
	// apelata de ARBB :: OnEachNode
	virtual void OnNodeARBB ( const NodARBB* pNod );
	
	// apelata de ARBB :: OnEachPage
	virtual void OnPageARBB ( BOOL bCall );

	// apelata de ARBB :: GrepSubTree
	virtual BOOL OnGrepARBB ( unsigned nLevels, unsigned nNodes, unsigned nPages );

	// apelata de ARBB :: WalkOnSnake
	virtual BOOL OnWalkARBB ();

	// apelata de ARBB :: Draw
	virtual void OnDrawARBB ( unsigned hCoordPar, unsigned vCoordPar,
							unsigned hCoordChild, unsigned vCoordChild );

	friend class ARBB;

};

#endif // !defined(AFX_USERARBB_H__8D3A0360_1B75_11D4_B60F_E2C12B924D13__INCLUDED_)
