/*
 * Decompiled with CFR 0.152.
 */
import java.util.NoSuchElementException;

public class VectorString {
    public String[] elementData;
    public int elementCount;
    public int capacityIncrement;
    public int initialCapacity;
    boolean separeDrives = false;
    public int index = 0;

    public VectorString(int n, int n2) {
        this.elementData = new String[n];
        this.capacityIncrement = n2;
        this.initialCapacity = n;
    }

    public VectorString(int n) {
        this(n, 1);
    }

    public VectorString() {
        this(16);
    }

    public void clear() {
        this.elementData = new String[this.initialCapacity];
        this.elementCount = 0;
    }

    public final synchronized void copyInto(String[] stringArray) {
        int n = this.elementCount;
        while (n-- > 0) {
            stringArray[n] = this.elementData[n];
        }
    }

    public final synchronized void copyInto(VectorString vectorString) {
        int n = this.elementCount;
        vectorString.setSize(n);
        for (int i = 0; i < n; ++i) {
            vectorString.addElement(this.elementData[i]);
        }
    }

    public final synchronized String[] toArray() {
        String[] stringArray = new String[this.elementCount];
        System.arraycopy(this.elementData, 0, stringArray, 0, this.elementCount);
        return stringArray;
    }

    public final synchronized String[] getArray() {
        return this.elementData;
    }

    public final synchronized void trimToSize() {
        int n = this.elementData.length;
        if (this.elementCount < n) {
            String[] stringArray = this.elementData;
            this.elementData = new String[this.elementCount];
            VectorString.copy(stringArray, this.elementData, this.elementCount);
        }
    }

    public final synchronized void ensureCapacity(int n) {
        int n2 = this.elementData.length;
        if (n > n2) {
            int n3;
            String[] stringArray = this.elementData;
            int n4 = n3 = this.capacityIncrement > 0 ? n2 + this.capacityIncrement : n2 * 2;
            if (n3 < n) {
                n3 = n;
            }
            this.elementData = new String[n3];
            VectorString.copy(stringArray, this.elementData, this.elementCount);
        }
    }

    public final synchronized void setSize(int n) {
        if (n > this.elementCount) {
            this.ensureCapacity(n);
        } else {
            for (int i = n; i < this.elementCount; ++i) {
                this.elementData[i] = null;
            }
        }
        this.elementCount = n;
    }

    public final int capacity() {
        return this.elementData.length;
    }

    public final int size() {
        return this.elementCount;
    }

    public final boolean isEmpty() {
        return this.elementCount == 0;
    }

    public final boolean contains(String string) {
        return this.indexOf(string, 0) >= 0;
    }

    public final int indexOf(String string) {
        return this.indexOf(string, 0);
    }

    public final synchronized int indexOf(String string, int n) {
        for (int i = n; i < this.elementCount; ++i) {
            if (!string.equals(this.elementData[i])) continue;
            return i;
        }
        return -1;
    }

    public final int lastIndexOf(String string) {
        return this.lastIndexOf(string, this.elementCount - 1);
    }

    public final synchronized int lastIndexOf(String string, int n) {
        for (int i = n; i >= 0; --i) {
            if (!string.equals(this.elementData[i])) continue;
            return i;
        }
        return -1;
    }

    public final synchronized String elementAt(int n) {
        if (n >= this.elementCount) {
            throw new ArrayIndexOutOfBoundsException(String.valueOf(new StringBuffer(String.valueOf(n)).append(" >= ").append(this.elementCount)));
        }
        return this.elementData[n];
    }

    public final synchronized String firstElement() {
        if (this.elementCount == 0) {
            throw new NoSuchElementException();
        }
        return this.elementData[0];
    }

    public final synchronized String lastElement() {
        if (this.elementCount == 0) {
            throw new NoSuchElementException();
        }
        return this.elementData[this.elementCount - 1];
    }

    public final synchronized void setElementAt(String string, int n) {
        if (n >= this.elementCount) {
            throw new ArrayIndexOutOfBoundsException(String.valueOf(new StringBuffer(String.valueOf(n)).append(" >= ").append(this.elementCount)));
        }
        this.elementData[n] = string;
    }

    public final synchronized void removeElementAt(int n) {
        if (n >= this.elementCount) {
            throw new ArrayIndexOutOfBoundsException(String.valueOf(new StringBuffer(String.valueOf(n)).append(" >= ").append(this.elementCount)));
        }
        if (n < 0) {
            throw new ArrayIndexOutOfBoundsException(n);
        }
        int n2 = this.elementCount - n - 1;
        if (n2 > 0) {
            VectorString.copy(this.elementData, n + 1, this.elementData, n, n2);
        }
        --this.elementCount;
        this.elementData[this.elementCount] = null;
    }

    public final synchronized void insertElementAt(String string, int n) {
        if (n >= this.elementCount + 1) {
            throw new ArrayIndexOutOfBoundsException(String.valueOf(new StringBuffer(String.valueOf(n)).append(" > ").append(this.elementCount)));
        }
        this.ensureCapacity(this.elementCount + 1);
        VectorString.copy(this.elementData, n, this.elementData, n + 1, this.elementCount - n);
        this.elementData[n] = string;
        ++this.elementCount;
    }

    public final synchronized void addElement(String string) {
        this.ensureCapacity(this.elementCount + 1);
        this.elementData[this.elementCount++] = string;
    }

    public final synchronized void addElement(StringBuffer stringBuffer) {
        this.ensureCapacity(this.elementCount + 1);
        this.elementData[this.elementCount++] = new String(stringBuffer);
    }

    public final synchronized boolean addUnicElement(String string) {
        int n = 0;
        while (n < this.elementCount) {
            if (!string.equalsIgnoreCase(this.elementData[n++])) continue;
            return false;
        }
        this.addElement(string);
        return true;
    }

    public final synchronized boolean removeElement(String string) {
        int n = this.indexOf(string);
        if (n >= 0) {
            this.removeElementAt(n);
            return true;
        }
        return false;
    }

    public final synchronized void removeAllElements() {
        for (int i = 0; i < this.elementCount; ++i) {
            this.elementData[i] = null;
        }
        this.elementCount = 0;
    }

    public final synchronized String toString() {
        int n = this.size() - 1;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[");
        for (int i = 0; i <= n; ++i) {
            stringBuffer.append(this.elementAt(i));
            if (i >= n) continue;
            stringBuffer.append(", ");
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    public int compare(int n, int n2) {
        return this.elementData[n].compareTo(this.elementData[n2]);
    }

    void swap(int n, int n2) {
        String string = this.elementData[n];
        this.elementData[n] = this.elementData[n2];
        this.elementData[n2] = string;
    }

    int sortCompare(int n, int n2) {
        String string = this.elementData[n];
        String string2 = this.elementData[n2];
        if (this.separeDrives) {
            boolean bl;
            boolean bl2 = string.charAt(1) == ':' && string.length() == 2;
            boolean bl3 = bl = string2.charAt(1) == ':' && string2.length() == 2;
            if (bl2 != bl) {
                if (bl2) {
                    return -1;
                }
                return 1;
            }
        }
        return Sort.superCompare(string, string2);
    }

    public int separeDrives() {
        return SortDir.separeDrives(this.elementData, 0, this.elementCount);
    }

    public void sort(boolean bl) {
        this.sort(0, this.size(), bl);
    }

    public void sort() {
        this.sort(0, this.size());
    }

    public void sort(int n, int n2, boolean bl) {
        this.separeDrives = true;
        this.sort(n, n2);
        this.separeDrives = false;
    }

    public void sort(int n, int n2) {
        if (n2 <= n) {
            return;
        }
        int n3 = n;
        int n4 = n3 + 1;
        while (n4 < n2) {
            while (n3 >= n && this.sortCompare(n3, n3 + 1) > 0) {
                this.swap(n3, n3 + 1);
                --n3;
            }
            n3 = n4++;
        }
    }

    public static void copy(String[] stringArray, String[] stringArray2, int n) {
        for (int i = 0; i < n; ++i) {
            stringArray2[i] = stringArray[i];
        }
    }

    public static void copy(String[] stringArray, int n, String[] stringArray2, int n2, int n3) {
        for (int i = 0; i < n3; ++i) {
            stringArray2[i + n2] = stringArray[i + n];
        }
    }

    public void restart() {
        this.index = 0;
    }

    public boolean hasMoreElements() {
        return this.index < this.elementCount;
    }

    public String nextElement() {
        if (this.index < this.elementCount) {
            return this.elementData[this.index++];
        }
        throw new NoSuchElementException("StringEnumerator");
    }
}

