Attribute VB_Name = "Utils"
Option Explicit

Global Const PI# = 3.14159

Global glIniFile$

Declare Function GetPrivateProfileStringA& Lib "kernel32" (ByVal sect$, ByVal entry$, ByVal DEFAULT$, ByVal buff$, ByVal buffsize&, ByVal fname$)
Declare Function GetPrivateProfileSectionA& Lib "kernel32" Alias "GetPrivateProfileString" (ByVal sect$, ByVal entry&, ByVal DEFAULT$, ByVal buff$, ByVal buffsize&, ByVal fname$)
Declare Function WritePrivateProfileStringA& Lib "kernel32" (ByVal sect$, ByVal entry$, ByVal dat$, ByVal fname$)
Declare Function GetTickCount& Lib "kernel32" ()

Global Const SRCCOPY& = &HCC0020

Declare Function BitBlt Lib "gdi32" (ByVal hDestDC As Long, ByVal x As Long, ByVal y As Long, ByVal nWidth As Long, ByVal nHeight As Long, ByVal hSrcDC As Long, ByVal xSrc As Long, ByVal ySrc As Long, ByVal dwRop As Long) As Long
Declare Function GetPixel Lib "gdi32" (ByVal hdc As Long, ByVal x As Long, ByVal y As Long) As Long
Declare Function SetPixel Lib "gdi32" (ByVal hdc As Long, ByVal x As Long, ByVal y As Long, ByVal crColor As Long) As Long


Global busyCount%

Const NUM_TIMEOUT_COUNTERS = 10

Dim timeoutCounters&(0 To NUM_TIMEOUT_COUNTERS - 1, 0 To 2)


Function fixdeg#(ByVal d#)
   If d < 0 Then d = d + 360
   If d >= 360 Then d = d - 360
   fixdeg = d
End Function

Function GetTimeMark&()
   Dim tmark&
   
   tmark = GetTickCount()
   
   On Error Resume Next
   
   If tmark < 0 Then tmark = Abs(tmark)
   
   GetTimeMark = tmark
End Function

Function rtod#(ByVal radians#)
   'dtor = (degrees / 180) * PI
   rtod = 359 * (radians / (2 * PI))
End Function

Function timeoutAllocate%()
   Dim i%
   
   For i = 0 To NUM_TIMEOUT_COUNTERS - 1
      If Not timeoutCounters(i, 2) Then
         timeoutCounters(i, 0) = -1
         timeoutCounters(i, 1) = -1
         timeoutCounters(i, 2) = True
         Exit For
      End If
   Next
   
   If i = NUM_TIMEOUT_COUNTERS Then i = -1: Stop
   
   timeoutAllocate = i
End Function

Sub timeoutFree(ByVal nTimer%)
   timeoutCounters(nTimer, 0) = -1
   timeoutCounters(nTimer, 1) = -1
   timeoutCounters(nTimer, 2) = False
End Sub

Function timeoutGetRemainingMils&(ByVal nTimer%)
   
   If Not timeoutCounters(nTimer, 2) Then Stop
  
   If timeoutCounters(nTimer, 0) = -1 Then timeoutGetRemainingMils = 0: Exit Function

   timeoutGetRemainingMils = timeoutCounters(nTimer, 1)
End Function

Function timeoutGetRemainingSeconds&(ByVal nTimer%)
   timeoutGetRemainingSeconds = timeoutGetRemainingMils(nTimer) / 1000
End Function

Function timeoutGetRemainingTenths&(ByVal nTimer%)
   timeoutGetRemainingTenths = timeoutGetRemainingMils(nTimer) / 100
End Function


Sub timeoutInit()
   Dim i%
   
   For i = 0 To NUM_TIMEOUT_COUNTERS - 1
      Call timeoutFree(i)
   Next
   
End Sub

Function timeoutIsExpired%(ByVal nTimer%)
   Dim curTicks&, elapsedTicks&, ticksLeft&
   
   If Not timeoutCounters(nTimer, 2) Then Stop
   
   If timeoutCounters(nTimer, 0) = -1 Then timeoutIsExpired = True: Exit Function
   
   curTicks = GetTimeMark()
   
   elapsedTicks = GetElapsedMils(timeoutCounters(nTimer, 0))
   ticksLeft = (timeoutCounters(nTimer, 1) - elapsedTicks)
   
   If ticksLeft <= 0 Then
      timeoutCounters(nTimer, 0) = -1
      timeoutIsExpired = True
   Else
      timeoutCounters(nTimer, 0) = curTicks
      timeoutCounters(nTimer, 1) = ticksLeft
      timeoutIsExpired = False
   End If
End Function

Sub timeoutSetMils(ByVal nTimer%, ByVal nTicks&)
           
   If Not timeoutCounters(nTimer, 2) Then Stop
   
   timeoutCounters(nTimer, 0) = GetTimeMark()
   timeoutCounters(nTimer, 1) = nTicks
   
End Sub

Function GetElapsedMils&(ByVal markTicks&)
   Dim curTicks&
   
   curTicks = GetTimeMark()
   
   If curTicks >= markTicks Then
      GetElapsedMils = curTicks - markTicks
   Else
      GetElapsedMils = curTicks + (2147483647 - markTicks)
   End If
   
End Function


Function GetElapsedSeconds&(ByVal markTicks&)
   GetElapsedSeconds = GetElapsedMils(markTicks) / 1000
End Function

Function GetElapsedTenths&(ByVal markTicks&)
   GetElapsedTenths = GetElapsedMils(markTicks) / 100
End Function


Function htoi%(ByVal h$)
   htoi = Val("&H" + h$)
End Function



Sub timeoutSetSeconds(ByVal nTimer%, ByVal nsecs%)
   Call timeoutSetMils(nTimer, nsecs * 1000)
End Sub

Sub timeoutSetTenths(ByVal nTimer%, ByVal nTenths&)
   Call timeoutSetMils(nTimer, nTenths * 100)
End Sub


'function timeoutSetSecs%(byval nSecs%)
Sub waitEvents(ByVal nmills%)
   Call waitRoutine(nmills, True)
End Sub



Sub waitNoEvents(ByVal nmills%)
   Call waitRoutine(nmills, False)
End Sub



Sub waitRoutine(ByVal nmills%, ByVal events%)
   Dim ct&, diff&

   ct = GetTickCount() + nmills
   Do While True
      diff = GetTickCount() - ct
      If events Then DoEvents
      If diff >= 0 Or diff < -65536 Then Exit Do
   Loop
End Sub

Sub winCenterForm(frm As Form)
   Dim l%, t%
   
   If frm.WindowState = 1 Then Exit Sub
   
   l = (Screen.Width - frm.Width) / 2
   t = (Screen.Height - frm.Height) / 2
   frm.Left = l: frm.Top = t
End Sub

Function tstr(ByVal v)
   tstr = Trim(Str(v))
End Function





Sub winCenterRelative(frmMe As Form, frmOther As Form)
   Dim l%, t%
   
   If frmMe.WindowState = 1 Then Exit Sub
   
   l = frmOther.Left + (frmOther.Width / 2)
   t = frmOther.Top + (frmOther.Height / 2)

   l = l - (frmMe.Width / 2)
   t = t - (frmMe.Height / 2)

   frmMe.Left = l: frmMe.Top = t
End Sub

Function stuq$(ByVal t$)
   stuq$ = UCase$(stq$(t$))
End Function




Function wtrim$(ByVal txt$)
   Dim rval$
   
   rval = txt
   
   Do While Len(rval) > 0
      If Not Asc(Left(rval, 1)) <= 32 Then Exit Do
      rval = Right(rval, Len(rval) - 1)
   Loop

   Do While Len(rval) > 0
      If Not Asc(Right(rval, 1)) <= 32 Then Exit Do
      rval = Left(rval, Len(rval) - 1)
   Loop

   wtrim = rval
End Function

Function iniGetBool%(sect$, entry$, def%, INIFile$)
   Dim a$

   a$ = stu(IniGetData(sect$, entry$, IIf(def, "True", "False"), INIFile$))
   If InStr("YT", Left(a$, 1)) > 0 Or Val(a$) <> 0 Then
      iniGetBool = True
   Else
      iniGetBool = False
   End If
End Function


Function IniGetData$(sect$, entry$, def$, INIFile$)
   Dim a$, i&
   a$ = Space(256)
   i = GetPrivateProfileStringA(sect$, entry$, def$, a$, 256, INIFile)
   a$ = Left(a$, i)
   IniGetData = a$
End Function



Sub iniPutBool(sect$, entry$, v%, INIFile$)
   Dim a$
   a$ = IIf(v, "True", "False")
   Call iniPutData(sect$, entry$, a$, INIFile$)
End Sub



Sub iniPutData(sect$, entry$, dat$, INIFile$)
   Dim i%

   sect$ = Trim(sect$)
   entry$ = Trim(entry$)
   dat$ = Trim(dat$)

   i = WritePrivateProfileStringA(sect$, entry$, dat$, INIFile$)
End Sub


Function itoh$(ByVal dat%, ByVal nplaces%)
   itoh = Right$(String$(nplaces, "0") + Hex(dat), nplaces)
End Function



Function max(a, b)
   max = IIf(a < b, b, a)
End Function



Function min(a, b)
   min = IIf(a < b, a, b)
End Function



Function padc$(ByVal txt$, i%)
   Dim w%, a$
   If Len(txt) > i Then txt = Left(txt, i)
   w = (i - Len(txt)) / 2
   a$ = Space(w) + txt
   a$ = a$ + Space(i - Len(a$))
   padc = a$
End Function

Function padl$(ByVal t$, l%)
   If Len(t$) < l Then t$ = Space(l - Len(t$)) + t$
   padl$ = t$
End Function



Function padr$(ByVal t$, l%)
   If Len(t$) < l Then t$ = t$ + Space(l - Len(t$))
   padr$ = t$
End Function



Function dtor#(ByVal degrees#)
   dtor = (degrees / 180) * PI
End Function



Function stq$(ByVal t$)
   t$ = Trim$(t$)
   If Left$(t$, 1) <> "'" Then t$ = "'" + t$
   If Right$(t$, 1) <> "'" Then t$ = t$ + "'"
   stq$ = t$
End Function


Function stu$(ByVal t$)
   stu$ = UCase$(Trim$(t$))
End Function




