/*
 * @(#)HelloServlet.java
 *
 * Copyright (c) 1998-1999 Servertec. All Rights Reserved.
 *
 * This software is the proprietary and confidential property of Servertec.
 * Use only in accordance with the terms of the license agreement.
 *
 * SERVERTEC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY
 * OF THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
 * TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SERVERTEC SHALL NOT BE LIABLE FOR ANY
 * DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR
 * DISTRIBUTING THIS SOFTWARE OR ITS DERIVATIVES.
 *
 * THIS NOTICE MUST NOT BE ALTERED NOR REMOVED.
 *
 * CopyrightVersion 1.0
 */

import java.io.IOException;

import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletException;

import stec.lang.DString;

import stec.iws.Utils;

public class HelloServlet extends HttpServlet
{
    public void service(HttpServletRequest _request, HttpServletResponse _response) throws ServletException, IOException
    {
        _response.setContentType("text/html");

        ServletOutputStream out = _response.getOutputStream();

        String name;

        String qs = _request.getQueryString();
        
        if(qs == null)
        {
            name = "";
        }
        else
        {
            String args = Utils.getArgs(_request);
            if(args == null)
            {
                name = "";
            }    
            else 
            {
                name = DString.extract(args, " ", 1);
                if(name == null)
                {
                    name = "";
                }    
            }    
        }

        out.println("<html>");
        out.println("<head><title>Hello " + name + "</title></head>");
        out.println("<body>");
        out.println("<h1>Hello " + name + "</h1>");
        out.println("</body>");
        out.println("</html>");
        out.close();
    }

    public String getServletInfo()
    {
        return "HelloServlet";
    }
}
