/*
 * Decompiled with CFR 0.152.
 */
package stec.iws;

import java.io.IOException;
import java.util.Hashtable;
import javax.servlet.ServletException;
import stec.iws.AdminContext;
import stec.iws.AdminUtils;
import stec.iws.IOManager;
import stec.iws.Utils;
import stec.iws.iws;
import stec.lang.DString;

public class AdminServlets {
    private static final String _ = "Copyright (c) 1998-2000 Servertec. All rights reserved.";

    protected static void displayServletEntry(AdminContext adminContext) throws IOException, ServletException {
        adminContext.setForm("servlet_entry");
        Hashtable hashtable = adminContext.data;
        String string = adminContext.template;
        string = Utils.getItem(IOManager.getHandler(iws.basedir, string));
        string = DString.replace(string, "%error_message%", adminContext.error_message.toString());
        Object object = hashtable.get("alias");
        if (object == null) {
            object = "";
        }
        string = DString.replace(string, "%alias%", (String)object);
        object = hashtable.get("class_file");
        if (object == null) {
            object = "";
        }
        string = DString.replace(string, "%class_file%", (String)object);
        object = hashtable.get("parameters");
        if (object == null) {
            object = "";
        }
        string = DString.replace(string, "%parameters%", (String)object);
        object = hashtable.get("preload");
        if (object == null) {
            object = "n";
        }
        if (((String)object).equalsIgnoreCase("y")) {
            string = DString.replace(string, "%preload_n%", "");
            string = DString.replace(string, "%preload_y%", "CHECKED");
        } else {
            string = DString.replace(string, "%preload_y%", "");
            string = DString.replace(string, "%preload_n%", "CHECKED");
        }
        object = hashtable.get("key");
        if (object == null) {
            object = "";
        }
        string = DString.replace(string, "%key%", (String)object);
        AdminUtils.sendItem(adminContext.response, string);
    }

    protected static void displayServlets(AdminContext adminContext) throws IOException, ServletException {
        adminContext.setForm("servlets");
        AdminUtils.displayList(adminContext);
    }

    protected static void doServletEntry(AdminContext adminContext) throws IOException, ServletException {
        adminContext.setForm("servlet_entry");
        String string = AdminUtils.getAction(adminContext);
        if (string == null) {
            if (AdminServlets.verifyServletEntry(adminContext)) {
                AdminServlets.updateServletEntry(adminContext);
                adminContext.setForm("servlets");
                AdminUtils.displayList(adminContext);
                return;
            }
        } else {
            if (string.equals("help")) {
                AdminUtils.help(adminContext, "servlets", "#entry");
                return;
            }
            if (string.equals("ok")) {
                if (AdminServlets.verifyServletEntry(adminContext)) {
                    AdminServlets.updateServletEntry(adminContext);
                    adminContext.setForm("servlets");
                    AdminUtils.displayList(adminContext);
                    return;
                }
            } else if (string.equals("cancel")) {
                adminContext.setForm("servlets");
                AdminUtils.displayList(adminContext);
                return;
            }
        }
        AdminServlets.displayServletEntry(adminContext);
    }

    protected static void doServlets(AdminContext adminContext) throws IOException, ServletException {
        adminContext.setForm("servlets");
        if (AdminUtils.doListAction(adminContext)) {
            return;
        }
        if (adminContext.action.equals("add")) {
            AdminServlets.displayServletEntry(adminContext);
            return;
        }
        if (adminContext.action.equals("edit")) {
            if (AdminUtils.doEdit(adminContext)) {
                AdminServlets.parseServletEntry(adminContext);
                AdminServlets.displayServletEntry(adminContext);
                return;
            }
        } else {
            if (adminContext.action.equals("load")) {
                String string = adminContext.request.getParameter("key");
                if (string == null) {
                    adminContext.error_message.append("An entry was not selected.");
                } else {
                    String string2 = string;
                    if (string2.length() == 0) {
                        adminContext.error_message.append("An entry was not selected.");
                    } else if (!iws.servlets.containsKey(string2)) {
                        adminContext.error_message.append("Unable to find entry: ");
                        adminContext.error_message.append(string2);
                    } else {
                        try {
                            if (iws.servletManager.loadServlet(string2) == null) {
                                adminContext.error_message.append("Servlet was not found: ");
                                adminContext.error_message.append(string2);
                            }
                        }
                        catch (Exception exception) {
                            adminContext.error_message.append("Error while loading ");
                            adminContext.error_message.append("Servlet: ");
                            adminContext.error_message.append(string2);
                            adminContext.error_message.append(": ");
                            adminContext.error_message.append(exception.toString());
                        }
                    }
                }
                AdminUtils.displayList(adminContext);
                return;
            }
            if (adminContext.action.equals("unload")) {
                String string = adminContext.request.getParameter("key");
                if (string == null) {
                    adminContext.error_message.append("An entry was not selected.");
                } else {
                    String string3 = string;
                    if (string3.length() == 0) {
                        adminContext.error_message.append("An entry was not selected.");
                    } else if (iws.servletManager.servletContexts.containsKey(string3)) {
                        try {
                            iws.servletManager.unloadServlet(string3);
                        }
                        catch (Exception exception) {
                            iws.logger.log(exception);
                            adminContext.error_message.append("Error while unloading");
                            adminContext.error_message.append("Servlet: ");
                            adminContext.error_message.append(string3);
                            adminContext.error_message.append(": ");
                            adminContext.error_message.append(exception.toString());
                        }
                    }
                }
                AdminUtils.displayList(adminContext);
                return;
            }
            if (adminContext.action.equals("reload")) {
                String string = adminContext.request.getParameter("key");
                if (string == null) {
                    adminContext.error_message.append("An entry was not selected.");
                } else {
                    String string4 = string;
                    if (string4.length() == 0) {
                        adminContext.error_message.append("An entry was not selected.");
                    } else if (!iws.servlets.containsKey(string4)) {
                        adminContext.error_message.append("Unable to find entry: ");
                        adminContext.error_message.append(string4);
                    } else {
                        if (iws.servletManager.servletContexts.containsKey(string4)) {
                            try {
                                iws.servletManager.unloadServlet(string4);
                            }
                            catch (Exception exception) {
                                iws.logger.log(exception);
                                adminContext.error_message.append("Error while unloading");
                                adminContext.error_message.append("Servlet: ");
                                adminContext.error_message.append(string4);
                                adminContext.error_message.append(": ");
                                adminContext.error_message.append(exception.toString());
                            }
                        }
                        try {
                            if (iws.servletManager.loadServlet(string4) == null) {
                                adminContext.error_message.append("Servlet was not found: ");
                                adminContext.error_message.append(string4);
                            }
                        }
                        catch (Exception exception) {
                            adminContext.error_message.append("Error while loading ");
                            adminContext.error_message.append("Servlet: ");
                            adminContext.error_message.append(string4);
                            adminContext.error_message.append(": ");
                            adminContext.error_message.append(exception.toString());
                        }
                    }
                }
                AdminUtils.displayList(adminContext);
                return;
            }
            AdminUtils.displayList(adminContext);
        }
    }

    protected static Hashtable getServletEntry(AdminContext adminContext, Hashtable hashtable) {
        Object v = hashtable.get("key");
        if (v == null) {
            return hashtable;
        }
        String string = (String)v;
        hashtable.put("key", string);
        hashtable.put("alias", string);
        String string2 = (String)hashtable.get("entry");
        int n = string2.indexOf(63);
        if (n == -1) {
            hashtable.put("class_file", string2);
        } else {
            hashtable.put("class_file", string2.substring(0, n));
            String string3 = string2.substring(n + 1);
            string3 = DString.replace(string3, "&", "\n");
            hashtable.put("parameters", string3);
        }
        if (AdminUtils.isPreloaded(adminContext.session, "servlets", string)) {
            hashtable.put("preload", "y");
        } else {
            hashtable.put("preload", "n");
        }
        return hashtable;
    }

    protected static void parseServletEntry(AdminContext adminContext) {
        Hashtable hashtable = adminContext.data;
        AdminServlets.getServletEntry(adminContext, hashtable);
    }

    protected static void updateServletEntry(AdminContext adminContext) throws IOException, ServletException {
        String string;
        Hashtable hashtable = adminContext.data;
        String string2 = (String)hashtable.get("alias");
        String string3 = (String)hashtable.get("class_file");
        Object v = hashtable.get("parameters");
        if (v != null && (string = DString.trim((String)v)).length() > 0) {
            string = DString.replace(string, "\n", "&");
            string = DString.replace(string, "\r", "");
            string3 = String.valueOf(string3) + "?" + string;
        }
        string = (String)hashtable.get("preload");
        AdminUtils.updatePreloaded(adminContext.session, "servlets", string2, string.equalsIgnoreCase("y"));
        hashtable = AdminUtils.getSessionData(adminContext, "servlets");
        hashtable.put(string2, string3);
        AdminUtils.putSessionData(adminContext, "servlets", hashtable);
    }

    protected static boolean verifyServletEntry(AdminContext adminContext) throws IOException, ServletException {
        String string;
        Hashtable hashtable = AdminServlets.getServletEntry(adminContext, AdminUtils.getFormData(adminContext, "servlets"));
        adminContext.error_message.setLength(0);
        Hashtable hashtable2 = adminContext.data;
        String string2 = "";
        String string3 = adminContext.request.getParameter("key");
        if (string3 != null) {
            string2 = string3;
            hashtable2.put("key", string2);
        }
        if ((string3 = adminContext.request.getParameter("alias")) == null) {
            adminContext.error_message.append("Alias is required.<br>");
            string3 = hashtable.get("alias");
            if (string3 != null) {
                hashtable2.put("alias", string3);
            }
        } else {
            string = DString.trim(string3);
            if (string.length() == 0) {
                adminContext.error_message.append("Alias is required.<br>");
                string3 = hashtable.get("alias");
                if (string3 != null) {
                    hashtable2.put("alias", string3);
                }
            } else if (string2.equals(string)) {
                hashtable2.put("alias", string);
            } else if (AdminUtils.getFormEntry(adminContext, "servlets", string) != null) {
                adminContext.error_message.append("Servlet already exists.<br>");
                string3 = hashtable.get("alias");
                if (string3 != null) {
                    hashtable2.put("alias", string3);
                }
            } else {
                hashtable2.put("alias", string);
            }
        }
        if ((string3 = adminContext.request.getParameter("class_file")) == null) {
            adminContext.error_message.append("Class File is required.<br>");
            string3 = hashtable.get("class_file");
            if (string3 != null) {
                hashtable2.put("class_file", string3);
            }
        } else {
            string = DString.trim(string3);
            if (string.length() == 0) {
                adminContext.error_message.append("Class File is required.<br>");
                string3 = hashtable.get("class_file");
                if (string3 != null) {
                    hashtable2.put("class_file", string3);
                }
            } else {
                hashtable2.put("class_file", string3);
            }
        }
        if ((string3 = adminContext.request.getParameter("parameters")) != null) {
            hashtable2.put("parameters", string3);
        }
        if ((string3 = adminContext.request.getParameter("preload")) == null) {
            string3 = "n";
        }
        hashtable2.put("preload", string3);
        return adminContext.error_message.length() <= 0;
    }
}

