/*
 * Decompiled with CFR 0.152.
 */
package javax.media.pim;

import java.util.Vector;
import javax.media.pim.PlugInInfo;

class PlugInVector {
    private Vector elements;

    public PlugInVector(int initialCapacity) {
        this.elements = new Vector(initialCapacity, 0);
    }

    public final synchronized void addElement(PlugInInfo pii) {
        int i2 = 0;
        while (i2 < this.elements.size()) {
            PlugInInfo current = (PlugInInfo)this.elements.elementAt(i2);
            if (current.hashValue == pii.hashValue && !current.className.equals(pii.className)) {
                System.err.println("Problem adding " + pii.className + " to plugin table.");
                System.err.println(" Already hash value of " + pii.hashValue + " in plugin table for class name of " + current.className);
                break;
            }
            if (current.hashValue > pii.hashValue) break;
            ++i2;
        }
        this.elements.insertElementAt(pii, i2);
    }

    public final synchronized boolean removeElement(PlugInInfo pii) {
        return this.elements.removeElement(pii);
    }

    public final synchronized PlugInInfo lookup(int type, String className, long hashValue) {
        PlugInInfo current = null;
        int low = 0;
        int high = this.elements.size();
        int mid = 0;
        block0: while (low <= high) {
            mid = (low + high) / 2;
            current = (PlugInInfo)this.elements.elementAt(mid);
            if (hashValue < current.hashValue) {
                high = mid - 1;
                continue;
            }
            if (hashValue > current.hashValue) {
                low = mid + 1;
                continue;
            }
            if (type == current.type && className.equals(current.className)) {
                return current;
            }
            int i2 = 0;
            do {
                current = (PlugInInfo)this.elements.elementAt(mid - i2);
                if (hashValue != current.hashValue) break;
                if (type != current.type || !className.equals(current.className)) continue;
                return current;
            } while (mid - ++i2 >= 0);
            i2 = 0;
            do {
                current = (PlugInInfo)this.elements.elementAt(mid + i2);
                if (hashValue != current.hashValue) continue block0;
                if (type != current.type || !className.equals(current.className)) continue;
                return current;
            } while (mid + ++i2 < this.elements.size());
        }
        return null;
    }
}

