/*
 * Decompiled with CFR 0.152.
 */
package javax.media;

import javax.media.Format;
import javax.media.MediaLocator;
import javax.media.protocol.ContentDescriptor;
import javax.media.protocol.DataSource;

public class ProcessorModel {
    private Format[] formats;
    private MediaLocator inputLocator;
    private DataSource inputDataSource;
    private ContentDescriptor outputContentDescriptor;

    public ProcessorModel() {
    }

    public ProcessorModel(Format[] formats, ContentDescriptor outputContentDescriptor) {
        this.outputContentDescriptor = outputContentDescriptor;
        this.formats = formats;
    }

    public ProcessorModel(DataSource inputDataSource, Format[] formats, ContentDescriptor outputContentDescriptor) {
        this.inputDataSource = inputDataSource;
        this.formats = formats;
        this.outputContentDescriptor = outputContentDescriptor;
    }

    public ProcessorModel(MediaLocator inputLocator, Format[] formats, ContentDescriptor outputContentDescriptor) {
        this.inputLocator = inputLocator;
        this.formats = formats;
        this.outputContentDescriptor = outputContentDescriptor;
    }

    public int getTrackCount(int availableTrackCount) {
        if (this.formats != null) {
            return this.formats.length;
        }
        return -1;
    }

    public Format getOutputTrackFormat(int tIndex) {
        if (this.formats != null && this.formats.length > tIndex) {
            return this.formats[tIndex];
        }
        return null;
    }

    public boolean isFormatAcceptable(int tIndex, Format tFormat) {
        if (this.formats != null && this.formats.length > tIndex) {
            return tFormat.matches(this.formats[tIndex]);
        }
        return true;
    }

    public ContentDescriptor getContentDescriptor() {
        return this.outputContentDescriptor;
    }

    public DataSource getInputDataSource() {
        return this.inputDataSource;
    }

    public MediaLocator getInputLocator() {
        return this.inputLocator;
    }
}

