/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.util;

import com.sun.media.util.DynamicPlugIn;
import com.sun.media.util.Registry;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.media.CaptureDeviceInfo;
import javax.media.CaptureDeviceManager;
import javax.media.Codec;
import javax.media.Demultiplexer;
import javax.media.Effect;
import javax.media.Format;
import javax.media.Multiplexer;
import javax.media.PlugInManager;
import javax.media.Renderer;

public class RegistryGen {
    static String arname;
    static String pkgname;
    static String destdir;
    static String[] names;
    static DataOutputStream ds;
    static byte[] properties;
    private static String filename;
    private static Format[] emptyFormat;
    static String[] nativePlugins;
    static String[] defaultPlugins;

    static void printUsage() {
        System.err.println("java RegistryGen [-d <destdir>] <registrylib> ");
    }

    static void writeClass() {
        boolean accBytes = false;
        try {
            ds.writeBytes("/* Generated by RegistryGen.\n   DO NOT EDIT.*/\n\n");
            if (pkgname != null) {
                ds.writeBytes("package ");
                ds.writeBytes(pkgname);
                ds.writeBytes(";\n\n");
            }
            ds.writeBytes("public abstract class ");
            ds.writeBytes(arname);
            ds.writeBytes(" {\n\n");
            if (properties.length > 0) {
                ds.writeBytes("   public static byte[] getData(){\n");
                ds.writeBytes("       int i;\n");
                ds.writeBytes("       byte[] b= new byte[" + properties.length + "];\n");
                ds.writeBytes("       for (i=0;i<b.length;i++)\n");
                ds.writeBytes("          b[i] = (byte)(s.charAt(i)-1);\n");
                ds.writeBytes("       return b;\n");
                ds.writeBytes("    }\n");
            } else {
                ds.writeBytes("   public static byte[] getData(){\n");
                ds.writeBytes("       return null;\n");
                ds.writeBytes("    }\n");
            }
            ds.writeBytes("    private static String s = \n        ");
            ds.writeBytes("\"");
            int len = properties.length;
            int j2 = 0;
            while (j2 < len) {
                ds.writeBytes("\\" + RegistryGen.byte2oct((byte)(1 + properties[j2])));
                if (j2 % 16 == 15) {
                    ds.writeBytes("\"+\n        \"");
                }
                ++j2;
            }
            ds.writeBytes("\";\n\n");
            ds.writeBytes("}\n");
        }
        catch (IOException iOException) {}
    }

    private static String byte2oct(byte b2) {
        int i2 = b2 & 0xFF;
        int dig3 = i2 % 8;
        int dig2 = i2 / 8 % 8;
        int dig1 = i2 / 64;
        return dig1 + "" + dig2 + "" + dig3;
    }

    private static void registerPlugIn(String className) {
        try {
            int type;
            Class<?> pic = Class.forName(className);
            Object instance = pic.newInstance();
            Format[] inputs = null;
            Format[] outputs = null;
            if (instance instanceof Demultiplexer) {
                type = 1;
                inputs = ((Demultiplexer)instance).getSupportedInputContentDescriptors();
                outputs = emptyFormat;
            } else if (instance instanceof Codec) {
                type = 2;
                inputs = ((Codec)instance).getSupportedInputFormats();
                outputs = ((Codec)instance).getSupportedOutputFormats(null);
            } else if (instance instanceof Renderer) {
                type = 4;
                inputs = ((Renderer)instance).getSupportedInputFormats();
                outputs = emptyFormat;
            } else if (instance instanceof Multiplexer) {
                type = 5;
                inputs = emptyFormat;
                outputs = ((Multiplexer)instance).getSupportedOutputContentDescriptors(null);
            } else if (instance instanceof Effect) {
                type = 3;
                inputs = ((Effect)instance).getSupportedInputFormats();
                outputs = ((Effect)instance).getSupportedOutputFormats(null);
            } else {
                type = 0;
            }
            if (instance instanceof DynamicPlugIn) {
                inputs = ((DynamicPlugIn)instance).getBaseInputFormats();
                outputs = ((DynamicPlugIn)instance).getBaseOutputFormats();
            }
            if (type != 0) {
                boolean result = PlugInManager.addPlugIn(className, inputs, outputs, type);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (Exception exception) {}
    }

    private static void deletePlugins(int type) {
        Vector v = PlugInManager.getPlugInList(null, null, type);
        Enumeration eClassNames = v.elements();
        while (eClassNames.hasMoreElements()) {
            String className = (String)eClassNames.nextElement();
            PlugInManager.removePlugIn(className, type);
        }
    }

    static void registerPlugIns(String[] plugins) {
        if (plugins == null) {
            return;
        }
        RegistryGen.deletePlugins(1);
        RegistryGen.deletePlugins(2);
        RegistryGen.deletePlugins(4);
        RegistryGen.deletePlugins(5);
        RegistryGen.deletePlugins(3);
        int i2 = 0;
        while (i2 < plugins.length) {
            RegistryGen.registerPlugIn(plugins[i2]);
            ++i2;
        }
        try {
            PlugInManager.commit();
        }
        catch (Exception exception) {
            System.err.println("can't commit PlugInManager");
        }
    }

    static void registerCaptureDevices(CaptureDeviceInfo[] cdis) {
        int i2 = 0;
        while (i2 < cdis.length) {
            CaptureDeviceManager.addDevice(cdis[i2]);
            ++i2;
        }
        try {
            CaptureDeviceManager.commit();
        }
        catch (IOException iOException) {
            System.err.println("can't commit CaptureDeviceManager");
        }
    }

    private static boolean readProperties() {
        String classpath = null;
        try {
            classpath = System.getProperty("java.class.path");
        }
        catch (Exception exception) {
            filename = null;
            return false;
        }
        StringTokenizer tokens = new StringTokenizer(classpath, File.pathSeparator);
        String strJMF = "jmf.properties";
        File file = null;
        while (tokens.hasMoreTokens()) {
            String dir = tokens.nextToken();
            String caps = dir.toUpperCase();
            try {
                if (caps.indexOf(".ZIP") > 0 || caps.indexOf(".JAR") > 0) {
                    int sep = dir.lastIndexOf(File.separator);
                    if (sep == -1 && !File.separator.equals("/")) {
                        sep = dir.lastIndexOf("/");
                    }
                    dir = sep == -1 ? ((sep = dir.lastIndexOf(":")) == -1 ? strJMF : String.valueOf(dir.substring(0, sep)) + ":" + strJMF) : String.valueOf(dir.substring(0, sep)) + File.separator + strJMF;
                } else {
                    dir = String.valueOf(dir) + File.separator + strJMF;
                }
            }
            catch (Exception exception) {
                dir = String.valueOf(dir) + File.separator + strJMF;
            }
            try {
                file = new File(dir);
                if (!file.exists()) continue;
                filename = dir;
                break;
            }
            catch (Throwable throwable) {
                filename = null;
                return false;
            }
        }
        try {
            if (filename == null || file == null) {
                return false;
            }
            if (file.length() == 0L) {
                return false;
            }
        }
        catch (Throwable throwable) {
            return false;
        }
        try {
            FileInputStream fis = new FileInputStream(filename);
            DataInputStream dis = new DataInputStream(fis);
            int len = dis.available();
            properties = new byte[len];
            dis.read(properties, 0, len);
            dis.close();
            fis.close();
        }
        catch (IOException ioe) {
            System.err.println("IOException in readProperties: " + ioe);
            return false;
        }
        return true;
    }

    public static void main(String[] args) {
        names = new String[args.length + 1];
        int i2 = 0;
        int j2 = 0;
        while (i2 < args.length) {
            if (args[i2].equals("-d")) {
                if (i2++ >= args.length) {
                    RegistryGen.printUsage();
                    return;
                }
                destdir = args[i2];
            } else {
                RegistryGen.names[j2++] = args[i2];
            }
            ++i2;
        }
        RegistryGen.names[j2] = null;
        if (j2 == 0) {
            RegistryGen.printUsage();
            return;
        }
        i2 = names[0].lastIndexOf(".");
        if (i2 == -1) {
            pkgname = null;
            arname = names[0];
        } else {
            pkgname = names[0].substring(0, i2);
            arname = names[0].substring(i2 + 1);
        }
        String filename = null;
        try {
            filename = destdir == null ? String.valueOf(arname) + ".java" : String.valueOf(destdir) + File.separator + arname + ".java";
            ds = new DataOutputStream(new FileOutputStream(filename));
        }
        catch (IOException e2) {
            System.err.println("Cannot open file: " + filename + e2);
        }
        RegistryGen.registerPlugIns(defaultPlugins);
        if (!RegistryGen.readProperties()) {
            System.err.println("Cannot read jmf.properties");
            System.exit(0);
        }
        RegistryGen.writeClass();
    }

    static {
        properties = null;
        filename = null;
        emptyFormat = new Format[0];
        String fileSeparator = System.getProperty("file.separator");
        Registry.set("secure.allowCaching", new Boolean(true));
        Registry.set("secure.maxCacheSizeMB", new Integer(250));
        if (fileSeparator.equals("/")) {
            Registry.set("secure.cacheDir", "/tmp");
        } else {
            Registry.set("secure.cacheDir", "C:" + fileSeparator + "temp");
        }
        Registry.set("secure.allowSaveFileFromApplets", new Boolean(false));
        Registry.set("secure.allowCaptureFromApplets", new Boolean(false));
        try {
            Registry.commit();
        }
        catch (Exception exception) {}
        nativePlugins = new String[]{"com.ibm.media.codec.video.mpeg.MpegVideo", "com.sun.media.codec.video.cinepak.NativeDecoder", "com.sun.media.codec.video.h261.NativeDecoder", "com.sun.media.codec.video.vh263.NativeDecoder", "com.sun.media.codec.video.jpeg.NativeDecoder", "com.sun.media.codec.video.IV32Decoder", "com.sun.media.codec.video.vcm.NativeDecoder", "com.sun.media.codec.video.vcm.NativeEncoder", "com.ibm.media.codec.audio.g723.NativeDecoder", "com.ibm.media.codec.audio.gsm.NativeDecoder", "com.ibm.media.codec.audio.gsm.NativeDecoder_ms", "com.ibm.media.codec.audio.ACMCodec", "com.sun.media.codec.video.jpeg.NativeEncoder", "com.ibm.media.codec.video.h263.NativeEncoder", "com.ibm.media.codec.audio.g723.NativeEncoder", "com.ibm.media.codec.audio.gsm.NativeEncoder", "com.sun.media.codec.audio.mpa.NativeDecoder", "com.ibm.media.codec.audio.mpegenc.NativeEncoder", "com.sun.media.codec.video.colorspace.YUVToRGB", "com.sun.media.renderer.video.DDRenderer", "com.sun.media.renderer.video.GDIRenderer", "com.sun.media.renderer.video.XILRenderer", "com.sun.media.renderer.audio.JavaSoundRenderer"};
        defaultPlugins = new String[]{"com.ibm.media.parser.video.MpegParser", "com.sun.media.parser.audio.WavParser", "com.sun.media.parser.audio.AuParser", "com.sun.media.parser.audio.AiffParser", "com.sun.media.parser.audio.GsmParser", "com.sun.media.parser.RawStreamParser", "com.sun.media.parser.RawBufferParser", "com.sun.media.parser.RawPullStreamParser", "com.sun.media.parser.RawPullBufferParser", "com.sun.media.parser.video.QuicktimeParser", "com.sun.media.parser.video.AviParser", "com.sun.media.codec.audio.mpa.JavaDecoder", "com.sun.media.codec.video.cinepak.JavaDecoder", "com.ibm.media.codec.video.h263.JavaDecoder", "com.sun.media.codec.video.colorspace.JavaRGBConverter", "com.sun.media.codec.video.colorspace.JavaRGBToYUV", "com.ibm.media.codec.audio.PCMToPCM", "com.ibm.media.codec.audio.rc.RCModule", "com.sun.media.codec.audio.msadpcm.JavaDecoder", "com.ibm.media.codec.audio.ulaw.JavaDecoder", "com.ibm.media.codec.audio.alaw.JavaDecoder", "com.ibm.media.codec.audio.dvi.JavaDecoder", "com.ibm.media.codec.audio.g723.JavaDecoder", "com.ibm.media.codec.audio.gsm.JavaDecoder", "com.ibm.media.codec.audio.gsm.JavaDecoder_ms", "com.ibm.media.codec.audio.ima4.JavaDecoder", "com.ibm.media.codec.audio.ima4.JavaDecoder_ms", "com.ibm.media.codec.audio.ulaw.JavaEncoder", "com.ibm.media.codec.audio.dvi.JavaEncoder", "com.ibm.media.codec.audio.gsm.JavaEncoder", "com.ibm.media.codec.audio.gsm.JavaEncoder_ms", "com.ibm.media.codec.audio.ima4.JavaEncoder", "com.ibm.media.codec.audio.ima4.JavaEncoder_ms", "com.sun.media.codec.audio.ulaw.Packetizer", "com.sun.media.codec.audio.ulaw.DePacketizer", "com.ibm.media.codec.audio.gsm.Packetizer", "com.ibm.media.codec.audio.g723.Packetizer", "com.sun.media.codec.video.jpeg.Packetizer", "com.sun.media.codec.video.jpeg.DePacketizer", "com.sun.media.renderer.audio.SunAudioRenderer", "com.sun.media.renderer.video.AWTRenderer", "com.sun.media.renderer.video.LightWeightRenderer", "com.sun.media.renderer.video.JPEGRenderer", "com.sun.media.multiplexer.RawSyncBufferMux", "com.sun.media.multiplexer.RTPSyncBufferMux", "com.sun.media.multiplexer.RawBufferMux", "com.sun.media.multiplexer.audio.GSMMux", "com.sun.media.multiplexer.audio.MPEGMux", "com.sun.media.multiplexer.audio.WAVMux", "com.sun.media.multiplexer.audio.AIFFMux", "com.sun.media.multiplexer.audio.AUMux", "com.sun.media.multiplexer.video.AVIMux", "com.sun.media.multiplexer.video.QuicktimeMux"};
    }
}

