/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.ui;

import com.sun.media.controls.ProgressControl;
import com.sun.media.controls.SliderRegionControl;
import com.sun.media.ui.AudioButton;
import com.sun.media.ui.BasicComp;
import com.sun.media.ui.BufferedPanel;
import com.sun.media.ui.BufferedPanelLight;
import com.sun.media.ui.ButtonComp;
import com.sun.media.ui.GainControlComponent;
import com.sun.media.ui.ProgressSlider2;
import com.sun.media.ui.PropertySheet2;
import com.sun.media.ui.TransparentPanel;
import com.sun.media.ui.VolumeDisplay;
import java.awt.BorderLayout;
import java.awt.CheckboxMenuItem;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.ItemSelectable;
import java.awt.MenuItem;
import java.awt.PopupMenu;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.peer.ComponentPeer;
import java.awt.peer.LightweightPeer;
import java.util.Vector;
import javax.media.Control;
import javax.media.ControllerEvent;
import javax.media.ControllerListener;
import javax.media.Duration;
import javax.media.DurationUpdateEvent;
import javax.media.Format;
import javax.media.GainChangeEvent;
import javax.media.GainChangeListener;
import javax.media.GainControl;
import javax.media.MediaTimeSetEvent;
import javax.media.Player;
import javax.media.RateChangeEvent;
import javax.media.StartEvent;
import javax.media.StopEvent;
import javax.media.Time;
import javax.media.control.FramePositioningControl;
import javax.media.control.TrackControl;
import javax.media.format.AudioFormat;
import javax.media.format.VideoFormat;

public class DefaultControlPanel2
extends BufferedPanelLight
implements ActionListener,
ItemListener,
ControllerListener,
GainChangeListener,
ComponentListener {
    static final Color colorBackground = new Color(192, 192, 192);
    private static final String MENU_PROPERTIES = "Properties";
    private static final String MENU_RATE_1_4 = "Rate 1:4";
    private static final String MENU_RATE_1_2 = "Rate 1:2";
    private static final String MENU_RATE_1_1 = "Rate 1:1";
    private static final String MENU_RATE_2_1 = "Rate 2:1";
    private static final String MENU_RATE_4_1 = "Rate 4:1";
    private static final String MENU_RATE_8_1 = "Rate 8:1";
    Player player;
    Frame parentFrame;
    Container container;
    TransparentPanel panelLeft;
    TransparentPanel panelRight;
    TransparentPanel panelProgress;
    boolean boolAdded = false;
    ButtonComp buttonPlay;
    ButtonComp buttonStepBack;
    ButtonComp buttonStepFwd;
    ButtonComp buttonAudio;
    ButtonComp buttonMedia;
    ProgressSlider2 progressSlider;
    WindowListener wl;
    private boolean firstTime = true;
    private boolean started = false;
    private Integer localLock = new Integer(0);
    GainControlComponent audioControls;
    VolumeDisplay volumeDisplay;
    PropertySheet2 propsSheet;
    FramePositioningControl controlFrame;
    ProgressControl progressControl;
    GainControl gainControl;
    SliderRegionControl regionControl;
    String urlName;
    long lFrameStep;
    private CheckboxMenuItem menuRate_1_4;
    private CheckboxMenuItem menuRate_1_2;
    private CheckboxMenuItem menuRate_1_1;
    private CheckboxMenuItem menuRate_2_1;
    private CheckboxMenuItem menuRate_4_1;
    private CheckboxMenuItem menuRate_8_1;
    private Vector vectorTracksAudio = new Vector();
    private Vector vectorTracksVideo = new Vector();

    public DefaultControlPanel2(Player player) {
        this.player = player;
        try {
            this.init();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void addNotify() {
        boolean boolLightweight = true;
        if (!this.boolAdded) {
            Container containerParent = this.getParent();
            while (containerParent != null && boolLightweight) {
                ComponentPeer compPeer = containerParent.getPeer();
                if ((containerParent = containerParent.getParent()) == null) break;
                if (compPeer == null || compPeer instanceof LightweightPeer) continue;
                boolLightweight = false;
            }
            if (this.container != null) {
                this.container.remove(this.panelLeft);
                this.container.remove(this.panelRight);
                this.container.remove(this.panelProgress);
                if (this.container != this) {
                    this.remove(this.container);
                }
            }
            if (boolLightweight) {
                this.container = this;
            } else {
                this.container = new BufferedPanel(new BorderLayout());
                this.container.setBackground(colorBackground);
                ((BufferedPanel)this.container).setBackgroundTile(BasicComp.fetchImage("texture3.gif"));
                this.add((Component)this.container, "Center");
            }
            this.container.add((Component)this.panelLeft, "West");
            this.container.add((Component)this.panelRight, "East");
            this.container.add((Component)this.panelProgress, "Center");
            this.boolAdded = true;
        }
        super.addNotify();
        this.validate();
    }

    public void removeNotify() {
        super.removeNotify();
        if (this.boolAdded) {
            this.boolAdded = false;
        }
    }

    private void init() throws Exception {
        TrackControl trackControl;
        this.getPlayerControls();
        if (this.gainControl != null) {
            this.gainControl.addGainChangeListener(this);
        }
        this.setBackground(colorBackground);
        this.setLayout(new BorderLayout());
        this.addComponentListener(this);
        this.container = this;
        this.panelLeft = new TransparentPanel(new GridLayout(1, 0));
        this.container.add((Component)this.panelLeft, "West");
        this.panelRight = new TransparentPanel(new GridLayout(1, 0));
        this.container.add((Component)this.panelRight, "East");
        this.panelProgress = new TransparentPanel(new BorderLayout());
        this.container.add((Component)this.panelProgress, "Center");
        this.buttonPlay = new ButtonComp("Play", "play.gif", "play-active.gif", "play-pressed.gif", "play-disabled.gif", "pause.gif", "pause-active.gif", "pause-pressed.gif", "pause-disabled.gif");
        this.buttonPlay.setActionListener(this);
        this.panelLeft.add(this.buttonPlay);
        if (this.controlFrame != null) {
            this.buttonStepBack = new ButtonComp("StepBack", "step-back.gif", "step-back-active.gif", "step-back-pressed.gif", "step-back-disabled.gif", "step-back.gif", "step-back-active.gif", "step-back-pressed.gif", "step-back-disabled.gif");
            this.buttonStepBack.setActionListener(this);
            this.buttonStepBack.setContMousePress(true);
            this.panelLeft.add(this.buttonStepBack);
            this.buttonStepFwd = new ButtonComp("StepForward", "step-fwd.gif", "step-fwd-active.gif", "step-fwd-pressed.gif", "step-fwd-disabled.gif", "step-fwd.gif", "step-fwd-active.gif", "step-fwd-pressed.gif", "step-fwd-disabled.gif");
            this.buttonStepFwd.setActionListener(this);
            this.buttonStepFwd.setContMousePress(true);
            this.panelLeft.add(this.buttonStepFwd);
        }
        if (this.gainControl != null) {
            this.buttonAudio = new AudioButton(this.gainControl);
            this.buttonAudio.setActionListener(this);
            this.panelRight.add(this.buttonAudio);
        }
        this.buttonMedia = new ButtonComp("Media", "media.gif", "media-active.gif", "media-pressed.gif", "media-disabled.gif", "media.gif", "media-active.gif", "media-pressed.gif", "media-disabled.gif");
        this.buttonMedia.setActionListener(this);
        this.panelRight.add(this.buttonMedia);
        this.progressSlider = new ProgressSlider2("mediatime", this, this.player);
        this.progressSlider.setActionListener(this);
        this.panelProgress.add((Component)this.progressSlider, "Center");
        Time duration = this.player.getDuration();
        if (duration == Duration.DURATION_UNBOUNDED || duration == Duration.DURATION_UNKNOWN) {
            this.progressSlider.setEnabled(false);
        }
        this.updateButtonState();
        this.validate();
        Dimension dim = this.getPreferredSize();
        this.setSize(dim);
        this.setVisible(true);
        this.setBackgroundTile(BasicComp.fetchImage("texture3.gif"));
        this.player.addControllerListener(this);
        Control[] arrControls = this.player.getControls();
        int nCount = arrControls.length;
        int i2 = 0;
        while (i2 < nCount) {
            if (arrControls[i2] instanceof TrackControl) {
                trackControl = (TrackControl)arrControls[i2];
                Format format = trackControl.getFormat();
                if (format instanceof AudioFormat) {
                    this.vectorTracksAudio.addElement(trackControl);
                } else if (format instanceof VideoFormat) {
                    this.vectorTracksVideo.addElement(trackControl);
                    VideoFormat formatVideo = (VideoFormat)format;
                    float frameRate = formatVideo.getFrameRate();
                    this.lFrameStep = (long)(1.0E9f / frameRate);
                }
            }
            ++i2;
        }
        PopupMenu menuPopup = new PopupMenu("Media");
        this.buttonMedia.setPopupMenu(menuPopup);
        nCount = this.vectorTracksAudio.size();
        if (nCount > 1) {
            boolean boolEnable = true;
            i2 = 0;
            while (i2 < nCount) {
                trackControl = (TrackControl)this.vectorTracksAudio.elementAt(i2);
                if (i2 > 0) {
                    boolEnable = false;
                }
                CheckboxMenuItem menuItemCheck = new CheckboxMenuItem("Audio " + i2, boolEnable);
                this.muteAudioTrack(trackControl, !boolEnable);
                menuItemCheck.addItemListener(this);
                menuPopup.add(menuItemCheck);
                ++i2;
            }
            menuPopup.addSeparator();
        }
        this.menuRate_1_4 = new CheckboxMenuItem(MENU_RATE_1_4, false);
        this.menuRate_1_4.addItemListener(this);
        menuPopup.add(this.menuRate_1_4);
        this.menuRate_1_2 = new CheckboxMenuItem(MENU_RATE_1_2, false);
        this.menuRate_1_2.addItemListener(this);
        menuPopup.add(this.menuRate_1_2);
        this.menuRate_1_1 = new CheckboxMenuItem(MENU_RATE_1_1, true);
        this.menuRate_1_1.addItemListener(this);
        menuPopup.add(this.menuRate_1_1);
        this.menuRate_2_1 = new CheckboxMenuItem(MENU_RATE_2_1, false);
        this.menuRate_2_1.addItemListener(this);
        menuPopup.add(this.menuRate_2_1);
        this.menuRate_4_1 = new CheckboxMenuItem(MENU_RATE_4_1, false);
        this.menuRate_4_1.addItemListener(this);
        menuPopup.add(this.menuRate_4_1);
        this.menuRate_8_1 = new CheckboxMenuItem(MENU_RATE_8_1, false);
        this.menuRate_8_1.addItemListener(this);
        menuPopup.add(this.menuRate_8_1);
        menuPopup.addSeparator();
        MenuItem menuItem = new MenuItem(MENU_PROPERTIES);
        menuItem.addActionListener(this);
        menuPopup.add(menuItem);
    }

    private void updateButtonState() {
        if (this.player == null) {
            this.buttonPlay.setEnabled(false);
        } else {
            this.buttonPlay.setEnabled(true);
            if (this.player.getState() == 600) {
                this.buttonPlay.setValue(true);
            } else {
                this.buttonPlay.setValue(false);
            }
        }
    }

    public void minicleanUp() {
        Integer n2 = this.localLock;
        synchronized (n2) {
            this.firstTime = true;
            if (this.volumeDisplay != null) {
                this.volumeDisplay.dispose();
                this.volumeDisplay = null;
            }
        }
    }

    public void cleanUp() {
        Integer n2 = this.localLock;
        synchronized (n2) {
            if (this.propsSheet != null) {
                this.propsSheet.dispose();
                this.propsSheet = null;
            }
            if (this.volumeDisplay != null) {
                this.volumeDisplay.dispose();
                this.volumeDisplay = null;
            }
            if (this.progressSlider != null) {
                this.progressSlider.dispose();
                this.progressSlider = null;
            }
            if (this.audioControls != null) {
                this.remove(this.audioControls);
                this.audioControls = null;
            }
            this.player = null;
            this.gainControl = null;
            if (this.parentFrame != null && this.wl != null) {
                this.parentFrame.removeWindowListener(this.wl);
                this.parentFrame = null;
                this.wl = null;
            }
        }
    }

    public void dispose() {
        Integer n2 = this.localLock;
        synchronized (n2) {
            this.cleanUp();
        }
    }

    private void getPlayerControls() {
        if (this.player == null) {
            return;
        }
        this.gainControl = this.player.getGainControl();
        Control control = this.player.getControl("javax.media.control.FramePositioningControl");
        if (control != null && control instanceof FramePositioningControl) {
            this.controlFrame = (FramePositioningControl)control;
        }
    }

    public void actionPerformed(ActionEvent ae) {
        String command = ae.getActionCommand();
        if (command.equalsIgnoreCase(this.buttonPlay.getLabel())) {
            this.playStop();
        }
        if (this.buttonAudio != null && command.equalsIgnoreCase(this.buttonAudio.getLabel())) {
            this.audioMute();
        } else if (command.equalsIgnoreCase(this.buttonMedia.getLabel()) || command.equalsIgnoreCase(MENU_PROPERTIES)) {
            this.showPropsSheet();
        } else if (this.buttonStepBack != null && command.equalsIgnoreCase(this.buttonStepBack.getLabel())) {
            this.playStep(false);
        } else if (this.buttonStepFwd != null && command.equalsIgnoreCase(this.buttonStepFwd.getLabel())) {
            this.playStep(true);
        }
    }

    public void itemStateChanged(ItemEvent event) {
        ItemSelectable item = event.getItemSelectable();
        Object objectItem = event.getItem();
        if (item == this.menuRate_1_4) {
            this.player.setRate(0.25f);
            this.menuRate_1_4.setState(false);
        } else if (item == this.menuRate_1_2) {
            this.player.setRate(0.5f);
            this.menuRate_1_2.setState(false);
        } else if (item == this.menuRate_1_1) {
            this.player.setRate(1.0f);
            this.menuRate_1_1.setState(false);
        } else if (item == this.menuRate_2_1) {
            this.player.setRate(2.0f);
            this.menuRate_2_1.setState(false);
        } else if (item == this.menuRate_4_1) {
            this.player.setRate(4.0f);
            this.menuRate_4_1.setState(false);
        } else if (item == this.menuRate_8_1) {
            this.player.setRate(8.0f);
            this.menuRate_8_1.setState(false);
        } else if (objectItem instanceof String) {
            String strItem = (String)objectItem;
            if (strItem.substring(0, 5).equalsIgnoreCase("Audio")) {
                int nIndex = Integer.valueOf(strItem.substring(6));
                TrackControl trackControl = (TrackControl)this.vectorTracksAudio.elementAt(nIndex);
                boolean boolEnabled = event.getStateChange() == 1;
                this.muteAudioTrack(trackControl, !boolEnabled);
            } else {
                strItem.substring(0, 5).equalsIgnoreCase("Video");
            }
        }
    }

    void update() {
        if (this.propsSheet != null) {
            this.propsSheet.update();
        }
    }

    private void playStop() {
        boolean state = this.buttonPlay.getValue();
        Integer n2 = this.localLock;
        synchronized (n2) {
            block12: {
                block11: {
                    if (this.player == null) break block11;
                    if (this.buttonPlay != null) break block12;
                }
                Object var3_3 = null;
                return;
            }
            if (state) {
                if (this.player.getTargetState() != 600) {
                    this.buttonPlay.setEnabled(false);
                    this.player.start();
                }
            } else if (this.player.getTargetState() == 600) {
                this.buttonPlay.setEnabled(false);
                this.player.stop();
            }
        }
    }

    private void audioMute() {
        if (this.gainControl == null) {
            return;
        }
        boolean boolState = this.buttonAudio.getValue();
        this.gainControl.setMute(boolState);
    }

    private void playStep(boolean boolFwd) {
        if (this.controlFrame == null) {
            return;
        }
        if (this.player.getTargetState() == 600) {
            this.buttonPlay.setEnabled(false);
            this.player.stop();
        }
        this.controlFrame.skip(boolFwd ? 1 : -1);
    }

    public void controllerUpdate(ControllerEvent ce) {
        Integer n2 = this.localLock;
        synchronized (n2) {
            if (this.player == null) {
                Object var3_3 = null;
                return;
            }
            if (ce instanceof StartEvent) {
                this.buttonPlay.setValue(true);
                this.buttonPlay.setEnabled(true);
                if (this.buttonStepFwd != null) {
                    this.buttonStepFwd.setEnabled(true);
                }
                if (this.buttonStepBack != null) {
                    this.buttonStepBack.setEnabled(true);
                }
            } else if (ce instanceof StopEvent) {
                this.buttonPlay.setValue(false);
                this.buttonPlay.setEnabled(true);
            } else if (ce instanceof DurationUpdateEvent) {
                Time duration = this.player.getDuration();
                if (duration == Duration.DURATION_UNKNOWN || duration == Duration.DURATION_UNBOUNDED) {
                    this.progressSlider.setEnabled(false);
                } else {
                    this.progressSlider.setEnabled(true);
                }
                if (this.propsSheet != null) {
                    this.propsSheet.updateDuration();
                }
            } else if (ce instanceof MediaTimeSetEvent) {
                Thread.yield();
                long lDuration = this.player.getDuration().getNanoseconds();
                long lMedia = this.player.getMediaNanoseconds();
                if (this.buttonStepFwd != null) {
                    if (lMedia < lDuration - 1L) {
                        this.buttonStepFwd.setEnabled(true);
                    } else {
                        this.buttonStepFwd.setEnabled(false);
                    }
                }
                if (this.buttonStepFwd != null) {
                    if (lMedia > 0L) {
                        this.buttonStepBack.setEnabled(true);
                    } else {
                        this.buttonStepBack.setEnabled(false);
                    }
                }
            } else if (ce instanceof RateChangeEvent) {
                this.menuRate_1_4.setState(false);
                this.menuRate_1_2.setState(false);
                this.menuRate_1_1.setState(false);
                this.menuRate_2_1.setState(false);
                this.menuRate_4_1.setState(false);
                this.menuRate_8_1.setState(false);
                float fRate = this.player.getRate();
                if ((double)fRate < 0.5) {
                    this.menuRate_1_4.setState(true);
                } else if ((double)fRate < 1.0) {
                    this.menuRate_1_2.setState(true);
                } else if ((double)fRate > 4.0) {
                    this.menuRate_8_1.setState(true);
                } else if ((double)fRate > 2.0) {
                    this.menuRate_4_1.setState(true);
                } else if ((double)fRate > 1.0) {
                    this.menuRate_2_1.setState(true);
                } else {
                    this.menuRate_1_1.setState(true);
                }
            }
        }
    }

    public void gainChange(GainChangeEvent event) {
        boolean boolMute = this.gainControl.getMute();
        this.buttonAudio.setValue(boolMute);
    }

    public void componentResized(ComponentEvent e2) {
        this.validate();
    }

    public void componentMoved(ComponentEvent e2) {
    }

    public void componentShown(ComponentEvent e2) {
    }

    public void componentHidden(ComponentEvent e2) {
    }

    public void paint(Graphics g2) {
        if (this.firstTime) {
            this.findFrame();
        }
        super.paint(g2);
    }

    protected void findFrame() {
        Integer n2 = this.localLock;
        synchronized (n2) {
            if (this.firstTime) {
                this.firstTime = false;
                Container c2 = this.getParent();
                while (!(c2 instanceof Frame) && c2 != null) {
                    c2 = c2.getParent();
                }
                if (c2 instanceof Frame) {
                    this.parentFrame = (Frame)c2;
                    this.wl = new 1();
                    ((Frame)c2).addWindowListener(this.wl);
                    if (this.gainControl != null && this.audioControls != null && this.volumeDisplay == null) {
                        try {
                            this.volumeDisplay = new VolumeDisplay(this.gainControl, this.parentFrame);
                            ((Component)this.volumeDisplay).setVisible(false);
                            this.volumeDisplay.addNotify();
                            this.audioControls.setVolumeDisplay(this.volumeDisplay);
                        }
                        catch (Exception exception) {}
                    }
                }
            }
        }
    }

    public Insets getInsets() {
        Insets insets = new Insets(1, 0, 0, 0);
        return insets;
    }

    private void showPropsSheet() {
        if (this.propsSheet == null) {
            try {
                this.propsSheet = new PropertySheet2(this.parentFrame, this.player);
            }
            catch (Exception exception) {
                this.propsSheet = null;
            }
        }
        if (this.propsSheet != null) {
            ((Component)this.propsSheet).setVisible(true);
        }
    }

    private void muteAudioTrack(TrackControl trackControl, boolean boolMute) {
        Object[] arrControls = trackControl.getControls();
        int nCount = arrControls.length;
        int i2 = 0;
        while (i2 < nCount) {
            if (arrControls[i2] instanceof GainControl) {
                ((GainControl)arrControls[i2]).setMute(boolMute);
            }
            ++i2;
        }
    }

    private final class 1
    extends WindowAdapter {
        public void windowClosing(WindowEvent we) {
            DefaultControlPanel2.this.minicleanUp();
        }

        /* synthetic */ 1() {
        }
    }
}

