/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.rtp.util;

import com.ms.security.PermissionID;
import com.ms.security.PolicyEngine;
import com.sun.media.JMFSecurity;
import com.sun.media.JMFSecurityManager;
import com.sun.media.rtp.util.Packet;
import com.sun.media.rtp.util.PacketConsumer;
import com.sun.media.rtp.util.UDPPacket;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.MulticastSocket;

public class UDPPacketSender
implements PacketConsumer {
    private DatagramSocket sock;
    private InetAddress address;
    private int port;
    private int ttl;
    private static JMFSecurity jmfSecurity = null;
    private static boolean securityPrivelege;
    private Method[] m = new Method[1];
    private Class[] cl = new Class[1];
    private Object[][] args = new Object[1][0];

    public UDPPacketSender(DatagramSocket sock) {
        this.sock = sock;
    }

    public UDPPacketSender() throws IOException {
        this(new DatagramSocket());
    }

    public UDPPacketSender(int localPort) throws IOException {
        this(new DatagramSocket(localPort));
    }

    public UDPPacketSender(InetAddress remoteAddress, int remotePort) throws IOException {
        if (remoteAddress.isMulticastAddress()) {
            MulticastSocket sock = new MulticastSocket();
            this.sock = sock;
        } else {
            this.sock = new DatagramSocket();
        }
        this.setRemoteAddress(remoteAddress, remotePort);
    }

    public InetAddress getLocalAddress() {
        return this.sock.getLocalAddress();
    }

    public UDPPacketSender(int localPort, InetAddress localAddress, InetAddress remoteAddress, int remotePort) throws IOException {
        if (remoteAddress.isMulticastAddress()) {
            MulticastSocket sock = new MulticastSocket(localPort);
            if (localAddress != null) {
                sock.setInterface(localAddress);
            }
            this.sock = sock;
        } else {
            this.sock = localAddress != null ? new DatagramSocket(localPort, localAddress) : new DatagramSocket(localPort);
        }
        this.setRemoteAddress(remoteAddress, remotePort);
    }

    public void setRemoteAddress(InetAddress remoteAddress, int remotePort) {
        this.address = remoteAddress;
        this.port = remotePort;
    }

    public void setttl(int ttl) throws IOException {
        this.ttl = ttl;
        if (this.sock instanceof MulticastSocket) {
            ((MulticastSocket)this.sock).setTTL((byte)this.ttl);
        }
    }

    public int getLocalPort() {
        return this.sock.getLocalPort();
    }

    public void sendTo(Packet p2) throws IOException {
        InetAddress addr = null;
        int port = 0;
        if (p2 instanceof UDPPacket) {
            UDPPacket udpp = (UDPPacket)p2;
            addr = udpp.remoteAddress;
            port = udpp.remotePort;
            if (udpp.remoteAddress.isMulticastAddress() && jmfSecurity != null) {
                try {
                    if (jmfSecurity.getName().startsWith("jmf-security")) {
                        jmfSecurity.requestPermission(this.m, this.cl, this.args, 512);
                        this.m[0].invoke((Object)this.cl[0], this.args[0]);
                    } else if (jmfSecurity.getName().startsWith("internet")) {
                        PolicyEngine.checkPermission((PermissionID)PermissionID.NETIO);
                        PolicyEngine.assertPermission((PermissionID)PermissionID.NETIO);
                    }
                }
                catch (Throwable e2) {
                    jmfSecurity.permissionFailureNotification(512);
                }
            }
        }
        if (addr == null) {
            throw new IllegalArgumentException("No address set");
        }
        this.send(p2, addr, port);
    }

    public void send(Packet p2, InetAddress addr, int port) throws IOException {
        byte[] data = p2.data;
        if (p2.offset > 0) {
            byte[] byArray = data;
            data = new byte[p2.length];
            System.arraycopy(byArray, p2.offset, data, 0, p2.length);
        }
        DatagramPacket dp = new DatagramPacket(data, p2.length, addr, port);
        this.sock.send(dp);
    }

    public void closeConsumer() {
        if (this.sock != null) {
            this.sock.close();
            this.sock = null;
        }
    }

    public String consumerString() {
        String s = "UDP Datagram Packet Sender on port " + this.sock.getLocalPort();
        if (this.address != null) {
            s = String.valueOf(s) + " sending to address " + this.address + ", port " + this.port + ", ttl" + this.ttl;
        }
        return s;
    }

    static {
        try {
            jmfSecurity = JMFSecurityManager.getJMFSecurity();
            securityPrivelege = true;
        }
        catch (SecurityException securityException) {}
    }
}

