/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.protocol.file;

import com.ms.security.PermissionID;
import com.ms.security.PolicyEngine;
import com.sun.media.JMFSecurity;
import com.sun.media.JMFSecurityManager;
import com.sun.media.util.ContentType;
import com.sun.media.util.JMFI18N;
import com.sun.media.util.jdk12;
import com.sun.media.util.jdk12RandomAccessFileAction;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import javax.media.MediaLocator;
import javax.media.Time;
import javax.media.protocol.ContentDescriptor;
import javax.media.protocol.PullDataSource;
import javax.media.protocol.PullSourceStream;
import javax.media.protocol.Seekable;
import javax.media.protocol.SourceCloneable;

public class DataSource
extends PullDataSource
implements SourceCloneable {
    private RandomAccessFile raf;
    private boolean connected = false;
    private long length = -1L;
    private String contentType;
    private PullSourceStream[] pssArray = new PullSourceStream[1];
    private static JMFSecurity jmfSecurity = null;
    private static boolean securityPrivelege;
    private Method[] m = new Method[1];
    private Class[] cl = new Class[1];
    private Object[][] args = new Object[1][0];

    public String getContentType() {
        if (!this.connected) {
            return null;
        }
        return this.contentType;
    }

    public void connect() throws IOException {
        URL url;
        if (this.connected) {
            return;
        }
        MediaLocator locator = this.getLocator();
        if (locator == null) {
            System.err.println("medialocator is null");
            throw new IOException(String.valueOf(this) + ": connect() failed");
        }
        try {
            url = locator.getURL();
        }
        catch (MalformedURLException malformedURLException) {
            System.err.println(String.valueOf(this.getLocator()) + ": Don't know how to deal with non-URL locator yet!");
            throw new IOException(String.valueOf(this) + ": connect() failed");
        }
        try {
            String fileName;
            if (jmfSecurity != null) {
                try {
                    if (jmfSecurity.getName().startsWith("jmf-security")) {
                        jmfSecurity.requestPermission(this.m, this.cl, this.args, 2);
                        this.m[0].invoke((Object)this.cl[0], this.args[0]);
                    } else if (jmfSecurity.getName().startsWith("internet")) {
                        PolicyEngine.checkPermission((PermissionID)PermissionID.FILEIO);
                        PolicyEngine.assertPermission((PermissionID)PermissionID.FILEIO);
                    }
                }
                catch (Throwable e2) {
                    jmfSecurity.permissionFailureNotification(2);
                    throw new IOException("No permissions to read file");
                }
            }
            String saved = fileName = locator.getRemainder();
            try {
                int idx = 0;
                while ((idx = fileName.indexOf("%", idx)) >= 0) {
                    if (fileName.length() > idx + 2) {
                        byte[] bytes = new byte[1];
                        try {
                            bytes[0] = (byte)Integer.valueOf(fileName.substring(idx + 1, idx + 3), 16).intValue();
                            fileName = String.valueOf(fileName.substring(0, idx)) + new String(bytes) + fileName.substring(idx + 3);
                        }
                        catch (NumberFormatException numberFormatException) {}
                    }
                    ++idx;
                }
                idx = 0;
                while ((idx = fileName.indexOf("|")) >= 0) {
                    fileName = idx > 0 ? String.valueOf(fileName.substring(0, idx)) + ":" + fileName.substring(idx + 1) : fileName.substring(1);
                }
                while (fileName.charAt(0) == '/' && (fileName.charAt(1) == '/' || fileName.charAt(2) == ':')) {
                    fileName = fileName.substring(1);
                }
            }
            catch (Exception exception) {
                fileName = saved;
            }
            if (jmfSecurity != null && jmfSecurity.getName().startsWith("jdk12")) {
                try {
                    Constructor cons = jdk12RandomAccessFileAction.cons;
                    this.raf = (RandomAccessFile)jdk12.doPrivM.invoke((Object)jdk12.ac, cons.newInstance(fileName, "r"));
                }
                catch (Throwable throwable) {
                    throw new IOException(JMFI18N.getResource("error.filenotfound"));
                }
            } else {
                this.raf = new RandomAccessFile(fileName, "r");
            }
            this.length = this.raf.length();
            if (this.length < 0L) {
                this.length = -1L;
            }
            RAFPullSourceStream pss = new RAFPullSourceStream();
            this.pssArray[0] = pss;
            URLConnection urlC = url.openConnection();
            this.contentType = urlC.getContentType();
            this.contentType = ContentType.getCorrectedContentType(this.contentType, locator.getRemainder());
            this.contentType = ContentDescriptor.mimeTypeToPackageName(this.contentType);
            this.connected = true;
        }
        catch (Throwable throwable) {
            throw new IOException(JMFI18N.getResource("error.filenotfound"));
        }
    }

    public void disconnect() {
        try {
            if (this.raf != null) {
                this.raf.close();
            }
        }
        catch (IOException iOException) {}
        if (this.pssArray != null) {
            this.pssArray[0] = null;
        }
        this.connected = false;
    }

    public void start() throws IOException {
    }

    public void stop() throws IOException {
    }

    public void setLocator(MediaLocator ml) {
        if (ml != null && ml.getProtocol() != null && ml.getProtocol().equals("file")) {
            MediaLocator saved = ml;
            String file = ml.getRemainder();
            boolean changed = false;
            if (file == null) {
                super.setLocator(ml);
                return;
            }
            try {
                int idx = 0;
                while ((idx = file.indexOf("%", idx)) >= 0) {
                    if (file.length() > idx + 2) {
                        byte[] bytes = new byte[1];
                        try {
                            bytes[0] = (byte)Integer.valueOf(file.substring(idx + 1, idx + 3), 16).intValue();
                            file = String.valueOf(file.substring(0, idx)) + new String(bytes) + file.substring(idx + 3);
                            changed = true;
                        }
                        catch (NumberFormatException numberFormatException) {}
                    }
                    ++idx;
                }
                if (changed) {
                    ml = new MediaLocator(String.valueOf(ml.getProtocol()) + ":" + file);
                }
            }
            catch (Exception exception) {
                ml = saved;
            }
        }
        super.setLocator(ml);
    }

    public PullSourceStream[] getStreams() {
        return this.pssArray;
    }

    public Time getDuration() {
        return null;
    }

    public Object[] getControls() {
        return new Object[0];
    }

    public Object getControl(String controlType) {
        return null;
    }

    public javax.media.protocol.DataSource createClone() {
        DataSource ds = new DataSource();
        ds.setLocator(this.getLocator());
        if (this.connected) {
            try {
                ds.connect();
            }
            catch (IOException iOException) {
                return null;
            }
        }
        return ds;
    }

    static {
        try {
            jmfSecurity = JMFSecurityManager.getJMFSecurity();
            securityPrivelege = true;
        }
        catch (SecurityException securityException) {}
    }

    class RAFPullSourceStream
    implements PullSourceStream,
    Seekable {
        public long seek(long where) {
            try {
                DataSource.this.raf.seek(where);
                return this.tell();
            }
            catch (IOException e2) {
                System.out.println("seek: " + e2);
                return -1L;
            }
        }

        public long tell() {
            try {
                return DataSource.this.raf.getFilePointer();
            }
            catch (IOException e2) {
                System.out.println("tell: " + e2);
                return -1L;
            }
        }

        public boolean isRandomAccess() {
            return true;
        }

        public boolean willReadBlock() {
            return false;
        }

        public int read(byte[] buffer, int offset, int length) throws IOException {
            return DataSource.this.raf.read(buffer, offset, length);
        }

        public ContentDescriptor getContentDescriptor() {
            return null;
        }

        public long getContentLength() {
            return DataSource.this.length;
        }

        public boolean endOfStream() {
            return false;
        }

        public Object[] getControls() {
            return new Object[0];
        }

        public Object getControl(String controlType) {
            return null;
        }

        RAFPullSourceStream() {
            DataSource.this = DataSource.this;
        }
    }
}

