/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.controls;

import com.sun.media.Reparentable;
import com.sun.media.ui.TextComp;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.media.control.FrameRateControl;

public class FrameRateAdapter
implements FrameRateControl,
ActionListener,
Reparentable {
    protected float value;
    protected float min;
    protected float max;
    protected TextComp textComp;
    protected boolean settable;
    protected Object owner;

    public FrameRateAdapter(float initialFrameRate, float minFrameRate, float maxFrameRate, boolean settable) {
        this.value = initialFrameRate;
        this.min = minFrameRate;
        this.max = maxFrameRate;
        this.settable = settable;
    }

    public FrameRateAdapter(Object owner, float initialFrameRate, float minFrameRate, float maxFrameRate, boolean settable) {
        this(initialFrameRate, minFrameRate, maxFrameRate, settable);
        this.owner = owner;
    }

    public float getFrameRate() {
        return this.value;
    }

    public float setFrameRate(float newFrameRate) {
        if (this.settable) {
            if (newFrameRate < this.min) {
                newFrameRate = this.min;
            } else if (newFrameRate > this.max) {
                newFrameRate = this.max;
            }
            this.value = newFrameRate;
            if (this.textComp != null) {
                this.textComp.setValue(Float.toString(this.value));
            }
            return this.value;
        }
        return -1.0f;
    }

    public float getMaxSupportedFrameRate() {
        return this.max;
    }

    public float getPreferredFrameRate() {
        return this.min;
    }

    protected String getName() {
        return "Frame Rate";
    }

    public void setEnabled(boolean enable) {
        if (this.textComp != null) {
            this.textComp.setEnabled(enable);
        }
    }

    public Component getControlComponent() {
        if (this.textComp == null) {
            this.textComp = new TextComp(this.getName(), String.valueOf(this.value), 2, this.settable);
            this.textComp.setActionListener(this);
        }
        return this.textComp;
    }

    public void actionPerformed(ActionEvent ae) {
        System.out.println("fra:");
        float newFrameRate = this.textComp.getFloatValue();
        this.setFrameRate(newFrameRate);
    }

    public Object getOwner() {
        if (this.owner == null) {
            return this;
        }
        return this.owner;
    }

    public void setOwner(Object newOwner) {
        this.owner = newOwner;
    }
}

