/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;

public class HtmlPanel
extends JPanel
implements HyperlinkListener {
    JEditorPane html;
    public URL currentURL;
    private JTextComponent viewingComponent;
    public static ImageIcon busyIcon = null;
    public static ImageIcon stoppedIcon = null;
    public static JButton iconState = null;

    public HtmlPanel(String string) {
        this.setLayout(new BorderLayout());
        this.getAccessibleContext().setAccessibleName("HTML panel");
        this.getAccessibleContext().setAccessibleDescription("A panel for viewing HTML documents, and following their links");
        try {
            URL uRL = new URL(string);
            this.html = new JEditorPane(uRL);
        }
        catch (MalformedURLException malformedURLException) {
            System.out.println("Malformed URL: " + malformedURLException);
        }
        catch (IOException iOException) {
            System.out.println("O NO... IOException: " + iOException);
        }
        this.html.setEditable(false);
        this.html.addHyperlinkListener(this);
        JScrollPane jScrollPane = new JScrollPane();
        JViewport jViewport = jScrollPane.getViewport();
        jViewport.add(this.html);
        jViewport.setBackingStoreEnabled(true);
        this.add((Component)jScrollPane, "Center");
    }

    public void setBusyStateIndicator(JButton jButton) {
        iconState = jButton;
    }

    public void setNotBusyIndicator(ImageIcon imageIcon) {
        stoppedIcon = imageIcon;
    }

    public void setBusyIndicator(ImageIcon imageIcon) {
        busyIcon = imageIcon;
    }

    public void registerHyperLinkViewer(JTextComponent jTextComponent) {
        this.viewingComponent = jTextComponent;
    }

    public void showNotBusy() {
        iconState.setIcon(stoppedIcon);
        busyIcon.setImageObserver(null);
        stoppedIcon.setImageObserver(iconState);
    }

    public void showBusy() {
        iconState.setIcon(busyIcon);
        stoppedIcon.setImageObserver(null);
        busyIcon.setImageObserver(iconState);
    }

    public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
        if (hyperlinkEvent.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
            this.currentURL = hyperlinkEvent.getURL();
            this.linkActivated(this.currentURL);
            this.viewingComponent.setText(this.currentURL.toString());
        }
    }

    protected void linkActivated(URL uRL) {
        this.showBusy();
        Cursor cursor = this.html.getCursor();
        Cursor cursor2 = Cursor.getPredefinedCursor(3);
        this.html.setCursor(cursor2);
        SwingUtilities.invokeLater(new PageLoader(uRL, cursor));
    }

    class PageLoader
    implements Runnable {
        URL url;
        Cursor cursor;

        PageLoader(URL uRL, Cursor cursor) {
            HtmlPanel.this = HtmlPanel.this;
            this.url = uRL;
            this.cursor = cursor;
        }

        public void run() {
            if (this.url == null) {
                HtmlPanel.this.html.setCursor(this.cursor);
                Container container = HtmlPanel.this.html.getParent();
                container.repaint();
                return;
            }
            Document document = HtmlPanel.this.html.getDocument();
            try {
                try {
                    HtmlPanel.this.html.setPage(this.url);
                }
                catch (IOException iOException) {
                    HtmlPanel.this.html.setDocument(document);
                    HtmlPanel.this.getToolkit().beep();
                }
                Object var3_3 = null;
                this.url = null;
                HtmlPanel.this.showNotBusy();
            }
            catch (Throwable throwable) {
                Object var3_4 = null;
                this.url = null;
                HtmlPanel.this.showNotBusy();
                SwingUtilities.invokeLater(this);
                throw throwable;
            }
            SwingUtilities.invokeLater(this);
        }
    }
}

