/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.ui;

import com.sun.media.ui.VideoSize;
import java.awt.BorderLayout;
import java.awt.Checkbox;
import java.awt.Choice;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Vector;
import javax.media.Format;
import javax.media.format.RGBFormat;
import javax.media.format.VideoFormat;
import javax.media.format.YUVFormat;

public class VideoFormatChooser
extends Panel
implements ItemListener {
    public static final String ACTION_TRACK_ENABLED = "ACTION_VIDEO_TRACK_ENABLED";
    public static final String ACTION_TRACK_DISABLED = "ACTION_VIDEO_TRACK_DISABLED";
    private VideoFormat formatOld;
    private Format[] arrSupportedFormats;
    private float[] customFrameRates;
    private Vector vectorContSuppFormats = new Vector();
    private boolean boolDisplayEnableTrack;
    private ActionListener listenerEnableTrack;
    private boolean boolEnableTrackSaved = true;
    private Checkbox checkEnableTrack;
    private Label labelEncoding;
    private Choice comboEncoding;
    private Label labelSize;
    private Choice comboSize;
    private Label labelFrameRate;
    private Choice comboFrameRate;
    private Label labelExtra;
    private Choice comboExtra;

    public VideoFormatChooser(Format[] arrFormats, VideoFormat formatDefault, float[] frameRates) {
        this(arrFormats, formatDefault, false, null, frameRates);
    }

    public VideoFormatChooser(Format[] arrFormats, VideoFormat formatDefault) {
        this(arrFormats, formatDefault, false, null, null);
    }

    public VideoFormatChooser(Format[] arrFormats, VideoFormat formatDefault, boolean boolDisplayEnableTrack, ActionListener listenerEnableTrack) {
        this(arrFormats, formatDefault, boolDisplayEnableTrack, listenerEnableTrack, null);
    }

    public VideoFormatChooser(Format[] arrFormats, VideoFormat formatDefault, boolean boolDisplayEnableTrack, ActionListener listenerEnableTrack, float[] frameRates) {
        this.arrSupportedFormats = arrFormats;
        this.boolDisplayEnableTrack = boolDisplayEnableTrack;
        this.listenerEnableTrack = listenerEnableTrack;
        this.customFrameRates = frameRates;
        int nCount = this.arrSupportedFormats.length;
        int i2 = 0;
        while (i2 < nCount) {
            if (this.arrSupportedFormats[i2] instanceof VideoFormat) {
                this.vectorContSuppFormats.addElement(this.arrSupportedFormats[i2]);
            }
            ++i2;
        }
        this.formatOld = this.isFormatSupported(formatDefault) ? formatDefault : null;
        try {
            this.init();
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    public void setEnabled(boolean boolEnable) {
        super.setEnabled(boolEnable);
        this.checkEnableTrack.setEnabled(boolEnable);
        this.enableControls(boolEnable);
    }

    public Format getFormat() {
        String strYuvType = null;
        VideoFormat formatVideo = null;
        String strEncoding = this.comboEncoding.getSelectedItem();
        int nSize = this.vectorContSuppFormats.size();
        int i2 = 0;
        while (i2 < nSize) {
            Object objectFormat = this.vectorContSuppFormats.elementAt(i2);
            if (objectFormat instanceof VideoFormat && this.isFormatGoodForEncoding(formatVideo = (VideoFormat)objectFormat) && this.isFormatGoodForVideoSize(formatVideo) && this.isFormatGoodForFrameRate(formatVideo)) {
                YUVFormat formatYUV;
                int nYuvType;
                if (strEncoding.equalsIgnoreCase("rgb") && formatVideo instanceof RGBFormat) {
                    RGBFormat formatRGB = (RGBFormat)formatVideo;
                    Integer integerBitsPerPixel = new Integer(formatRGB.getBitsPerPixel());
                    String strBitsPerPixel = integerBitsPerPixel.toString();
                    if (this.comboExtra.getSelectedItem().equals(strBitsPerPixel)) break;
                } else if (!strEncoding.equalsIgnoreCase("yuv") || !(formatVideo instanceof YUVFormat) || (strYuvType = this.getYuvType(nYuvType = (formatYUV = (YUVFormat)formatVideo).getYuvType())) != null && this.comboExtra.getSelectedItem().equals(strYuvType)) break;
            }
            ++i2;
        }
        if (i2 >= nSize) {
            formatVideo = null;
        }
        return formatVideo;
    }

    public float getFrameRate() {
        String selection = this.comboFrameRate.getSelectedItem();
        if (selection != null) {
            try {
                float fr = Float.valueOf(selection).floatValue();
                return fr;
            }
            catch (NumberFormatException numberFormatException) {
            }
        }
        return -1.0f;
    }

    public void setCurrentFormat(VideoFormat formatDefault) {
        if (this.isFormatSupported(formatDefault)) {
            this.formatOld = formatDefault;
        }
        this.updateFields(this.formatOld);
    }

    public void setFrameRate(float frameRate) {
        int i2 = 0;
        while (i2 < this.comboFrameRate.getItemCount()) {
            float value = Float.valueOf(this.comboFrameRate.getItem(i2)).floatValue();
            if ((double)Math.abs(frameRate - value) < 0.5) {
                this.comboFrameRate.select(i2);
                return;
            }
            ++i2;
        }
    }

    public void setSupportedFormats(Format[] arrFormats, VideoFormat formatDefault) {
        this.arrSupportedFormats = arrFormats;
        this.vectorContSuppFormats.removeAllElements();
        int nCount = this.arrSupportedFormats.length;
        int i2 = 0;
        while (i2 < nCount) {
            if (this.arrSupportedFormats[i2] instanceof VideoFormat) {
                this.vectorContSuppFormats.addElement(this.arrSupportedFormats[i2]);
            }
            ++i2;
        }
        this.formatOld = this.isFormatSupported(formatDefault) ? formatDefault : null;
        this.setSupportedFormats(this.vectorContSuppFormats);
    }

    public void setSupportedFormats(Vector vectorContSuppFormats) {
        this.vectorContSuppFormats = vectorContSuppFormats;
        if (vectorContSuppFormats.isEmpty()) {
            this.checkEnableTrack.setState(false);
            this.checkEnableTrack.setEnabled(false);
            this.onEnableTrack(true);
            return;
        }
        this.checkEnableTrack.setEnabled(true);
        this.checkEnableTrack.setState(this.boolEnableTrackSaved);
        this.onEnableTrack(true);
        if (!this.isFormatSupported(this.formatOld)) {
            this.formatOld = null;
        }
        this.updateFields(this.formatOld);
    }

    public boolean isTrackEnabled() {
        boolean boolEnabled = this.checkEnableTrack.getState();
        return boolEnabled;
    }

    private void init() throws Exception {
        Panel panel;
        this.setLayout(new BorderLayout(6, 6));
        this.checkEnableTrack = new Checkbox("Enable Track", true);
        this.checkEnableTrack.addItemListener(this);
        if (this.boolDisplayEnableTrack) {
            panel = new Panel(new BorderLayout());
            this.add((Component)panel, "North");
            panel.add((Component)this.checkEnableTrack, "West");
        }
        panel = new Panel(new BorderLayout());
        this.add((Component)panel, "Center");
        Panel panelParam = new Panel(new BorderLayout(6, 6));
        panel.add((Component)panelParam, "North");
        Panel panelLabel = new Panel(new GridLayout(0, 1, 6, 6));
        panelParam.add((Component)panelLabel, "West");
        Panel panelData = new Panel(new GridLayout(0, 1, 6, 6));
        panelParam.add((Component)panelData, "Center");
        this.labelEncoding = new Label("Encoding:", 2);
        panelLabel.add(this.labelEncoding);
        this.comboEncoding = new Choice();
        this.comboEncoding.addItemListener(this);
        panelData.add(this.comboEncoding);
        this.labelSize = new Label("Size:", 2);
        panelLabel.add(this.labelSize);
        this.comboSize = new Choice();
        this.comboSize.addItemListener(this);
        panelData.add(this.comboSize);
        this.labelFrameRate = new Label("Frame Rate:", 2);
        panelLabel.add(this.labelFrameRate);
        this.comboFrameRate = new Choice();
        this.comboFrameRate.addItemListener(this);
        panelData.add(this.comboFrameRate);
        this.labelExtra = new Label("Extra:", 2);
        this.labelExtra.setVisible(false);
        panelLabel.add(this.labelExtra);
        this.comboExtra = new Choice();
        this.comboExtra.setVisible(false);
        panelData.add(this.comboExtra);
        this.updateFields(this.formatOld);
    }

    private void updateFields(VideoFormat formatDefault) {
        String strEncoding;
        String strEncodingPref = null;
        Vector<String> vectorEncoding = new Vector<String>();
        this.comboEncoding.removeAll();
        int nSize = this.vectorContSuppFormats.size();
        int i2 = 0;
        while (i2 < nSize) {
            Object objectFormat = this.vectorContSuppFormats.elementAt(i2);
            if (objectFormat instanceof VideoFormat) {
                VideoFormat formatVideo = (VideoFormat)objectFormat;
                strEncoding = formatVideo.getEncoding().toUpperCase();
                if (strEncodingPref == null) {
                    strEncodingPref = strEncoding;
                }
                if (!vectorEncoding.contains(strEncoding)) {
                    this.comboEncoding.addItem(strEncoding);
                    vectorEncoding.addElement(strEncoding);
                }
            }
            ++i2;
        }
        if (formatDefault != null) {
            strEncoding = formatDefault.getEncoding().toUpperCase();
            this.comboEncoding.select(strEncoding);
        } else if (strEncodingPref != null) {
            this.comboEncoding.select(strEncodingPref);
        } else if (this.comboEncoding.getItemCount() > 0) {
            this.comboEncoding.select(0);
        }
        this.updateFieldsFromEncoding(formatDefault);
    }

    private void updateFieldsFromEncoding(VideoFormat formatDefault) {
        VideoSize sizeVideo;
        Dimension formatVideoSize;
        VideoSize sizeVideoPref = null;
        Vector<VideoSize> vectorSizes = new Vector<VideoSize>();
        this.comboSize.removeAll();
        int nSize = this.vectorContSuppFormats.size();
        int i2 = 0;
        while (i2 < nSize) {
            VideoFormat formatVideo;
            Object objectFormat = this.vectorContSuppFormats.elementAt(i2);
            if (objectFormat instanceof VideoFormat && this.isFormatGoodForEncoding(formatVideo = (VideoFormat)objectFormat)) {
                formatVideoSize = formatVideo.getSize();
                if (formatVideoSize == null) {
                    formatVideoSize = new Dimension(-1, -1);
                }
                sizeVideo = new VideoSize(formatVideoSize);
                if (sizeVideoPref == null) {
                    sizeVideoPref = sizeVideo;
                }
                if (!vectorSizes.contains(sizeVideo)) {
                    this.comboSize.addItem(sizeVideo.toString());
                    vectorSizes.addElement(sizeVideo);
                }
            }
            ++i2;
        }
        if (formatDefault != null && this.isFormatGoodForEncoding(formatDefault)) {
            formatVideoSize = formatDefault.getSize();
            if (formatVideoSize == null) {
                formatVideoSize = new Dimension(-1, -1);
            }
            sizeVideo = new VideoSize(formatVideoSize);
            this.comboSize.select(sizeVideo.toString());
        } else if (sizeVideoPref != null) {
            this.comboSize.select(sizeVideoPref.toString());
        } else if (this.comboSize.getItemCount() > 0) {
            this.comboSize.select(0);
        }
        this.updateFieldsFromSize(formatDefault);
    }

    private void updateFieldsFromSize(VideoFormat formatDefault) {
        Float floatFrameRate;
        int i2;
        Float floatFrameRatePref = null;
        Vector<Float> vectorRates = new Vector<Float>();
        if (this.customFrameRates == null) {
            this.comboFrameRate.removeAll();
        } else if (this.comboFrameRate.getItemCount() < 1) {
            i2 = 0;
            while (i2 < this.customFrameRates.length) {
                this.comboFrameRate.addItem(Float.toString(this.customFrameRates[i2]));
                ++i2;
            }
        }
        int nSize = this.vectorContSuppFormats.size();
        i2 = 0;
        while (i2 < nSize) {
            VideoFormat formatVideo;
            Object objectFormat = this.vectorContSuppFormats.elementAt(i2);
            if (objectFormat instanceof VideoFormat && this.isFormatGoodForEncoding(formatVideo = (VideoFormat)objectFormat) && this.isFormatGoodForVideoSize(formatVideo) && this.customFrameRates == null) {
                floatFrameRate = new Float(formatVideo.getFrameRate());
                if (floatFrameRatePref == null) {
                    floatFrameRatePref = floatFrameRate;
                }
                if (!vectorRates.contains(floatFrameRate)) {
                    this.comboFrameRate.addItem(floatFrameRate.toString());
                    vectorRates.addElement(floatFrameRate);
                }
            }
            ++i2;
        }
        if (formatDefault != null && this.isFormatGoodForEncoding(formatDefault) && this.isFormatGoodForVideoSize(formatDefault)) {
            floatFrameRate = new Float(formatDefault.getFrameRate());
            this.comboFrameRate.select(floatFrameRate.toString());
        } else if (floatFrameRatePref != null) {
            this.comboFrameRate.select(floatFrameRatePref.toString());
        } else if (this.comboFrameRate.getItemCount() > 0) {
            this.comboFrameRate.select(0);
        }
        this.updateFieldsFromRate(formatDefault);
    }

    private void updateFieldsFromRate(VideoFormat formatDefault) {
        YUVFormat formatYUV;
        int nYuvType;
        Integer integerBitsPerPixel;
        RGBFormat formatRGB;
        String strYuvType = null;
        Vector<Object> vectorExtra = new Vector<Object>();
        boolean boolRGB = false;
        boolean boolYUV = false;
        String strEncoding = this.comboEncoding.getSelectedItem();
        if (strEncoding == null) {
            return;
        }
        this.comboExtra.removeAll();
        if (strEncoding.equalsIgnoreCase("rgb")) {
            this.labelExtra.setText("Bits per Pixel:");
            this.labelExtra.setVisible(true);
            this.comboExtra.setVisible(true);
            boolRGB = true;
        } else if (strEncoding.equalsIgnoreCase("yuv")) {
            this.labelExtra.setText("YUV type:");
            this.labelExtra.setVisible(true);
            this.comboExtra.setVisible(true);
            boolYUV = true;
        } else {
            this.labelExtra.setVisible(false);
            this.comboExtra.setVisible(false);
            return;
        }
        int nSize = this.vectorContSuppFormats.size();
        int i2 = 0;
        while (i2 < nSize) {
            VideoFormat formatVideo;
            Object objectFormat = this.vectorContSuppFormats.elementAt(i2);
            if (objectFormat instanceof VideoFormat && this.isFormatGoodForEncoding(formatVideo = (VideoFormat)objectFormat) && this.isFormatGoodForVideoSize(formatVideo) && this.isFormatGoodForFrameRate(formatVideo)) {
                if (boolRGB && formatVideo instanceof RGBFormat) {
                    formatRGB = (RGBFormat)formatVideo;
                    integerBitsPerPixel = new Integer(formatRGB.getBitsPerPixel());
                    if (!vectorExtra.contains(integerBitsPerPixel)) {
                        this.comboExtra.addItem(integerBitsPerPixel.toString());
                        vectorExtra.addElement(integerBitsPerPixel);
                    }
                } else if (boolYUV && formatVideo instanceof YUVFormat && (strYuvType = this.getYuvType(nYuvType = (formatYUV = (YUVFormat)formatVideo).getYuvType())) != null && !vectorExtra.contains(strYuvType)) {
                    this.comboExtra.addItem(strYuvType);
                    vectorExtra.addElement(strYuvType);
                }
            }
            ++i2;
        }
        if (formatDefault != null && this.isFormatGoodForEncoding(formatDefault) && this.isFormatGoodForVideoSize(formatDefault) && this.isFormatGoodForFrameRate(formatDefault)) {
            if (boolRGB && formatDefault instanceof RGBFormat) {
                formatRGB = (RGBFormat)formatDefault;
                integerBitsPerPixel = new Integer(formatRGB.getBitsPerPixel());
                this.comboExtra.select(integerBitsPerPixel.toString());
            } else if (boolYUV && formatDefault instanceof YUVFormat) {
                formatYUV = (YUVFormat)formatDefault;
                nYuvType = formatYUV.getYuvType();
                strYuvType = this.getYuvType(nYuvType);
                if (strYuvType != null) {
                    this.comboExtra.select(strYuvType);
                }
            } else if (this.comboExtra.getItemCount() > 0) {
                this.comboExtra.select(0);
            }
        } else if (this.comboExtra.getItemCount() > 0) {
            this.comboExtra.select(0);
        }
    }

    private boolean isFormatGoodForEncoding(VideoFormat format) {
        boolean boolResult = false;
        String strEncoding = this.comboEncoding.getSelectedItem();
        if (strEncoding != null) {
            boolResult = format.getEncoding().equalsIgnoreCase(strEncoding);
        }
        return boolResult;
    }

    private boolean isFormatGoodForVideoSize(VideoFormat format) {
        boolean boolResult = false;
        String strSizeVideo = this.comboSize.getSelectedItem();
        if (strSizeVideo != null) {
            Dimension formatVideoSize = format.getSize();
            if (formatVideoSize == null) {
                formatVideoSize = new Dimension(-1, -1);
            }
            VideoSize sizeVideo = new VideoSize(formatVideoSize);
            boolResult = sizeVideo.toString().equals(strSizeVideo);
        }
        return boolResult;
    }

    private boolean isFormatGoodForFrameRate(VideoFormat format) {
        boolean boolResult = false;
        if (this.customFrameRates != null) {
            return true;
        }
        String strFrameRate = this.comboFrameRate.getSelectedItem();
        if (strFrameRate != null) {
            float fFrameRate2;
            float fFrameRate1 = Float.valueOf(strFrameRate).floatValue();
            boolResult = fFrameRate1 == (fFrameRate2 = format.getFrameRate());
        }
        return boolResult;
    }

    private boolean isFormatSupported(VideoFormat format) {
        boolean boolSupported = false;
        if (format == null) {
            return boolSupported;
        }
        int nCount = this.vectorContSuppFormats.size();
        int i2 = 0;
        while (i2 < nCount && !boolSupported) {
            VideoFormat formatVideo = (VideoFormat)this.vectorContSuppFormats.elementAt(i2);
            if (formatVideo.matches(format)) {
                boolSupported = true;
            }
            ++i2;
        }
        return boolSupported;
    }

    public void itemStateChanged(ItemEvent event) {
        Object objectSource = event.getSource();
        if (objectSource == this.checkEnableTrack) {
            this.boolEnableTrackSaved = this.checkEnableTrack.getState();
            this.onEnableTrack(true);
        } else if (objectSource == this.comboEncoding) {
            this.updateFieldsFromEncoding(this.formatOld);
        } else if (objectSource == this.comboSize) {
            this.updateFieldsFromSize(this.formatOld);
        } else if (objectSource == this.comboFrameRate) {
            this.updateFieldsFromRate(this.formatOld);
        }
    }

    private void onEnableTrack(boolean notifyListener) {
        boolean boolEnable = this.checkEnableTrack.getState();
        this.enableControls(boolEnable && this.isEnabled());
        if (notifyListener && this.listenerEnableTrack != null) {
            ActionEvent event = boolEnable ? new ActionEvent(this, 1001, ACTION_TRACK_ENABLED) : new ActionEvent(this, 1001, ACTION_TRACK_DISABLED);
            this.listenerEnableTrack.actionPerformed(event);
        }
    }

    private void enableControls(boolean boolEnable) {
        this.labelEncoding.setEnabled(boolEnable);
        this.comboEncoding.setEnabled(boolEnable);
        this.labelSize.setEnabled(boolEnable);
        this.comboSize.setEnabled(boolEnable);
        this.labelFrameRate.setEnabled(boolEnable);
        this.comboFrameRate.setEnabled(boolEnable);
        this.labelExtra.setEnabled(boolEnable);
        this.comboExtra.setEnabled(boolEnable);
    }

    private String getYuvType(int nType) {
        String strType = null;
        strType = (nType & 2) == 2 ? "4:2:0" : ((nType & 4) == 4 ? "4:2:2" : ((nType & 0x20) == 32 ? "YUYV" : ((nType & 8) == 8 ? "1:1:1" : ((nType & 1) == 1 ? "4:1:1" : ((nType & 0x10) == 16 ? "YVU9" : null)))));
        return strType;
    }
}

