/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.ui;

import com.sun.media.controls.ControlChangeEvent;
import com.sun.media.controls.ControlChangeListener;
import com.sun.media.controls.NumericControl;
import com.sun.media.ui.AtomicComponent;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;

public class Slider
extends AtomicComponent
implements ControlChangeListener,
MouseListener,
MouseMotionListener {
    Image imageGrabber = AtomicComponent.fetchImage("grabber.gif");
    Image imageGrabberX;
    Image imageGrabberDown = AtomicComponent.fetchImage("grabber-pressed.gif");
    Graphics paintG;
    boolean grabbed;
    boolean entered;
    int grabberPosition;
    int leftBorder = 8;
    int rightBorder = 8;
    int sliderWidth;
    int width;
    int height;
    int displayPercent;
    float[] detents;
    Dimension dimension;
    float lower;
    float upper = 1.0f;
    float range = 1.0f;
    float value = 0.5f;
    boolean dragging = false;
    boolean grabberVisible = true;

    public Slider() {
        this(null, null);
    }

    public Slider(float[] detents) {
        this(detents, null);
    }

    public Slider(float[] detents, Color background) {
        super("Slider");
        this.imageGrabberX = AtomicComponent.fetchImage("grabber-disabled.gif");
        this.detents = detents;
        if (background != null) {
            this.setBackground(background);
        }
        this.width = 115;
        this.height = 18;
        this.displayPercent = 100;
        this.dimension = new Dimension(this.width, this.height);
        this.sliderWidth = this.width - this.leftBorder - this.rightBorder;
        this.setSize(this.width, this.height);
        this.setVisible(true);
        this.grabbed = false;
        this.entered = false;
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    public void setControl(NumericControl nc) {
        if (nc == null) {
            return;
        }
        super.setControl(nc);
        this.lower = nc.getLowerLimit();
        this.upper = nc.getUpperLimit();
        this.range = this.upper - this.lower;
        this.value = nc.getDefaultValue();
        this.setSliderPosition(this.value - this.lower, this.range);
        nc.addControlChangeListener(this);
        this.repaint();
    }

    public void controlChanged(ControlChangeEvent cce) {
        NumericControl nc = (NumericControl)this.control;
        this.lower = nc.getLowerLimit();
        this.upper = nc.getUpperLimit();
        this.range = this.upper - this.lower;
        this.value = nc.getValue();
        this.setSliderPosition(this.value - this.lower, this.range);
        this.repaint();
    }

    public void setEnabled(boolean state) {
        super.setEnabled(state);
        this.repaint();
    }

    public Point getPosition() {
        return new Point(this.grabberPosition + this.leftBorder, 10);
    }

    public void setDisplayPercent(int percent) {
        if (percent != this.displayPercent) {
            this.displayPercent = percent;
            if (this.displayPercent > 100) {
                this.displayPercent = 100;
            } else if (this.displayPercent < 0) {
                this.displayPercent = 0;
            }
            this.repaint();
        }
    }

    public boolean isGrabberVisible() {
        return this.grabberVisible;
    }

    public void setGrabberVisible(boolean visible) {
        if (this.grabberVisible != visible) {
            this.grabberVisible = visible;
            this.repaint();
        }
    }

    public void paint(Graphics g2) {
        int x;
        Dimension size = this.getSize();
        int y = size.height / 2 - 2;
        this.paintG = g2;
        int grabberX = this.grabberPosition + this.leftBorder - 5;
        g2.setColor(this.getBackground());
        y = this.getSize().height / 2 - 2;
        g2.draw3DRect(2, y, size.width - 4, 3, false);
        if (this.displayPercent < 100) {
            g2.setColor(Color.green);
            x = this.sliderWidth * this.displayPercent / 100 + 3;
            g2.drawLine(x, y += 2, size.width - 4, y);
        }
        if (this.detents != null && this.detents.length != 0) {
            this.paintG.setColor(Color.black);
            int i2 = 0;
            while (i2 < this.detents.length) {
                x = this.leftBorder + (int)(this.detents[i2] * (float)this.sliderWidth / this.range);
                this.paintG.drawLine(x, 12, x, 15);
                ++i2;
            }
        }
        if (this.grabberVisible) {
            Image image = this.isEnabled() ? (this.grabbed || this.entered ? this.imageGrabberDown : this.imageGrabber) : this.imageGrabberX;
            this.paintG.drawImage(image, grabberX, 4, this);
        }
    }

    private int limitGrabber(int mousex) {
        int x = mousex - this.leftBorder;
        if (x < 0) {
            x = 0;
        } else if (x > this.sliderWidth) {
            x = this.sliderWidth;
        }
        return x;
    }

    private void setSliderPosition(float value, float range) {
        this.grabberPosition = (int)(value / range * (float)this.sliderWidth);
    }

    private void seek() {
        if (this.control != null && this.control instanceof NumericControl) {
            float result;
            NumericControl nc = (NumericControl)this.control;
            float lower = nc.getLowerLimit();
            float upper = nc.getUpperLimit();
            float value = (float)this.grabberPosition / (float)this.sliderWidth * (upper - lower) + lower;
            if (this.detents != null && this.detents.length > 0 && this.dragging) {
                float tolerance = (upper - lower) * 0.05f;
                int i2 = 0;
                while (i2 < this.detents.length) {
                    if (Math.abs(this.detents[i2] - value) <= tolerance) {
                        value = this.detents[i2];
                    }
                    ++i2;
                }
            }
            if (value != (result = nc.setValue(value))) {
                this.setSliderPosition(result - lower, upper - lower);
            }
        }
        this.repaint();
    }

    public void mousePressed(MouseEvent me) {
        int modifier = me.getModifiers();
        if ((modifier & 8) == 0 && (modifier & 4) == 0 && this.isEnabled()) {
            this.dragging = false;
            this.grabbed = true;
            this.grabberPosition = this.limitGrabber(me.getX());
            this.seek();
        }
    }

    public void mouseReleased(MouseEvent me) {
        int modifier = me.getModifiers();
        if ((modifier & 8) == 0 && (modifier & 4) == 0 && this.isEnabled()) {
            this.dragging = false;
            this.grabbed = false;
            this.repaint();
        }
    }

    public void mouseDragged(MouseEvent me) {
        int modifier = me.getModifiers();
        if ((modifier & 8) == 0 && (modifier & 4) == 0 && this.isEnabled()) {
            this.dragging = true;
            this.grabberPosition = this.limitGrabber(me.getX());
            this.seek();
        }
    }

    public void mouseEntered(MouseEvent me) {
        this.entered = true;
        this.repaint();
    }

    public void mouseExited(MouseEvent me) {
        this.entered = false;
        this.repaint();
    }

    public void mouseClicked(MouseEvent me) {
    }

    public void mouseMoved(MouseEvent me) {
    }

    public void setSize(int width, int height) {
        super.setSize(width, height);
        this.paintG = null;
        this.repaint();
    }

    public Dimension getPreferredSize() {
        return this.dimension;
    }
}

