/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media;

import com.sun.media.BasicController;
import com.sun.media.util.MediaThread;

abstract class TimedActionThread
extends MediaThread {
    protected BasicController controller;
    protected long wakeupTime;
    protected boolean aborted = false;

    TimedActionThread(BasicController mc, long nanoseconds) {
        this.controller = mc;
        this.useControlPriority();
        this.wakeupTime = nanoseconds;
    }

    protected abstract long getTime();

    protected abstract void action();

    public synchronized void abort() {
        this.aborted = true;
        this.notify();
    }

    public void run() {
        long now;
        while ((now = this.getTime()) < this.wakeupTime) {
            long sleepTime = this.wakeupTime - now;
            if (sleepTime > 1000000000L) {
                sleepTime = 1000000000L;
            }
            TimedActionThread timedActionThread = this;
            synchronized (timedActionThread) {
                try {
                    this.wait(sleepTime / 1000000L);
                }
                catch (InterruptedException interruptedException) {
                    Object var6_4 = null;
                    break;
                }
            }
        }
        if (!this.aborted) {
            this.action();
        }
    }
}

