/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media;

import com.sun.media.BasicController;
import com.sun.media.Connector;
import com.sun.media.InputConnector;
import com.sun.media.JMD;
import com.sun.media.MediaEngine;
import com.sun.media.Module;
import com.sun.media.ModuleListener;
import com.sun.media.OutputConnector;
import com.sun.media.StateTransistor;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.media.Format;
import javax.media.Time;

public abstract class BasicModule
implements Module,
StateTransistor {
    protected Registry inputConnectors = new Registry();
    protected Registry outputConnectors = new Registry();
    protected InputConnector[] inputConnectorsArray;
    protected OutputConnector[] outputConnectorsArray;
    protected int protocol = 0;
    protected String name;
    protected ModuleListener moduleListener;
    protected BasicController controller;
    protected boolean resetted = false;
    protected boolean prefetchFailed = false;
    protected JMD jmd;

    public boolean doRealize() {
        return true;
    }

    public void doFailedRealize() {
    }

    public void abortRealize() {
    }

    public void connectorPushed(InputConnector inputConnector) {
        this.process();
    }

    public void connectorPulled(OutputConnector outputConnector) {
        this.process();
    }

    public boolean doPrefetch() {
        this.resetted = false;
        return true;
    }

    public void doFailedPrefetch() {
    }

    public void abortPrefetch() {
    }

    public void doStart() {
        this.resetted = false;
    }

    public void doStop() {
    }

    public void doDealloc() {
    }

    public void doClose() {
    }

    public void doSetMediaTime(Time t) {
    }

    public float doSetRate(float r2) {
        return r2;
    }

    public Object[] getControls() {
        return null;
    }

    public Object getControl(String s) {
        return null;
    }

    public Format[] listFormats(Connector connector) {
        return null;
    }

    public void setModuleListener(ModuleListener listener) {
        this.moduleListener = listener;
    }

    public void setFormat(Connector connector, Format format) {
    }

    public String[] getInputConnectorNames() {
        return this.inputConnectors.getNames();
    }

    public String[] getOutputConnectorNames() {
        return this.outputConnectors.getNames();
    }

    public InputConnector getInputConnector(String connectorName) {
        return (InputConnector)this.inputConnectors.get(connectorName);
    }

    public OutputConnector getOutputConnector(String connectorName) {
        return (OutputConnector)this.outputConnectors.get(connectorName);
    }

    public void registerInputConnector(String name, InputConnector inputConnector) {
        this.inputConnectors.put(name, inputConnector);
        inputConnector.setModule(this);
    }

    public void registerOutputConnector(String name, OutputConnector outputConnector) {
        this.outputConnectors.put(name, outputConnector);
        outputConnector.setModule(this);
    }

    public void reset() {
        if (this.getState() == 600) {
            throw new RuntimeException();
        }
        this.resetted = true;
    }

    public final boolean isInterrupted() {
        return this.controller == null ? false : this.controller.isInterrupted();
    }

    public boolean isThreaded() {
        return true;
    }

    public boolean canRun() {
        int i2 = 0;
        while (i2 < this.inputConnectorsArray.length) {
            if (!this.inputConnectorsArray[i2].isValidBufferAvailable()) {
                return false;
            }
            ++i2;
        }
        int i3 = 0;
        while (i3 < this.outputConnectorsArray.length) {
            if (!this.outputConnectorsArray[i3].isEmptyBufferAvailable()) {
                return false;
            }
            ++i3;
        }
        return true;
    }

    protected abstract void process();

    protected void error() {
        throw new RuntimeException(String.valueOf(this.getClass().getName()) + " error");
    }

    public final BasicController getController() {
        return this.controller;
    }

    public final void setController(BasicController c2) {
        this.controller = c2;
    }

    public final int getState() {
        return this.controller.getState();
    }

    public final String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setJMD(JMD jmd) {
        this.jmd = jmd;
    }

    public Time getMediaTime() {
        return this.controller.getMediaTime();
    }

    public long getMediaNanoseconds() {
        return this.controller.getMediaNanoseconds();
    }

    public long getLatency() {
        return ((MediaEngine)this.controller).getLatency();
    }

    public void setProtocol(int protocol) {
        this.protocol = protocol;
        Connector[] connectors = this.inputConnectors.getConnectors();
        int i2 = 0;
        while (i2 < connectors.length) {
            connectors[i2].setProtocol(protocol);
            ++i2;
        }
        connectors = this.outputConnectors.getConnectors();
        int i3 = 0;
        while (i3 < connectors.length) {
            connectors[i3].setProtocol(protocol);
            ++i3;
        }
    }

    public int getProtocol() {
        return this.protocol;
    }

    public boolean prefetchFailed() {
        return this.prefetchFailed;
    }

    class Registry
    extends Hashtable {
        Connector def;

        String[] getNames() {
            Enumeration namesEnum = this.keys();
            String[] namesArray = new String[this.size()];
            int i2 = 0;
            while (i2 < this.size()) {
                namesArray[i2] = (String)namesEnum.nextElement();
                ++i2;
            }
            return namesArray;
        }

        void put(String name, Connector connector) {
            if (this.containsKey(name)) {
                throw new RuntimeException("Connector '" + name + "' already exists in Module '" + BasicModule.this.getClass().getName() + "::" + name + "'");
            }
            if (this.def == null) {
                this.def = connector;
            }
            super.put(name, connector);
        }

        Object get(String name) {
            if (name == null) {
                return this.def;
            }
            return super.get(name);
        }

        Connector[] getConnectors() {
            Enumeration connectorsEnum = this.elements();
            Connector[] connectorsArray = new Connector[this.size()];
            int i2 = 0;
            while (i2 < this.size()) {
                connectorsArray[i2] = (Connector)connectorsEnum.nextElement();
                ++i2;
            }
            return connectorsArray;
        }

        Registry() {
            BasicModule.this = BasicModule.this;
        }
    }
}

