/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.media.codec.video.h263;

public class YCbCrToRGB {
    public static final String a_copyright_notice = "(c) Copyright IBM Corporation 1997, 1998.";
    private static final int[] E02xCr_Table = new int[256];
    private static final int[] E11xCb_Table = new int[256];
    private static final int[] E12xCr_Table = new int[256];
    private static final int[] E21xCb_Table = new int[256];
    private static final int[] Ex0xY_Table = new int[256];
    private static final int[] clipR = new int[1024];
    private static final int[] clipG = new int[1024];
    private static final int[] clipB = new int[1024];

    public static void convert(int[] Y, int[] Cb, int[] Cr, int[] pixData, int srcWidth, int srcHeight, int dstWidth, int dstHeight, int alpha, int colorDepth) {
        int srcDstOffset = srcWidth - dstWidth;
        if (srcDstOffset < 0) {
            return;
        }
        int shiftedAlpha = alpha << 24;
        int dstIndex00 = 0;
        int dstIndex10 = dstWidth;
        int yIndex00 = 0;
        int yIndex10 = srcWidth;
        int cbIndex = 0;
        int crIndex = 0;
        int i2 = 0;
        while (i2 < dstHeight) {
            int j2 = 0;
            while (j2 < dstWidth) {
                int n2;
                int n3;
                int n4;
                int tempRGB;
                byte y00 = (byte)Y[yIndex00++];
                byte y01 = (byte)Y[yIndex00++];
                byte y10 = (byte)Y[yIndex10++];
                byte y11 = (byte)Y[yIndex10++];
                int Yval = Ex0xY_Table[0xFF & y00];
                int Cb_nCrCb_Idx = 0xFF & (byte)Cb[cbIndex++];
                int Cr_nCrCb_Idx = 0xFF & (byte)Cr[crIndex++];
                int partRed = E02xCr_Table[Cr_nCrCb_Idx];
                int red = Yval + partRed;
                int partGreen = E11xCb_Table[Cb_nCrCb_Idx] + E12xCr_Table[Cr_nCrCb_Idx];
                int green = Yval + partGreen;
                int partBlue = E21xCb_Table[Cb_nCrCb_Idx];
                int blue = Yval + partBlue;
                pixData[dstIndex00++] = tempRGB = shiftedAlpha | clipR[red & 0x3FF] | clipG[green & 0x3FF] | clipB[blue & 0x3FF];
                int n5 = dstIndex00++;
                if (y00 != y01) {
                    Yval = Ex0xY_Table[y01 & 0xFF];
                    n4 = shiftedAlpha | clipR[Yval + partRed & 0x3FF] | clipG[Yval + partGreen & 0x3FF] | clipB[Yval + partBlue & 0x3FF];
                } else {
                    n4 = tempRGB;
                }
                pixData[n5] = n4;
                int n6 = dstIndex10++;
                if (y00 != y10) {
                    Yval = Ex0xY_Table[y10 & 0xFF];
                    n3 = shiftedAlpha | clipR[Yval + partRed & 0x3FF] | clipG[Yval + partGreen & 0x3FF] | clipB[Yval + partBlue & 0x3FF];
                } else {
                    n3 = tempRGB;
                }
                pixData[n6] = n3;
                int n7 = dstIndex10++;
                if (y00 != y11) {
                    Yval = Ex0xY_Table[y11 & 0xFF];
                    n2 = shiftedAlpha | clipR[Yval + partRed & 0x3FF] | clipG[Yval + partGreen & 0x3FF] | clipB[Yval + partBlue & 0x3FF];
                } else {
                    n2 = tempRGB;
                }
                pixData[n7] = n2;
                j2 += 2;
            }
            yIndex00 = yIndex10 + srcDstOffset;
            yIndex10 += srcWidth + srcDstOffset;
            dstIndex00 = dstIndex10;
            dstIndex10 += dstWidth;
            cbIndex += srcDstOffset / 2;
            crIndex += srcDstOffset / 2;
            i2 += 2;
        }
    }

    static {
        int i2 = 0;
        while (i2 < 256) {
            YCbCrToRGB.E02xCr_Table[i2] = (int)(1.596 * (double)(i2 - 128));
            YCbCrToRGB.E11xCb_Table[i2] = (int)(-0.392 * (double)(i2 - 128));
            YCbCrToRGB.E12xCr_Table[i2] = (int)(-0.813 * (double)(i2 - 128));
            YCbCrToRGB.E21xCb_Table[i2] = (int)(2.017 * (double)(i2 - 128));
            YCbCrToRGB.Ex0xY_Table[i2] = (int)(1.164 * (double)(i2 - 16));
            ++i2;
        }
        int i3 = 0;
        while (i3 < 1024) {
            int clip = i3 < 256 ? i3 : (i3 < 512 ? 255 : 0);
            YCbCrToRGB.clipB[i3] = clip << 16;
            YCbCrToRGB.clipG[i3] = clip << 8;
            YCbCrToRGB.clipR[i3] = clip;
            ++i3;
        }
    }
}

