/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextComponent;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;
import javax.media.Manager;
import javax.media.MediaLocator;
import javax.media.Processor;
import javax.media.protocol.CaptureDevice;
import javax.media.protocol.ContentDescriptor;
import javax.media.protocol.DataSource;

public class PanelMediaSource
extends Panel
implements ActionListener,
TextListener {
    private TextField textSource;
    private Button buttonBrowseFile;
    private Button buttonBrowseCapture;
    private CaptureDialog dlgCapture;
    private CaptureControlsDialog dlgCaptureControls;
    private boolean boolSettingCaptureSource = false;
    private String strContentTypeDefault;

    public PanelMediaSource() {
        try {
            this.init();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void setSourceUrl(String strSourceUrl) {
        ((TextComponent)this.textSource).setText(strSourceUrl);
    }

    public String getSourceUrl() {
        String strSourceUrl = this.textSource.getText();
        return strSourceUrl;
    }

    public Processor createProcessor() {
        DataSource dataSource = null;
        Processor processor = null;
        this.strContentTypeDefault = null;
        this.dlgCaptureControls = null;
        if (this.dlgCapture != null) {
            dataSource = this.dlgCapture.createCaptureDataSource();
            this.dlgCapture = null;
        } else {
            String strSourceUrl = this.getSourceUrl();
            try {
                MediaLocator mediaSource = new MediaLocator(strSourceUrl);
                dataSource = Manager.createDataSource(mediaSource);
            }
            catch (Exception exception) {
                MessageDialog.createErrorDialog(this.getFrame(), "Failed to create Data Source for '" + strSourceUrl + "'. ", exception);
            }
        }
        if (dataSource == null) {
            this.setCursor(Cursor.getDefaultCursor());
            return null;
        }
        if (dataSource instanceof CaptureDevice) {
            this.dlgCaptureControls = new CaptureControlsDialog(this.getFrame(), dataSource, null);
        }
        this.strContentTypeDefault = new ContentDescriptor(dataSource.getContentType()).toString();
        try {
            processor = Manager.createProcessor(dataSource);
        }
        catch (Exception exception) {
            MessageDialog.createErrorDialog(this.getFrame(), "Failed to create Processor. " + exception.getMessage());
            exception.printStackTrace();
            this.setCursor(Cursor.getDefaultCursor());
            return null;
        }
        return processor;
    }

    public String getDefaultContentType() {
        return this.strContentTypeDefault;
    }

    public CaptureControlsDialog getCaptureControlsDialog() {
        return this.dlgCaptureControls;
    }

    private void init() throws Exception {
        this.setLayout(new BorderLayout(12, 12));
        Panel panelDescription = new Panel(new GridLayout(0, 1));
        this.add((Component)panelDescription, "North");
        panelDescription.add(new Label("Type in the source location of the Media"));
        panelDescription.add(new Label("to be used for export."));
        Panel panel = new Panel(new BorderLayout(6, 6));
        this.add((Component)panel, "Center");
        Panel panelEntry = new Panel(new BorderLayout(6, 6));
        panel.add((Component)panelEntry, "North");
        this.textSource = new TextField();
        this.textSource.addTextListener(this);
        panelEntry.add((Component)this.textSource, "Center");
        Panel panelButtons1 = new Panel(new BorderLayout(6, 6));
        panel.add((Component)panelButtons1, "Center");
        Panel panelButtons2 = new Panel(new BorderLayout(6, 6));
        panelButtons1.add((Component)panelButtons2, "North");
        Panel panelButtons = new Panel(new GridLayout(1, 0, 6, 6));
        panelButtons2.add((Component)panelButtons, "West");
        this.buttonBrowseFile = new Button("File...");
        this.buttonBrowseFile.addActionListener(this);
        panelButtons.add(this.buttonBrowseFile);
        this.buttonBrowseCapture = new Button("Capture...");
        this.buttonBrowseCapture.addActionListener(this);
        panelButtons.add(this.buttonBrowseCapture);
    }

    public void actionPerformed(ActionEvent event) {
        String strCmd = event.getActionCommand();
        if (strCmd.equals(this.buttonBrowseFile.getLabel())) {
            this.browseFile();
        } else if (strCmd.equals(this.buttonBrowseCapture.getLabel())) {
            this.browseCapture();
        }
    }

    public void textValueChanged(TextEvent event) {
        Object objectSource = event.getSource();
        if (objectSource == this.textSource) {
            if (this.boolSettingCaptureSource) {
                this.boolSettingCaptureSource = false;
            } else {
                this.dlgCapture = null;
            }
        }
    }

    private void browseFile() {
        String strFile = this.textSource.getText();
        FileDialog dlgFile = new FileDialog(this.getFrame(), "Select source file", 0);
        int nIndex = strFile.indexOf(58);
        if (nIndex > 0 && strFile.substring(0, nIndex).equalsIgnoreCase("file")) {
            strFile = strFile.substring(nIndex + 1);
            dlgFile.setFile(strFile);
        }
        dlgFile.show();
        strFile = dlgFile.getFile();
        String strDir = dlgFile.getDirectory();
        if (strFile != null && strFile.length() > 0) {
            strFile = "file:" + strDir + strFile;
            ((TextComponent)this.textSource).setText(strFile);
            this.dlgCapture = null;
        }
    }

    private void browseCapture() {
        if (this.dlgCapture == null) {
            this.dlgCapture = new CaptureDialog(this.getFrame());
        }
        this.dlgCapture.show();
        MediaLocator mediaLocator = this.dlgCapture.getLocator();
        if (mediaLocator == null) {
            this.dlgCapture = null;
        } else {
            this.boolSettingCaptureSource = true;
            ((TextComponent)this.textSource).setText(mediaLocator.toString());
        }
    }

    private Frame getFrame() {
        Frame frame = null;
        Container comp = this;
        while (comp != null) {
            if (comp instanceof Frame) {
                frame = (Frame)comp;
                break;
            }
            comp = comp.getParent();
        }
        return frame;
    }
}

