/*
 * Decompiled with CFR 0.152.
 */
import com.sun.media.ui.PlayerWindow;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.CheckboxGroup;
import java.awt.Choice;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.List;
import java.awt.Panel;
import java.awt.TextArea;
import java.awt.TextComponent;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.Vector;
import javax.media.ControllerClosedEvent;
import javax.media.ControllerEvent;
import javax.media.ControllerListener;
import javax.media.DataSink;
import javax.media.Format;
import javax.media.Manager;
import javax.media.MediaLocator;
import javax.media.NoDataSinkException;
import javax.media.NoProcessorException;
import javax.media.Player;
import javax.media.Processor;
import javax.media.control.TrackControl;
import javax.media.datasink.EndOfFileEvent;
import javax.media.datasink.FileWriterControl;
import javax.media.datasink.FileWriterEvent;
import javax.media.datasink.FileWriterListener;
import javax.media.format.AudioFormat;
import javax.media.format.VideoFormat;
import javax.media.protocol.ContentDescriptor;
import javax.media.protocol.DataSource;
import javax.media.protocol.PushBufferDataSource;
import javax.media.protocol.PushBufferStream;
import javax.media.rtp.SendStream;
import javax.media.rtp.SessionManager;
import rtp.RTPUtil;

public class ExportDialog
extends Dialog
implements ActionListener,
ItemListener,
FileWriterListener {
    Frame parentFrame;
    String inputURL;
    TextField tfInputURL;
    Button bOpenFile;
    Button bCapture;
    Button bOther;
    Button bOk;
    Button bClear;
    Button bClose;
    TextArea taSource;
    Checkbox cbEnabled;
    Choice cTrack;
    Choice cFormat;
    Choice cContentType;
    List listTarget;
    TextField tfOutputURL;
    TextField tfLimit;
    Panel destinationPanel;
    Panel customPanel;
    Checkbox cbDestFile;
    Checkbox cbDestNetwork;
    Checkbox cbDestScreen;
    Checkbox cbDestOther;
    Button bBrowse;
    Checkbox cbLimitFileSize;
    TextField[] tfAddress;
    TextField[] tfPort;
    Checkbox cbAutoStart;
    boolean limitSize = true;
    long fileSizeLimit = 1000000L;
    String outputURL = "";
    String lastDirectory = ".";
    String lastOutputDirectory = ".";
    String lastOutputFile = "";
    int currentOutputType = 1;
    int trackNo;
    String[] rtpAddress;
    String[] rtpPort;
    Dialog msgDlg;
    Processor processor;
    Integer stateLock = new Integer(1);
    boolean failed;
    TrackControl[] tracks;
    Format[][] trackFormats;
    ContentDescriptor[] contentDescriptors;
    String[] formatEncoding;
    int[] formatIndex;
    boolean[] trackEnabled;
    Format[] sourceFormat;
    DataSource outputDS;
    String currentURL = "";
    Frame fClose;
    DataSink filewriter;
    private static final int DEST_FILE = 1;
    private static final int DEST_NETWORK = 2;
    private static final int DEST_SCREEN = 3;
    private static final int DEST_OTHER = 4;
    private static final String LABEL_OPENFILE = "File...";
    private static final String LABEL_OPENCAPTURE = "Capture...";
    private static final String LABEL_OPENOTHER = "Other...";

    public ExportDialog(Frame frame, String inputURL) {
        super(frame, false);
        this.setTitle("Export...");
        this.inputURL = inputURL;
        this.parentFrame = frame;
        ((Component)this).setBackground(Color.lightGray);
        this.addComponents();
        this.pack();
        ((Component)this).setVisible(true);
        this.addWindowListener(new 1());
        if (inputURL != null && inputURL.length() > 0) {
            ((TextComponent)this.tfInputURL).setText(inputURL);
            this.sourceEntered();
        }
    }

    public ExportDialog(Frame frame, String inputURL, Vector fileList) {
        this(frame, inputURL);
    }

    public synchronized void fileWriterUpdate(FileWriterEvent event) {
        if (event instanceof EndOfFileEvent) {
            if (this.fClose != null) {
                this.fClose.dispose();
                this.fClose = null;
            }
            if (this.processor != null) {
                this.processor.stop();
                this.processor.close();
                this.processor = null;
            }
        }
    }

    public void contentTypeSelected() {
        String contentType = this.cContentType.getSelectedItem();
        if (this.processor.setContentDescriptor(new ContentDescriptor(contentType)) == null) {
            return;
        }
        this.cTrack.removeAll();
        this.cFormat.removeAll();
        int i2 = 0;
        while (i2 < this.tracks.length) {
            TrackControl tc = this.tracks[i2];
            this.sourceFormat[i2] = tc.getFormat();
            this.trackEnabled[i2] = tc.isEnabled();
            String strActive = " #" + i2;
            String fString = this.sourceFormat[i2] instanceof VideoFormat ? "Video" + strActive : (this.sourceFormat[i2] instanceof AudioFormat ? "Audio" + strActive : "Unknown" + strActive);
            this.cTrack.add(fString);
            this.formatEncoding[i2] = this.sourceFormat[i2].getEncoding().toUpperCase();
            Format[] sup = tc.getSupportedFormats();
            if (sup.length > 0) {
                if (!sup[0].equals(this.sourceFormat[i2])) {
                    this.sourceFormat[i2] = sup[0];
                }
                this.trackFormats[i2] = this.sortByEncoding(sup);
                this.formatIndex[i2] = this.formatToFormatIndex(this.trackFormats[i2], this.sourceFormat[i2]);
            } else {
                this.trackEnabled[i2] = false;
                this.trackFormats[i2] = new Format[0];
                this.formatIndex[i2] = 0;
            }
            this.rtpPort[i2] = "";
            this.rtpAddress[i2] = "";
            ++i2;
        }
        this.cTrack.invalidate();
        this.trackSelected();
    }

    void fillDialog(Processor p2) {
        this.waitCursor();
        this.processor = p2;
        this.tracks = p2.getTrackControls();
        this.cContentType.removeAll();
        this.trackFormats = new Format[this.tracks.length][];
        this.sourceFormat = new Format[this.tracks.length];
        this.formatEncoding = new String[this.tracks.length];
        this.formatIndex = new int[this.tracks.length];
        this.formatEncoding = new String[this.tracks.length];
        this.trackEnabled = new boolean[this.tracks.length];
        this.rtpAddress = new String[this.tracks.length];
        this.rtpPort = new String[this.tracks.length];
        this.contentDescriptors = p2.getSupportedContentDescriptors();
        int i2 = 0;
        while (i2 < this.contentDescriptors.length) {
            String ctype = this.contentDescriptors[i2].getContentType();
            this.cContentType.addItem(ctype);
            ++i2;
        }
        this.contentTypeSelected();
        this.cbEnabled.setEnabled(true);
        this.cTrack.setEnabled(true);
        this.cFormat.setEnabled(true);
        this.bClear.setEnabled(true);
        this.listTarget.setEnabled(true);
        this.checkOK();
        this.destinationPanel.setEnabled(true);
        this.bOpenFile.setEnabled(false);
        this.bCapture.setEnabled(false);
        this.bOther.setEnabled(false);
        this.tfInputURL.setEnabled(false);
        this.pack();
        this.normalCursor();
    }

    boolean atleastOneTrackEnabled() {
        int i2 = 0;
        while (i2 < this.trackEnabled.length) {
            if (this.trackEnabled[i2]) {
                return true;
            }
            ++i2;
        }
        return false;
    }

    /*
     * Recovered potentially malformed switches.  Disable with '--allowmalformedswitch false'
     * Unable to fully structure code
     * Enabled aggressive block sorting
     */
    void checkOK() {
        toState = false;
        if (this.processor == null) ** GOTO lbl26
        block0 : switch (this.currentOutputType) {
            case 1: {
                if (this.tfOutputURL.getText().length() > 0 && this.atleastOneTrackEnabled()) {
                    toState = true;
                }
                this.bOk.setLabel("Save");
                break;
            }
            case 2: {
                if (this.atleastOneTrackEnabled()) {
                    toState = true;
                }
                i = 0;
                while (true) {
                    if (i >= this.trackEnabled.length) {
                        this.bOk.setLabel("Transmit");
                        break block0;
                    }
                    this.tfAddress[i].setEnabled(this.trackEnabled[i]);
                    this.tfPort[i].setEnabled(this.trackEnabled[i]);
                    ++i;
                }
            }
            case 3: {
                if (this.atleastOneTrackEnabled()) {
                    toState = true;
                }
                this.bOk.setLabel("Play");
                break;
            }
lbl26:
            // 1 sources

            this.bOk.setLabel("Save");
            break;
        }
        this.bOk.invalidate();
        this.bOk.setEnabled(toState);
    }

    synchronized void abortDialog() {
        if (this.processor != null) {
            this.processor.close();
            this.processor = null;
        }
        this.dispose();
    }

    void closeDialog() {
        this.dispose();
    }

    Integer getStateLock() {
        return this.stateLock;
    }

    void setFailed() {
        this.failed = true;
    }

    private synchronized boolean waitForState(Processor p2, int state) {
        p2.addControllerListener(new StateListener());
        this.failed = false;
        if (state == 180) {
            p2.configure();
        } else if (state == 300) {
            p2.realize();
        }
        while (p2.getState() < state && !this.failed) {
            Integer n2 = this.getStateLock();
            synchronized (n2) {
                try {
                    this.getStateLock().wait();
                }
                catch (InterruptedException interruptedException) {
                    boolean bl = false;
                    Object var5_5 = null;
                    return bl;
                }
            }
        }
        return !this.failed;
    }

    private void waitCursor() {
        this.setCursor(new Cursor(3));
    }

    private void normalCursor() {
        this.setCursor(Cursor.getDefaultCursor());
    }

    Processor createProcessor(String url) {
        this.waitCursor();
        if (this.processor != null) {
            this.processor.close();
            this.processor = null;
        }
        try {
            MediaLocator ml = new MediaLocator(url);
            Processor proc = Manager.createProcessor(ml);
            if (proc != null) {
                boolean reachedState = this.waitForState(proc, 180);
                this.normalCursor();
                if (reachedState) {
                    return proc;
                }
                return null;
            }
        }
        catch (MalformedURLException malformedURLException) {
            this.message("URL is fishy!");
        }
        catch (IOException iOException) {
            this.message("IOException creating processor!");
        }
        catch (NoProcessorException noProcessorException) {
            this.message("Could not create processor!");
        }
        this.normalCursor();
        return null;
    }

    public void doRealizeProcessor() {
        if (this.processor != null) {
            boolean reachedState;
            if (this.tracks != null) {
                int i2 = 0;
                while (i2 < this.tracks.length) {
                    this.tracks[i2].setEnabled(this.trackEnabled[i2]);
                    ++i2;
                }
            }
            if (!(reachedState = this.waitForState(this.processor, 300))) {
                this.message("Could not realize processor");
                this.doClear();
                return;
            }
            this.outputDS = this.processor.getDataOutput();
            if (this.outputDS == null) {
                this.message("Processor has no output");
                this.doClear();
                return;
            }
            this.cTrack.setEnabled(false);
            this.cFormat.setEnabled(false);
        }
    }

    public void doPreview() {
        block4: {
            if (this.processor != null && this.processor.getState() < 300) {
                this.doRealizeProcessor();
            }
            if (this.processor == null || this.outputDS == null) break block4;
            try {
                Player player = Manager.createPlayer(this.outputDS);
                if (player != null) {
                    new PlayerWindow(player, "Preview Player");
                    new PlayerWindow(this.processor, "Transcoding Processor", this.cbAutoStart.getState());
                    this.closeDialog();
                    break block4;
                }
                this.processor.close();
                this.processor = null;
                this.doClear();
            }
            catch (Exception exception) {
                this.message("Error creating Player");
                this.doClear();
            }
        }
    }

    public void doTransmit() {
        Vector<String> addresses = new Vector<String>();
        Vector<String> ports = new Vector<String>();
        int size = this.trackEnabled.length;
        this.setEnabled(false);
        int i2 = 0;
        while (i2 < size) {
            if (this.trackEnabled[i2]) {
                String address = this.tfAddress[i2].getText();
                String port = this.tfPort[i2].getText();
                if (address == null || port == null || address.length() < 7 || port.length() < 1) {
                    this.message("Error in transmission address/port");
                    return;
                }
                addresses.addElement(address);
                ports.addElement(port);
            }
            ++i2;
        }
        if (this.processor != null && this.processor.getState() < 300) {
            this.doRealizeProcessor();
        }
        if (this.processor == null) {
            this.setEnabled(true);
            return;
        }
        if (this.outputDS == null || !(this.outputDS instanceof PushBufferDataSource)) {
            this.message("Processor output incorrect for transmission!");
            this.doClear();
            return;
        }
        PushBufferStream[] streams = ((PushBufferDataSource)this.outputDS).getStreams();
        if (streams == null) {
            this.message("Processor output empty!");
            this.doClear();
            return;
        }
        boolean atleastOneSucceeded = false;
        boolean trackNo = false;
        i2 = 0;
        while (i2 < streams.length) {
            String address = (String)addresses.elementAt(i2);
            String port = (String)ports.elementAt(i2);
            System.err.println("Track No. " + i2 + "\nStream Encoding " + streams[i2].getFormat().getEncoding() + "\nRTP Address: " + address + "\nRTP Port " + port);
            try {
                if (!address.equals("") && !port.equals("")) {
                    RTPUtil rtputil = new RTPUtil();
                    SessionManager m2 = rtputil.createManager(address, port, "1", false, true);
                    SendStream s = m2.createSendStream(this.outputDS, i2);
                    s.start();
                    if (!atleastOneSucceeded) {
                        new PlayerWindow(this.processor, "Transcoding Processor", this.cbAutoStart.getState());
                    }
                    atleastOneSucceeded = true;
                }
            }
            catch (Exception e2) {
                this.message(e2.getMessage());
                this.doClear();
                return;
            }
            ++i2;
        }
        if (!atleastOneSucceeded) {
            this.message("Couldn't transmit any track");
            this.doClear();
        } else {
            this.closeDialog();
        }
    }

    public void browseOutputFile() {
        FileDialog fd = new FileDialog(this.parentFrame, "Save As...", 1);
        fd.setDirectory(this.lastOutputDirectory);
        fd.setFile(this.lastOutputFile);
        fd.show();
        String filename = fd.getFile();
        if (filename != null) {
            this.lastOutputDirectory = fd.getDirectory();
            this.lastOutputFile = filename;
            filename = String.valueOf(this.lastOutputDirectory) + filename;
            ((TextComponent)this.tfOutputURL).setText(filename);
            this.checkOK();
        }
    }

    public void doSave() {
        FileWriterControl fwc;
        String osName;
        boolean hasColon;
        boolean isFileURL = false;
        if (this.processor == null) {
            this.message("Processor has not been created. Select source url");
            return;
        }
        String outFile = this.tfOutputURL.getText().trim();
        if (outFile.length() == 0) {
            this.message("No file has been specified");
            return;
        }
        if (outFile.startsWith("file:")) {
            isFileURL = true;
        }
        boolean bl = hasColon = outFile.indexOf(":") != -1;
        if (!(isFileURL || !hasColon || (osName = System.getProperty("os.name").toLowerCase()).startsWith("win") && outFile.indexOf(":") == 1)) {
            this.message("Illegal output specification " + outFile);
            return;
        }
        this.dispose();
        this.filewriter = null;
        if (!isFileURL) {
            outFile = "file:" + outFile;
        }
        MediaLocator dest = new MediaLocator(outFile);
        this.doRealizeProcessor();
        try {
            this.filewriter = Manager.createDataSink(this.outputDS, dest);
            fwc = (FileWriterControl)this.filewriter.getControl("javax.media.datasink.FileWriterControl");
            if (fwc != null) {
                fwc.addFileWriterListener(this);
                if (this.cbLimitFileSize.getState()) {
                    try {
                        long fileSizeLimit = Long.valueOf(this.tfLimit.getText());
                        fwc.setFileSizeLimit(fileSizeLimit * 1024L);
                    }
                    catch (Throwable throwable) {
                        this.message("Error in file size limit value, ignoring.");
                    }
                }
            }
            this.filewriter.open();
            PlayerWindow processorWindow = new PlayerWindow(this.processor, "Transcoding Processor", this.cbAutoStart.getState(), false);
            this.fClose = new Frame("Saving..." + outFile);
            this.fClose.setLayout(new BorderLayout());
            if (fwc != null && fwc.getControlComponent() != null) {
                this.fClose.add("Center", fwc.getControlComponent());
            } else {
                Button bClose = new Button("Stop");
                bClose.addActionListener(new 2());
                this.fClose.add("North", bClose);
            }
            this.fClose.pack();
            ((Component)this.fClose).setLocation(50, 50);
            ((Component)this.fClose).setVisible(true);
        }
        catch (NoDataSinkException noDataSinkException) {
            this.message("NoDataSinkException");
            return;
        }
        catch (IOException e2) {
            this.message("IOException: " + e2.getMessage());
            return;
        }
        catch (SecurityException e3) {
            this.message("SecurityException: " + e3.getMessage());
            return;
        }
        fwc = (FileWriterControl)this.filewriter.getControl("javax.media.datasink.FileWriterControl");
        try {
            this.filewriter.start();
            this.outputDS.start();
        }
        catch (IOException iOException) {
            System.exit(-1);
        }
    }

    void trackEnabled() {
        boolean state = this.cbEnabled.getState();
        this.trackNo = this.cTrack.getSelectedIndex();
        this.trackEnabled[this.trackNo] = state;
        this.tracks[this.trackNo].setEnabled(state);
        this.checkOK();
    }

    void trackSelected() {
        String pastEncoding = "";
        this.waitCursor();
        this.trackNo = this.cTrack.getSelectedIndex();
        if (this.trackFormats != null && this.trackFormats.length > this.trackNo && this.trackFormats[this.trackNo] != null) {
            Format[] formats = this.trackFormats[this.trackNo];
            this.cFormat.removeAll();
            this.listTarget.removeAll();
            int j2 = 0;
            while (j2 < formats.length) {
                String thisEncoding = formats[j2].getEncoding().toUpperCase();
                if (!thisEncoding.equals(pastEncoding)) {
                    this.cFormat.addItem(thisEncoding);
                    pastEncoding = thisEncoding;
                    if (this.formatEncoding[this.trackNo].equals(thisEncoding)) {
                        this.cFormat.select(this.cFormat.getItemCount() - 1);
                    }
                }
                if (this.formatEncoding[this.trackNo].equals(thisEncoding)) {
                    this.listTarget.add(formats[j2].toString());
                    if (this.listTarget.getItemCount() == this.formatIndex[this.trackNo] + 1) {
                        this.listTarget.select(this.formatIndex[this.trackNo]);
                    }
                }
                ++j2;
            }
            this.cbEnabled.setState(this.trackEnabled[this.trackNo]);
            this.taSource.setText(this.sourceFormat[this.trackNo].toString());
        }
        this.cFormat.invalidate();
        this.validate();
        this.normalCursor();
    }

    void encodingSelected() {
        int trackNo = this.cTrack.getSelectedIndex();
        String encoding = this.cFormat.getSelectedItem();
        int i2 = 0;
        this.listTarget.removeAll();
        while (i2 < this.trackFormats[trackNo].length) {
            if (this.trackFormats[trackNo][i2].getEncoding().equalsIgnoreCase(encoding)) break;
            ++i2;
        }
        this.formatIndex[trackNo] = 0;
        this.formatEncoding[trackNo] = encoding;
        while (i2 < this.trackFormats[trackNo].length) {
            Format f2 = this.trackFormats[trackNo][i2];
            if (!f2.getEncoding().equalsIgnoreCase(encoding)) break;
            this.listTarget.addItem(f2.toString());
            ++i2;
        }
        this.listTarget.select(0);
        this.formatSelected();
        this.checkOK();
    }

    void formatSelected() {
        int trackNo = this.cTrack.getSelectedIndex();
        String encoding = this.formatEncoding[trackNo];
        int index = this.listTarget.getSelectedIndex();
        int formatNo = this.formatIndexToFullIndex(this.trackFormats[trackNo], encoding, index);
        this.formatIndex[trackNo] = index;
        try {
            this.tracks[trackNo].setFormat(this.trackFormats[trackNo][formatNo]);
        }
        catch (Exception exception) {
            this.message("TrackControl rejected this format.");
        }
    }

    int formatToFormatIndex(Format[] formats, Format format) {
        int i2 = 0;
        int j2 = 0;
        String encoding = format.getEncoding();
        while (i2 < formats.length) {
            if (formats[i2].getEncoding().equalsIgnoreCase(encoding)) {
                j2 = 0;
                while (i2 + j2 < formats.length) {
                    if (formats[i2 + j2] == format) {
                        return j2;
                    }
                    ++j2;
                }
            }
            ++i2;
        }
        System.err.println("Not found!!!!");
        return 0;
    }

    int formatIndexToFullIndex(Format[] formats, String encoding, int index) {
        int i2 = 0;
        while (i2 < formats.length) {
            if (formats[i2].getEncoding().equalsIgnoreCase(encoding)) {
                return i2 + index;
            }
            ++i2;
        }
        System.err.println("Not found!!!!!");
        return 0;
    }

    public void itemStateChanged(ItemEvent ie) {
        Object who = ie.getSource();
        if (who == this.cbLimitFileSize) {
            if (this.cbLimitFileSize.getState()) {
                this.tfLimit.setEnabled(true);
            } else {
                this.tfLimit.setEnabled(false);
            }
        } else if (who == this.cbDestFile || who == this.cbDestNetwork || who == this.cbDestScreen || who == this.cbDestOther) {
            this.outputTypeChanged();
        }
    }

    void sourceEntered() {
        Processor p2 = this.createProcessor(this.tfInputURL.getText());
        if (p2 != null) {
            this.fillDialog(p2);
        }
    }

    void doOpenCapture() {
        CaptureDialog cd = new CaptureDialog(this.parentFrame);
        cd.show();
        MediaLocator ml = cd.getLocator();
        if (ml == null) {
            return;
        }
        ((TextComponent)this.tfInputURL).setText(ml.toString());
        this.sourceEntered();
    }

    void doOpenOther() {
        this.tfInputURL.setEnabled(true);
    }

    void doOpenFile() {
        FileDialog fd = new FileDialog(this.parentFrame, "Open file...", 0);
        fd.setDirectory(this.lastDirectory);
        fd.show();
        String filename = fd.getFile();
        String directory = fd.getDirectory();
        if (filename == null) {
            return;
        }
        this.lastDirectory = directory;
        ((TextComponent)this.tfInputURL).setText("file:" + directory + filename);
        this.sourceEntered();
    }

    public void actionPerformed(ActionEvent ae) {
        String command = ae.getActionCommand();
        Object source = ae.getSource();
        if (source == this.tfInputURL && this.tfInputURL.getText().length() > 0) {
            this.sourceEntered();
        } else if (command.equals("Play")) {
            this.doPreview();
        } else if (command.equals("Clear")) {
            this.doClear();
        } else if (command.equals("Transmit")) {
            this.doTransmit();
        } else if (command.equals("Save")) {
            this.doSave();
        } else if (command.equals("Close")) {
            this.abortDialog();
        } else if (command.equals("Browse...")) {
            this.browseOutputFile();
        } else if (command.equals(LABEL_OPENFILE)) {
            this.doOpenFile();
        } else if (command.equals(LABEL_OPENCAPTURE)) {
            this.doOpenCapture();
        } else if (command.equals(LABEL_OPENOTHER)) {
            this.doOpenOther();
        }
    }

    protected void outputTypeChanged() {
        if (this.customPanel != null) {
            switch (this.currentOutputType) {
                case 1: {
                    this.limitSize = this.cbLimitFileSize.getState();
                    String text = this.tfLimit.getText();
                    try {
                        this.fileSizeLimit = Long.valueOf(text);
                    }
                    catch (Exception exception) {
                        this.fileSizeLimit = 0L;
                        this.limitSize = false;
                    }
                    this.outputURL = this.tfOutputURL.getText();
                    break;
                }
                case 2: {
                    int size = this.rtpPort.length;
                    int i2 = 0;
                    while (i2 < size) {
                        this.rtpAddress[i2] = this.tfAddress[i2].getText();
                        this.rtpPort[i2] = this.tfPort[i2].getText();
                        ++i2;
                    }
                    break;
                }
            }
            this.destinationPanel.remove(this.customPanel);
            this.customPanel = null;
        }
        if (this.cbDestFile.getState()) {
            this.currentOutputType = 1;
            this.customPanel = this.createFilePanel(this.outputURL, this.limitSize, this.fileSizeLimit);
        } else if (this.cbDestNetwork.getState()) {
            this.currentOutputType = 2;
            this.customPanel = this.createRTPPanel(this.rtpAddress, this.rtpPort);
        } else {
            this.currentOutputType = this.cbDestScreen.getState() ? 3 : 4;
        }
        if (this.customPanel != null) {
            this.destinationPanel.add("South", this.customPanel);
        }
        this.checkOK();
        this.pack();
    }

    public void addComponents() {
        Panel panelNorth = new Panel();
        panelNorth.setLayout(new BorderLayout());
        this.setLayout(new BorderLayout());
        this.add("North", panelNorth);
        BorderPanel panelSource = new BorderPanel();
        panelSource.setLayout(new BorderLayout());
        panelNorth.add("North", panelSource);
        Label label = new Label("  Source", 0);
        panelSource.add("North", label);
        this.bOpenFile = new Button(LABEL_OPENFILE);
        this.bCapture = new Button(LABEL_OPENCAPTURE);
        this.bOther = new Button(LABEL_OPENOTHER);
        Panel tempPanel = new Panel();
        tempPanel.setLayout(new FlowLayout(0));
        tempPanel.add(this.bOpenFile);
        tempPanel.add(this.bCapture);
        tempPanel.add(this.bOther);
        panelSource.add("Center", tempPanel);
        tempPanel = new Panel();
        tempPanel.setLayout(new BorderLayout());
        label = new Label("  Media Locator: ", 0);
        tempPanel.add("West", label);
        this.tfInputURL = new TextField();
        tempPanel.add("Center", this.tfInputURL);
        this.tfInputURL.setEnabled(false);
        Panel temp2Panel = new Panel();
        temp2Panel.setLayout(new BorderLayout());
        temp2Panel.add("North", tempPanel);
        panelSource.add("South", temp2Panel);
        BorderPanel panelTrack = new BorderPanel();
        panelTrack.setLayout(new BorderLayout());
        tempPanel = new Panel();
        tempPanel.setLayout(new BorderLayout());
        label = new Label("Track: ", 0);
        this.cTrack = new Choice();
        this.cbEnabled = new Checkbox("Enabled");
        temp2Panel = new Panel();
        temp2Panel.setLayout(new FlowLayout(0));
        temp2Panel.add(this.cTrack);
        tempPanel.add("West", label);
        tempPanel.add("East", this.cbEnabled);
        tempPanel.add("Center", temp2Panel);
        BorderPanel panelSourceFormat = new BorderPanel(0);
        panelSourceFormat.setLayout(new BorderLayout());
        label = new Label("Source Format", 0);
        this.taSource = new TextArea("", 2, 30, 3);
        ((Component)this.taSource).setBackground(Color.lightGray);
        this.taSource.setEditable(false);
        panelSourceFormat.add("North", label);
        panelSourceFormat.add("Center", this.taSource);
        tempPanel.add("South", panelSourceFormat);
        panelTrack.add("North", tempPanel);
        tempPanel = new BorderPanel(0);
        tempPanel.setLayout(new BorderLayout());
        temp2Panel = new Panel();
        temp2Panel.setLayout(new BorderLayout());
        label = new Label("Target Format", 0);
        this.cFormat = new Choice();
        temp2Panel.add("North", label);
        Panel temp3Panel = new Panel();
        temp3Panel.setLayout(new FlowLayout(0, 0, 0));
        temp3Panel.add(this.cFormat);
        temp2Panel.add("South", temp3Panel);
        this.cContentType = new Choice();
        temp2Panel.add("Center", this.cContentType);
        this.listTarget = new 3(4);
        tempPanel.add("North", temp2Panel);
        tempPanel.add("Center", this.listTarget);
        panelTrack.add("Center", tempPanel);
        this.add("Center", panelTrack);
        this.cbAutoStart = new Checkbox("Auto Start", true);
        this.bOk = new Button("Ok");
        this.bClear = new Button("Clear");
        this.bClose = new Button("Close");
        Panel panelSouth = new Panel();
        panelSouth.setLayout(new BorderLayout());
        tempPanel = new Panel();
        tempPanel.setLayout(new FlowLayout());
        tempPanel.add(this.cbAutoStart);
        tempPanel.add(this.bOk);
        tempPanel.add(this.bClear);
        tempPanel.add(this.bClose);
        panelSouth.add("South", tempPanel);
        this.destinationPanel = new BorderPanel();
        this.destinationPanel.setLayout(new BorderLayout());
        tempPanel = new Panel();
        tempPanel.setLayout(new FlowLayout(0));
        label = new Label("Destination: ");
        CheckboxGroup cbg = new CheckboxGroup();
        this.cbDestFile = new Checkbox("File", true, cbg);
        this.cbDestNetwork = new Checkbox("Network", false, cbg);
        this.cbDestScreen = new Checkbox("Screen", false, cbg);
        tempPanel.add(label);
        tempPanel.add(this.cbDestFile);
        tempPanel.add(this.cbDestNetwork);
        tempPanel.add(this.cbDestScreen);
        this.destinationPanel.add("North", tempPanel);
        this.customPanel = this.createFilePanel(this.outputURL, this.limitSize, this.fileSizeLimit);
        this.destinationPanel.add("South", this.customPanel);
        panelSouth.add("North", this.destinationPanel);
        this.add("South", panelSouth);
        this.bClose.addActionListener(this);
        this.bClear.addActionListener(this);
        this.bOk.addActionListener(this);
        this.bOpenFile.addActionListener(this);
        this.bCapture.addActionListener(this);
        this.bOther.addActionListener(this);
        this.tfInputURL.addActionListener(this);
        this.cbDestFile.addItemListener(this);
        this.cbDestNetwork.addItemListener(this);
        this.cbDestScreen.addItemListener(this);
        this.cTrack.addItemListener(new 4());
        this.cFormat.addItemListener(new 5());
        this.cContentType.addItemListener(new 6());
        this.cbEnabled.addItemListener(new 7());
        this.listTarget.addItemListener(new 8());
        this.doClear();
    }

    private Format[] sortByEncoding(Format[] in) {
        if (in == null || in.length < 2) {
            return in;
        }
        int size = in.length;
        Format[] out = in;
        int i2 = 0;
        while (i2 < size) {
            int j2 = 0;
            while (j2 < size - i2 - 1) {
                String next;
                String current = out[j2].getEncoding().toUpperCase();
                if (current.compareTo(next = out[j2 + 1].getEncoding().toUpperCase()) > 0) {
                    Format tempFormat = out[j2];
                    out[j2] = out[j2 + 1];
                    out[j2 + 1] = tempFormat;
                }
                ++j2;
            }
            ++i2;
        }
        return out;
    }

    private synchronized void doClear() {
        this.setEnabled(true);
        this.waitCursor();
        this.bOpenFile.setEnabled(true);
        this.bCapture.setEnabled(true);
        this.bOther.setEnabled(true);
        this.cTrack.removeAll();
        this.cTrack.add("None");
        this.cTrack.setEnabled(false);
        this.cbEnabled.setState(false);
        this.cbEnabled.setEnabled(false);
        this.cFormat.removeAll();
        this.cFormat.add("None");
        this.cFormat.setEnabled(false);
        this.listTarget.removeAll();
        this.listTarget.setEnabled(false);
        this.taSource.setText("");
        this.cbDestFile.setState(true);
        this.outputTypeChanged();
        this.bOk.setLabel("Save");
        this.bOk.setEnabled(false);
        this.bClear.setEnabled(false);
        this.bClose.setEnabled(true);
        this.tfInputURL.setEnabled(false);
        this.destinationPanel.setEnabled(false);
        if (this.processor != null) {
            this.processor.close();
            this.processor = null;
        }
        this.normalCursor();
    }

    Panel createRTPPanel(String[] address, String[] port) {
        Panel panel = new Panel();
        int size = this.trackEnabled.length;
        panel.setLayout(new GridLayout(size, 1));
        this.tfPort = new TextField[size];
        this.tfAddress = new TextField[size];
        int i2 = 0;
        while (i2 < size) {
            Panel tempPanel = new Panel();
            tempPanel.setLayout(new FlowLayout());
            Label label = new Label("Track " + i2 + "  IP Address: ");
            this.tfAddress[i2] = new TextField(address[i2], 15);
            tempPanel.add(label);
            tempPanel.add(this.tfAddress[i2]);
            label = new Label(" Port : ");
            tempPanel.add(label);
            this.tfPort[i2] = new TextField(port[i2], 5);
            tempPanel.add(this.tfPort[i2]);
            panel.add(tempPanel);
            ++i2;
        }
        return panel;
    }

    Panel createFilePanel(String filename, boolean limitSize, long fileSizeLimit) {
        Panel panel = new Panel();
        panel.setLayout(new BorderLayout());
        Panel tempPanel = new Panel();
        tempPanel.setLayout(new BorderLayout());
        Label label = new Label("Filename: ");
        tempPanel.add("West", label);
        this.tfOutputURL = new TextField();
        ((TextComponent)this.tfOutputURL).setText(filename);
        this.tfOutputURL.addKeyListener(new 9());
        tempPanel.add("Center", this.tfOutputURL);
        this.bBrowse = new Button("Browse...");
        this.bBrowse.addActionListener(this);
        tempPanel.add("East", this.bBrowse);
        panel.add("North", tempPanel);
        tempPanel = new Panel();
        tempPanel.setLayout(new FlowLayout(0));
        this.cbLimitFileSize = new Checkbox("Limit file size ... to ", false);
        this.cbLimitFileSize.setState(limitSize);
        this.cbLimitFileSize.addItemListener(this);
        tempPanel.add(this.cbLimitFileSize);
        this.tfLimit = new TextField(10);
        tempPanel.add(this.tfLimit);
        ((TextComponent)this.tfLimit).setText(Long.toString(fileSizeLimit));
        label = new Label(" KiloBytes");
        tempPanel.add(label);
        panel.add("South", tempPanel);
        this.tfLimit.setEnabled(this.cbLimitFileSize.getState());
        return panel;
    }

    void message(String mess) {
        MessageDialog.createErrorDialog(this.parentFrame, mess);
    }

    public static void main(String[] args) {
        String strSourceUrl = args.length < 1 ? "" : args[0];
        ExportDialog frameExport = new ExportDialog(new Frame(), strSourceUrl);
    }

    private final class 1
    extends WindowAdapter {
        public void windowClosing(WindowEvent we) {
            ExportDialog.this.abortDialog();
        }

        /* synthetic */ 1() {
        }
    }

    private final class 2
    implements ActionListener {
        public void actionPerformed(ActionEvent ae) {
            ExportDialog.this.filewriter.close();
            if (ExportDialog.this.fClose != null) {
                ExportDialog.this.fClose.dispose();
            }
        }

        /* synthetic */ 2() {
        }
    }

    private final class 3
    extends List {
        public Dimension getPreferredSize() {
            Dimension prefSize = super.getPreferredSize();
            if (prefSize.width > 360) {
                prefSize.width = 360;
            }
            return prefSize;
        }

        /* synthetic */ 3(int $0) {
            super($0);
        }
    }

    private final class 4
    implements ItemListener {
        public void itemStateChanged(ItemEvent ie) {
            ExportDialog.this.trackSelected();
        }

        /* synthetic */ 4() {
        }
    }

    private final class 5
    implements ItemListener {
        public void itemStateChanged(ItemEvent ie) {
            ExportDialog.this.encodingSelected();
        }

        /* synthetic */ 5() {
        }
    }

    private final class 6
    implements ItemListener {
        public void itemStateChanged(ItemEvent ie) {
            ExportDialog.this.contentTypeSelected();
        }

        /* synthetic */ 6() {
        }
    }

    private final class 7
    implements ItemListener {
        public void itemStateChanged(ItemEvent ie) {
            ExportDialog.this.trackEnabled();
        }

        /* synthetic */ 7() {
        }
    }

    private final class 8
    implements ItemListener {
        public void itemStateChanged(ItemEvent ie) {
            ExportDialog.this.formatSelected();
        }

        /* synthetic */ 8() {
        }
    }

    private final class 9
    extends KeyAdapter {
        public void keyReleased(KeyEvent ke) {
            ExportDialog.this.checkOK();
        }

        /* synthetic */ 9() {
        }
    }

    class StateListener
    implements ControllerListener {
        public void controllerUpdate(ControllerEvent ce) {
            if (ce instanceof ControllerClosedEvent) {
                ExportDialog.this.setFailed();
            }
            if (ce instanceof ControllerEvent) {
                Integer n2 = ExportDialog.this.getStateLock();
                synchronized (n2) {
                    ExportDialog.this.getStateLock().notifyAll();
                }
            }
        }

        StateListener() {
            ExportDialog.this = ExportDialog.this;
        }
    }

    class BorderPanel
    extends Panel {
        int insets = 7;

        public BorderPanel() {
            ExportDialog.this = ExportDialog.this;
        }

        public BorderPanel(int insets) {
            ExportDialog.this = ExportDialog.this;
            this.insets = insets;
        }

        public Insets getInsets() {
            return new Insets(this.insets, this.insets, this.insets, this.insets);
        }

        public void paint(Graphics g2) {
            if (this.insets != 0) {
                Color bc = this.getBackground();
                super.paint(g2);
                Dimension size = this.getSize();
                g2.setColor(bc.darker());
                g2.drawLine(2, 2, size.width - 3, 2);
                g2.drawLine(2, 2, 2, size.height - 3);
                g2.setColor(bc.brighter());
                g2.drawLine(size.width - 3, 2, size.width - 3, size.height - 3);
                g2.drawLine(2, size.height - 3, size.width - 3, size.height - 3);
            }
        }
    }
}

